#include"funnie.h"

struct PARTICLE{
	V3D_f pos,spd;
	RGB color;
	int life;
	struct PARTICLE *next;
};

PARTICLE *particles;



void init_particles(){
	particles=NULL;
}



void shutdown_particles(){
	PARTICLE *p;
	while(particles){
		p=particles;
		particles=particles->next;
		delete p;
	}
}



void fire_particles(V3D_f pos,V3D_f spd,RGB color,int n){
	PARTICLE *p;
	for(int i=0;i<n;i++){
		p=new PARTICLE();
		p->pos=pos;
		p->spd.x=(cos(rand()%256)+spd.x)/10;
		p->spd.y=(sin(rand()%256)+spd.y)/10;
		p->spd.z=(sin(rand()%256)+spd.z)/10;
		p->color=color;
		p->life=100;
		p->next=particles;
		particles=p;
	}
}



void update_particles(){
	PARTICLE **p = &particles;
	PARTICLE *d = particles;
	PARTICLE *tmp;

	int r,g,b;

	while (d) {
		d->pos.x += d->spd.x;
		d->pos.y += d->spd.y;
		d->pos.z += d->spd.z;
		d->life--;
		if(!d->life) {
			*p=d->next;	//Change the previous bullets next to this bullets next
			tmp = d;	//temp point to this bullet
			d = d->next;	//forward b
			free(tmp);	//free the unused bullet
		}
		else {
			p = &d->next;	//Make p point to the next of this bullet before 
			d = d->next;	//Moving the b pointer to the next bullet
		}
	}
}



void draw_particles(BITMAP *buffer,ZBUFFER *zbuf,MATRIX_f matrix){
	PARTICLE *p=particles;

	V3D_f vtx;

	set_projection_viewport(0, 0, buffer->w, buffer->h);

	int z,c;

	while(p){
		vtx=p->pos;

		apply_matrix_f(&matrix,vtx.x,vtx.y,vtx.z,&vtx.x,&vtx.y,&vtx.z);
		if((0<vtx.z) && (-vtx.z<vtx.x && vtx.z>vtx.x) && (-vtx.z<vtx.y && vtx.z>vtx.y)){
			persp_project_f(vtx.x,vtx.y,vtx.z,&vtx.x,&vtx.y);

			z=getpixel(zbuf,int(vtx.x),int(vtx.y));
			if(z==0 || z>vtx.z){
				c=makecol(max(0,p->color.r-int(vtx.z/4)),max(0,p->color.g-int(vtx.z/4)),max(0,p->color.b-int(vtx.z/4)));
				putpixel(buffer,int(vtx.x),int(vtx.y),c);
				putpixel(zbuf,int(vtx.x),int(vtx.y),int(vtx.z));
			}
		}

		p=p->next;
	}
}
