/*
 *    SPEED - by Shawn Hargreaves, 1999
 *
 *    Text message displaying functions.
 */
//Edited by Trezker for mffonoid

#include"message.h"



list<MESSAGE> msgs;



/* adds a new message to the display */
MESSAGE::MESSAGE(char *itext,double ix,double iy){
	strcpy(text, itext);
	time = 0;
	x = ix;
	y = iy;
}



/* updates the message position */
void update_message(){
	list<MESSAGE>::iterator msg=msgs.begin();

	for(;msg!=msgs.end();){
		if(msg->time <= 100) 
			msg->y+=msg->time/10000.0;
		msg->time++;

		if(msg->time>100)
			msg=msgs.erase(msg);
		else
			msg++;
	}
}



/* draws messages */
void draw_message(BITMAP *bmp, int r, int g, int b, int (*project)(float *f, int *i, int c)){
	list<MESSAGE>::iterator m = msgs.begin();
	float shape[2];
	int ishape[2];
	int ir,ig,ib;

	for(;m!=msgs.end();m++){
		shape[0] = m->x;
		shape[1] = m->y;

		ir=0>r-m->time-100 ? 0 : r-m->time-100;
		ig=0>g-m->time-100 ? 0 : g-m->time-100;
		ib=0>b-m->time-100 ? 0 : b-m->time-100;
		if (project(shape, ishape, 2))
			textout_centre(bmp, font, m->text, ishape[0],ishape[1], makecol(ir,ig,ib));
	}
}
