#include<list>
using namespace std;
#include<allegro.h>

#include"main.h"
#include"view.h"
#include"block.h"
#include"player.h"
#include"mouse.h"
#include"editor.h"
#include"play.h"

int ovm,ogm;
list<BLOCK> eblocks;

void editor(BITMAP *buffer){
	//So that we can see invisible blocks
	bool reset_cheat=!cheat;
	cheat=1;
	init_players();
	ovm=viewmode;
	viewmode=0;
	ogm=gamemode;
	gamemode=1;
	BLOCK tb(mouse_x/(float)SCREEN_W,mouse_y/(float)SCREEN_H,1,makecol(255,255,255));
	int found;
	int r=255,g=255,b=255;

	while(!key[KEY_ESC]){
		poll_keyboard();
		tb.x=(mouse_x*16/SCREEN_W)/16.0;
		tb.y=((SCREEN_H-mouse_y)*16/SCREEN_H)/16.0;
		if(tb.y<3/16.0 || tb.y>14/16.0)
			tb.y=0;

		update_mouse();
		if(mouse_u&1 && tb.y){
			found=0;
			list<BLOCK>::iterator i;
			for(i=eblocks.begin() ; i!=eblocks.end() ; i++){
				if(tb.x==i->x && tb.y==i->y){
					found=1;
					break;
				}
			}
			if(!found && tb.strength){
				eblocks.push_back(tb);
			}
			if(found && !tb.strength){
				eblocks.erase(i);
			}
		}
		if(!tb.y){
			if(mouse_b&1){
				//Color change
				if(mouse_y>SCREEN_H-24 && mouse_y<SCREEN_H-15 && mouse_x<256)
					r=mouse_x;
				if(mouse_y>SCREEN_H-16 && mouse_y<SCREEN_H-7 && mouse_x<256)
					g=mouse_x;
				if(mouse_y>SCREEN_H-8 && mouse_x<256)
					b=mouse_x;
				tb.color=makecol(r,g,b);

				//Strength
				if(mouse_y>SCREEN_H-64 && mouse_x>280 && mouse_x<320)
					tb.strength=(SCREEN_H-mouse_y)/8-2;
			}
		}

		if(key[KEY_L])
			load_level();

		if(key[KEY_S])
			save_level();

		if(key[KEY_P]){
			while(key[KEY_P])
				poll_keyboard();
			play_game(buffer);
			init_players();
		}

		draw_view(buffer);
		next_level();
//		textprintf(buffer,font,0,0,-1,"%f %f",x1,x2);
		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		if(!tb.y){
			show_mouse(buffer);
			tb.y=3/16.0;
			tb.draw(buffer, 255, 0, 0, project_flat);
		}
		else
			tb.draw(buffer, 255, 0, 0, project_flat);
		solid_mode();
		//Color
		rect(buffer,0,SCREEN_H-24,255,SCREEN_H-17,makecol(r,0,0));
		rect(buffer,0,SCREEN_H-16,255,SCREEN_H-9,makecol(0,g,0));
		rect(buffer,0,SCREEN_H-8,255,SCREEN_H-1,makecol(0,0,b));
		textprintf(buffer,font,r>208?208:r,SCREEN_H-24,makecol(255,0,0),"R: %i",r);
		textprintf(buffer,font,g>208?208:g,SCREEN_H-16,makecol(0,255,0),"G: %i",g);
		textprintf(buffer,font,b>208?208:b,SCREEN_H-8,makecol(0,0,255),"B: %i",b);
		//Strength
		textprintf(buffer,font,280,SCREEN_H-24-tb.strength*8,makecol(0,0,255),"S: %i",tb.strength);

		blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
		show_mouse(NULL);
	}
	while(key[KEY_ESC])
		poll_keyboard();

	if(reset_cheat)
		cheat=0;

	viewmode=ovm;
	gamemode=ogm;
}



int lvl_ver=1;



void save_level(){
	char path[80*6]="",apa[80*6],sc[16]="Miffonoid level";
	if( file_select_ex("Save level", path, "LVL", 80*6, 320, 200) ){
		replace_extension(apa, path, "lvl", 80*6);
		if( exists(apa) ){
			//Ask for overwrite permission
		}
		PACKFILE *file=pack_fopen(apa, F_WRITE);
		//Write the format
		pack_fwrite((void *)sc,16, file);
		pack_iputw(lvl_ver,file);

		//The data
		pack_iputw(eblocks.size(),file);
		for(list<BLOCK>::iterator i=eblocks.begin() ; i!=eblocks.end() ; i++){
			pack_iputl(ftofix(i->x),file);
			pack_iputl(ftofix(i->y),file);
			pack_iputw(i->strength,file);
			pack_iputw(i->color,file);
		}

/*		double x,y;	//Position
		int strength;	//How many hits can it take
		int color;		//I might want to make this thing pretty
*/
		pack_fclose(file);
	}
}



void broken_level(PACKFILE *file){
	allegro_message("This is a broken file or not a Miffonoid level file");
	pack_fclose(file);
}



void load_level(){
	char path[80*6]="",sc[16];
	int version;
	if( file_select_ex("Load level", path, "LVL", 80*6, 320, 200) )
		if( exists(path) ){
			PACKFILE *file=pack_fopen(path, F_READ);
			//Check for correct format
			pack_fread((void *)sc,16, file);
			if(strcmp(sc,"Miffonoid level")){
				broken_level(file);
				return;
			}
			version=pack_igetw(file);
			if(version>lvl_ver){
				allegro_message("You will need a later version of Miffonoid to load this level.");
				pack_fclose(file);
				return;
			}
			if(version<lvl_ver){
				allegro_message("This level is in an old format. Hopefully I have coded a correct loading routine for it.");
				pack_fclose(file);
				return;
			}
			eblocks.clear();
			//Load data
			int nb=pack_igetw(file);
			BLOCK tb(1,1,1,1);
			switch(version){
				case 1:
					for(int i=0 ; i<nb ; i++){
						tb.x=fixtof(pack_igetl(file));
						tb.y=fixtof(pack_igetl(file));
						tb.strength=pack_igetw(file);
						tb.color=pack_igetw(file);
						eblocks.push_back(tb);
					}
					break;
				default:
					allegro_message("This file has an unknown format, that's strange.");
					break;
			}
			pack_fclose(file);
		}
}
