#include "TW.h"


void alloc_terrain_mem(){
    tv=(terrain_vertex_struct *)malloc(num_tvs *sizeof(terrain_vertex_struct));
    jnt=(jnt_struct *)malloc(num_jnts*sizeof(jnt_struct));
    ply=(ply_struct *)malloc(num_plys*sizeof(ply_struct));
    bdr=(bdr_struct *)malloc(num_bdrs*sizeof(bdr_struct));
    pnt=(pnt_struct *)malloc(num_pnts*sizeof(pnt_struct));
    dad=(dad_struct *)malloc(num_dads*sizeof(dad_struct));
    jnt_list=(int *)malloc(num_jnts*4*sizeof(int)); // assumes each jnt passes through an average of 4 regions (most likely only 2 in reality)
    ply_list=(int *)malloc(num_plys*4*sizeof(int)); 
    bdr_list=(int *)malloc(num_bdrs*4*sizeof(int));
    pnt_list=(int *)malloc(num_pnts*sizeof(int)); 
    region=(region_struct *)malloc(map_sx*map_sy*sizeof(region_struct));
    
    clear_pnts();
    load_plain_level();
}

void free_terrain_mem(){
    free(tv);
    free(jnt);
    free(ply);
    free(bdr);
    free(pnt);
    free(dad);
    free(region);
    free(jnt_list);
    free(ply_list);
    free(bdr_list);
    free(pnt_list);
}


void load_plain_level(){
    int n,m;

    for(n=0;n<num_tvs;n++)tv[n].state=0,
                          tv[n].x=0,
                          tv[n].y=0;
                    
    for(n=0;n<num_jnts;n++)jnt[n].state=0,
                           jnt[n].tvn[0]=0,
                           jnt[n].tvn[1]=0,
                           jnt[n].njnt[0]=-1,
                           jnt[n].njnt[1]=-1,
                           jnt[n].type=0;
    
    for(n=0;n<num_plys;n++)ply[n].state=0,
                           ply[n].tvn[0]=0,
                           ply[n].tvn[1]=0,
                           ply[n].tvn[2]=0,
                           ply[n].tvn[3]=0,
                           ply[n].type=0,
                           ply[n].x=0;



    for(n=0;n<num_bdrs;n++)bdr[n].state=0,
                           bdr[n].tvn[0]=0,
                           bdr[n].tvn[1]=0,
                           bdr[n].tva[0]=0,
                           bdr[n].tva[1]=0,
                           bdr[n].type=0,
                           bdr[n].x=0,
                           bdr[n].tex_len=0,
                           bdr[n].last_b=-1,
                           bdr[n].next_b=-1,
                           bdr[n].tex_offset=0;
                           
                           
    for(n=0;n<num_dads;n++)dad[n].state=0,
                           dad[n].px=0,
                           dad[n].py=0,
                           dad[n].pic=0,
                           dad[n].type=0,
                           dad[n].layer=0,
                           dad[n].ang=0,
                           dad[n].sx=32,
                           dad[n].sy=32;
                   
    update_region_jnts();
    update_region_bdrs();
    update_region_plys();
}




void load_terrain(int lev){
    FILE *fh;
    int n,m,x[10];

    load_plain_level();
    
    loadn("map~",lev,2);
    fh=fopen(xnam,"rb");
    if(fh==NULL)return; 
    
    
    fread(x,sizeof(int),10,fh);  //read header

    
 
    
    for(n=0;n<x[0];n++){
        fread(&m,sizeof(int),1,fh);
        fread(&tv[m],sizeof(terrain_vertex_struct),1,fh);
    }
    
    for(n=0;n<x[1];n++){
        fread(&m,sizeof(int),1,fh);
        fread(&jnt[m],sizeof(jnt_struct),1,fh);
    }
    
    for(n=0;n<x[2];n++){
        fread(&m,sizeof(int),1,fh);
        fread(&ply[m],sizeof(ply_struct),1,fh);
    }
    
    for(n=0;n<x[3];n++){
        fread(&m,sizeof(int),1,fh);
        fread(&bdr[m],sizeof(bdr_struct),1,fh);
    }
    
    for(n=0;n<x[4];n++){
        fread(&m,sizeof(int),1,fh);
        fread(&dad[m],sizeof(dad_struct),1,fh);
    }
    
    for(n=0;n<x[5];n++){
        fread(&m,sizeof(int),1,fh);
        fread(&wpt[m],sizeof(wpt_struct),1,fh);
    }
    
    for(n=0;n<x[6];n++){
        fread(&m,sizeof(int),1,fh);
        fread(&bonus[m],sizeof(bonus_struct),1,fh);
    }
    
    
    fclose(fh);

    update_region_jnts();
    update_region_bdrs();
    update_region_plys();
}



//editor func
void save_terrain(int lev){
    FILE *fh;
    int n,x[10];


    loadn("map~",lev,2);

    fh=fopen(xnam,"wb");
    if(fh==NULL)return;
    
    //count num of bdrs,plys,tvs etc
    for(n=0;n<10;n++)x[n]=0;
    for(n=0,x[0]=0;n<num_tvs ;n++)if(tv[n].state )x[0]++;
    for(n=0,x[1]=0;n<num_jnts;n++)if(jnt[n].state)x[1]++;
    for(n=0,x[2]=0;n<num_plys;n++)if(ply[n].state)x[2]++;
    for(n=0,x[3]=0;n<num_bdrs;n++)if(bdr[n].state)x[3]++;
    for(n=0,x[4]=0;n<num_dads;n++)if(dad[n].state)x[4]++;
    for(n=0,x[5]=0;n<1000;n++)if(wpt[n].state)x[5]++;
    for(n=0,x[6]=0;n<1000;n++)if(bonus[n].state)x[6]++;
   
    fwrite(x,sizeof(int),10,fh);  //write header
    
    for(n=0;n<num_tvs;n++)if(tv[n].state){
        fwrite(&n,sizeof(int),1,fh);
        fwrite(&tv[n],sizeof(terrain_vertex_struct),1,fh);
    }
    
    for(n=0;n<num_jnts;n++)if(jnt[n].state){
        fwrite(&n,sizeof(int),1,fh);
       fwrite(&jnt[n],sizeof(jnt_struct),1,fh);
    }
    
    for(n=0;n<num_plys;n++)if(ply[n].state){
        fwrite(&n,sizeof(int),1,fh);
        fwrite(&ply[n],sizeof(ply_struct),1,fh);
    }
    
    for(n=0;n<num_bdrs;n++)if(bdr[n].state){
        fwrite(&n,sizeof(int),1,fh);
        fwrite(&bdr[n],sizeof(bdr_struct),1,fh);
    }
    
    for(n=0;n<num_dads;n++)if(dad[n].state){
        fwrite(&n,sizeof(int),1,fh);
        fwrite(&dad[n],sizeof(dad_struct),1,fh);
    }
    
    for(n=0;n<1000;n++)if(wpt[n].state){
        fwrite(&n,sizeof(int),1,fh);
        fwrite(&wpt[n],sizeof(wpt_struct),1,fh);
    }
    
    for(n=0;n<1000;n++)if(bonus[n].state){
        fwrite(&n,sizeof(int),1,fh);
        fwrite(&bonus[n],sizeof(bonus_struct),1,fh);
    }
    
    



    
    fclose(fh);

}




int new_tv(double x,double y){
    int n;
    for(n=0;n<num_tvs;n++)if(!tv[n].state){
        tv[n].x=x;
        tv[n].y=y;
        tv[n].state=1;
        return(n);
    }

    return(0);
}




//returns true if and only if the line passes throught the region rx,ry
int line_in_region(double x1,double y1,double x2,double y2,int rx,int ry){
    double xmin,ymin,xmax,ymax; //define the square making up the region



    xmin=rx;
    ymin=ry;

    xmax=xmin+1;
    ymax=ymin+1;

    //the geniosity here is great.
    if((x1 >= xmin && x1 < xmax && y1 >= ymin && y1 < ymax)|| //pnt 1 is in the region
       (x2 >= xmin && x2 < xmax && y2 >= ymin && y2 < ymax)|| //pnt 2 is in the region
       (!same_side_of_line(xmin,ymin,xmax,ymin,x1,y1,x2,y2)&&!same_side_of_line(x1,y1,x2,y2,xmin,ymin,xmax,ymin))||
       (!same_side_of_line(xmax,ymin,xmax,ymax,x1,y1,x2,y2)&&!same_side_of_line(x1,y1,x2,y2,xmax,ymin,xmax,ymax))||
       (!same_side_of_line(xmax,ymax,xmin,ymax,x1,y1,x2,y2)&&!same_side_of_line(x1,y1,x2,y2,xmax,ymax,xmin,ymax))||
       (!same_side_of_line(xmin,ymax,xmin,ymin,x1,y1,x2,y2)&&!same_side_of_line(x1,y1,x2,y2,xmin,ymax,xmin,ymin)))
        return(1);
        
        
   return(0);

}




//returns 1 if they are on the same side, else 0
int same_side_of_line(double px1,double py1,double px2,double py2,double ax,double ay,double bx,double by){
    double dx,dy,grad;
    double i; //x or y value at intersect

    dx=px2-px1;
    dy=py2-py1;

    ax-=px1;
    ay-=py1;

    bx-=px1;
    by-=py1;

    if(dx>=dy){
        grad=dy/dx;
        if((ay-(ax*grad)) * (by-(bx*grad))>0)return (1); else return (0);
    } else {
        grad=dx/dy;
        if((ax-(ay*grad)) * (bx-(by*grad))>0)return (1); else return (0);
    }

}




