#include "TW.h"

double absf(double x){
if(x>=0)return(x); else return(-x);
}

double dist(double x1,double y1,double x2,double y2){
   return(sqrt(  (x2-x1)*(x2-x1)+(y2-y1)*(y2-y1)  ));
} 


void rot_point(double px,double py,double pivot_x,double pivot_y,double ang,double *nx,double *ny){
    double dy,dx,a,d;

    if(ang==0){
    (*nx)=px;
    (*ny)=py;
    return;
    }
    
    dx=px-pivot_x;
    dy=py-pivot_y;
    
    (*nx)=pivot_x + (dx*cos(ang) - dy * sin(ang));
    (*ny)=pivot_y + (dx*sin(ang) + dy * cos(ang));
    

}




void tmap(double x1,double y1,
          double x2,double y2,
          double x3,double y3,
          double x4,double y4,GLuint tex,double px,double py,double ang,int flip){
          
    px+=x1;
    py+=y1;

    rot_point(x1,y1,px,py,ang,&x1,&y1);
    rot_point(x2,y2,px,py,ang,&x2,&y2);
    rot_point(x3,y3,px,py,ang,&x3,&y3);
    rot_point(x4,y4,px,py,ang,&x4,&y4);

          
          

    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D,tex);

    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR); 
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR);

    
 
  
    switch(flip){
    
    case 0:
    
        glBegin(GL_QUADS);  
          glTexCoord2f(0.01, 0.99);
          glVertex2f(x1,y1);
          glTexCoord2f(0.01, 0.01);
          glVertex2f(x2,y2);
          glTexCoord2f(0.99, 0.01);
          glVertex2f(x3,y3);
          glTexCoord2f(0.99,0.99);
          glVertex2f(x4,y4);
        glEnd();   

        
    break;
        
    case 1:
    
        glBegin(GL_QUADS);  
          glTexCoord2f(0.99, 0.99);
          glVertex2f(x1,y1);
          glTexCoord2f(0.99, 0.01);
          glVertex2f(x2,y2);
          glTexCoord2f(0.01, 0.01);
          glVertex2f(x3,y3);
          glTexCoord2f(0.01,0.99);
          glVertex2f(x4,y4);
        glEnd();   
    
    break;
        
    }
        
    

          
	
}

