typedef struct terrain_vertex_struct{
float x,y;
char state;
}terrain_vertex_struct;

typedef struct jnt_struct{
char state;  // 1 = not yet added, 2 = added
int tvn[2];  //could be unsigned short
int njnt[2]; //adjacent joints (-1)=no adjacent joint
short int type;
}jnt_struct;

typedef struct ply_struct{
char state;
int tvn[4];  //could be unsigned short
//double tx[3]; //texture coords at verts
//double ty[3];
short int type;
short int x; //just another parameter of type (eg for type 1 (wrapping textures) it is the # of the texture
char layer;
}ply_struct;

typedef struct pnt_struct{
int type; //eg maybe 1=main char, 2=walking enemy etc. could be short
int r;    //radius squared could be short
int n;    //eg if it is an enemy than this is which enemy it is
//int r_list_n; //offset into regions list
//int r_list_x; //num of regions it's in
int pnt_reg; //which region it is in
double x,y;
char state;
}pnt_struct;





typedef struct bdr_struct{
char state;
int tvn[2];  //could be unsigned short
int tva[2]; //these are tv perp to border
short int last_b; //-1 means it's the first of the piece
short int next_b; //-1 means it's the last of the piece
//char scale; //to scale it down a bit for horizontal shift
short int type;
short int x;  //texture
short int wpn;
float tex_offset;
float tex_len; //(length of border strip / texture length )  * const
}bdr_struct;

typedef struct vect_struct{
double x,y;
}vect_struct;




typedef struct dad_struct{
char state;
float px,py;
float ang;
int pic;
int type;
short int sx,sy;  //texture size
char layer;
}dad_struct;




typedef struct region_struct{

int jnt_n; //offset
short int jnt_x; //number

int pnt_n; //offset
short int pnt_x; //number

int ply_n; //offset
short int ply_x; //number

int bdr_n; //offset
short int bdr_x; //number

short int obs_added; //is a temp value used for creating the lists
}region_struct;



typedef struct bodp_struct{  //body parts
  char state;
  int pntn;
  double x;
  double y;
  double rad;
  double mass;
}bodp_struct;



typedef struct body_struct{
    char state;
    int fdir;
    double x,y;
    double xx,yy;
    double xx_old,yy_old;
    double ang;
    double draw_ang;
    double ang_v,ang_v_old;
    
    int jntn;     //which jnt the body is walking on -1 = none
    double jntx;   //how far along (0,1)
    double jntvx;  //speed along the slope
    double jntvx_old; //old of above
    int foot; //which bodp is the foot
    double h; // height of centre above jnt while on a jnt
    
    vect_struct vdir; //a unit vector in the direction of the jnt (after it has been curved)
    bodp_struct bodp[8];
}body_struct;


typedef struct wpt_struct{
    char state;
    double px,py;
    int cnt;
}wpt_struct;


typedef struct bonus_struct{
    char state;
    double px;
    double py;
    short int type;
}bonus_struct;

typedef struct particle_struct{
    char state;
    double px;
    double py;
    double xx;
    double yy;
    short int type;
    short int cnt;
    short int a;
}particle_struct;


typedef struct bees_struct{
    char state;
    float px,py,xx,yy;
    short int pn[25];
    int cnt,stage,bites_given;
    float hx,hy;
}bees_struct;


