#include "TW.h"


static void (*ply_drawing_func[20])(int plyn);  //array of pointers to functions for drawing polys

//type 0 = wrapping triangle
//type 1 = fixed quad



void update_region_plys(){
    int n,a,b;
    int quad;
    double x1,y1,x2,y2,x3,y3,x4,y4;
    double xmin,xmax,ymin,ymax;
    
    
    
    //set num plys in each region to 0
    for(b=0;b<map_sy;b++){
    for(a=0;a<map_sx;a++){
        region[b*map_sx+a].ply_x=0;
        region[b*map_sx+a].obs_added=0;
    }}
    
    
    
    //count number of joint in each region
    for(n=0;n<num_plys;n++)if(ply[n].state){
        
        quad=0;
        if(ply[n].type==1)quad=1;
    
        
        x1=(tv[ply[n].tvn[0]].x+80)*1.25;
        y1=(tv[ply[n].tvn[0]].y+40)*1.25;
        x2=(tv[ply[n].tvn[1]].x+80)*1.25;
        y2=(tv[ply[n].tvn[1]].y+40)*1.25;
        x3=(tv[ply[n].tvn[2]].x+80)*1.25;
        y3=(tv[ply[n].tvn[2]].y+40)*1.25;
        
        
        xmin=min(x1,min(x2,x3));
        ymin=min(y1,min(y2,y3));
        xmax=max(x1,max(x2,x3));
        ymax=max(y1,max(y2,y3));
        
        if(quad){  //for quads
            x4=tv[ply[n].tvn[3]].x;
            y4=tv[ply[n].tvn[3]].y;
            
            xmin=min(x4,xmin);
            ymin=min(y4,ymin);
            xmax=max(x4,xmax);
            ymax=max(y4,ymax);
        }
        
  

        if(xmin<0)xmin=0;
        if(ymin<0)ymin=0;
        if(xmax>map_sx)xmax=map_sx-1;
        if(ymax>map_sy)ymax=map_sy-1;


        for(b=(int)ymin;b<=(int)ymax;b++){
        for(a=(int)xmin;a<=(int)xmax;a++){
            if(line_in_region(x1,y1,x2,y2,a,b)||
               line_in_region(x2,y2,x3,y3,a,b)||
               line_in_region(x3,y3,x1,y1,a,b)||
               (quad&&(line_in_region(x3,y3,x4,y4,a,b)||line_in_region(x4,y4,x1,y1,a,b)) ))region[b*map_sx+a].ply_x++;
        }}

    }
    
    //setup offset into ply_list
    for(n=0,a=0;n<map_sx*map_sy;n++){
        region[n].ply_n=a;
        a+=region[n].ply_x;
    }

    //actually add plys to the list 
    for(n=0;n<num_plys;n++)if(ply[n].state){
    
        quad=0;
        if(ply[n].type==1)quad=1;
    
    
        x1=(tv[ply[n].tvn[0]].x+80)*1.25;
        y1=(tv[ply[n].tvn[0]].y+40)*1.25;
        x2=(tv[ply[n].tvn[1]].x+80)*1.25;
        y2=(tv[ply[n].tvn[1]].y+40)*1.25;
        x3=(tv[ply[n].tvn[2]].x+80)*1.25;
        y3=(tv[ply[n].tvn[2]].y+40)*1.25;
        

        
        xmin=min(x1,min(x2,x3));
        ymin=min(y1,min(y2,y3));
        xmax=max(x1,max(x2,x3));
        ymax=max(y1,max(y2,y3));
        
        if(quad){  //for quads
            x4=tv[ply[n].tvn[3]].x;
            y4=tv[ply[n].tvn[3]].y;
            
            xmin=min(x4,xmin);
            ymin=min(y4,ymin);
            xmax=max(x4,xmax);
            ymax=max(y4,ymax);
        }
        


        if(xmin<0)xmin=0;
        if(ymin<0)ymin=0;
        if(xmax>map_sx)xmax=map_sx-1;
        if(ymax>map_sy)ymax=map_sy-1;


        for(b=(int)ymin;b<=(int)ymax;b++){
        for(a=(int)xmin;a<=(int)xmax;a++){
            if(line_in_region(x1,y1,x2,y2,a,b)||
               line_in_region(x2,y2,x3,y3,a,b)||
               line_in_region(x3,y3,x1,y1,a,b)||
               (quad&&(line_in_region(x3,y3,x4,y4,a,b)||line_in_region(x4,y4,x1,y1,a,b)) ))ply_list[region[b*map_sx+a].ply_n+region[b*map_sx+a].obs_added]=n,
                                                                                           region[b*map_sx+a].obs_added++;
        }}

    }   



}





void draw_plys(int layer){
    int n,m,a;
    double min_x,max_x,min_y,max_y,sx,sy;
    int N,x;
    
    

    rot_point(scr_px,scr_py,0,0,-world_ang*J_PI/(double)180,&sx,&sy);
   
    min_x=(sx+78)*1.25;
    min_x-=1;

    min_y=(sy+38.5)*1.25;
    min_y-=1;

    max_x=(sx+82)*1.25;
    max_x+=1;

    max_y=(sy+41.5)*1.25;
    max_y+=1;

    if(min_x<0)min_x=0;
    if(min_y<0)min_y=0;
    if(max_x>map_sx)max_x=map_sx-1;
    if(max_y>map_sy)max_y=map_sy-1;
    


    //firstly clear used h_table values (much faster than clearing the whole of the h_table
    for(m=min_y;m<max_y;m++){
    for(n=min_x;n<max_x;n++){
    
    N=region[m*map_sx+n].ply_n;
    x=region[m*map_sx+n].ply_x;
    
        for(a=N;a<N+x;a++)h_table[ply_list[a]]=0;
    }}
    
    //now draw polys, not drawing ones that have already been used (by use of hash table)
    
    for(m=min_y;m<max_y;m++){
    for(n=min_x;n<max_x;n++){
    
    N=region[m*map_sx+n].ply_n;
    x=region[m*map_sx+n].ply_x;
    
        for(a=N;a<N+x;a++)if(!h_table[ply_list[a]]&&ply[ply_list[a]].layer==layer){
            h_table[ply_list[a]]=1;
            (*ply_drawing_func[  ply[ply_list[a]].type  ])(ply_list[a]);
        }
    }}





}





void draw_ply_0(int plyn){
    
    GLfloat w,h;


    trans_map();
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D,terrain_tex[ply[plyn].x]);
    glGetTexLevelParameterfv(GL_TEXTURE_2D,0, GL_TEXTURE_WIDTH, &w); //get width
    glGetTexLevelParameterfv(GL_TEXTURE_2D,0, GL_TEXTURE_HEIGHT,&h); //get height
    glColor3f (1.0, 1.0, 1.0);
    selected_poly(plyn); //editor func
    

    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR); 
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);	
    glBegin(GL_TRIANGLES);  
    glTexCoord2f(0,1);


        glTexCoord2f(tv[ply[plyn].tvn[0]].x/((double)w*0.012),tv[ply[plyn].tvn[0]].y/((double)h*0.012));
        glVertex2f(tv[ply[plyn].tvn[0]].x,tv[ply[plyn].tvn[0]].y);  
        
        glTexCoord2f(tv[ply[plyn].tvn[1]].x/((double)w*0.012),tv[ply[plyn].tvn[1]].y/((double)h*0.012));
        glVertex2f(tv[ply[plyn].tvn[1]].x,tv[ply[plyn].tvn[1]].y);      
        
        glTexCoord2f(tv[ply[plyn].tvn[2]].x/((double)w*0.012),tv[ply[plyn].tvn[2]].y/((double)h*0.012));
        glVertex2f(tv[ply[plyn].tvn[2]].x,tv[ply[plyn].tvn[2]].y);
        
    glEnd();

  
}

void draw_ply_1(int plyn){


    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D,terrain_tex[ply[plyn].x]);
    glColor3f (1.0, 1.0, 1.0);
    selected_poly(plyn); //editor func

    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR); 
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);	


    glBegin(GL_QUADS);  
     glColor4f(1.0,1.0,1.0,0.1);
        glTexCoord2f(0,1);
        glVertex2f(tv[ply[plyn].tvn[0]].x,tv[ply[plyn].tvn[0]].y);
        glTexCoord2f(0,0);
        glColor4f(1.0,1.0,1.0,1);
        glVertex2f(tv[ply[plyn].tvn[1]].x,tv[ply[plyn].tvn[1]].y);
        glTexCoord2f(1,0);
        glVertex2f(tv[ply[plyn].tvn[2]].x,tv[ply[plyn].tvn[2]].y);
        glColor4f(1.0,1.0,1.0,0.1);
        glTexCoord2f(1,1);
        glVertex2f(tv[ply[plyn].tvn[3]].x,tv[ply[plyn].tvn[3]].y);
        
    glEnd();
    

}

void init_ply_drawing_funcs(){
ply_drawing_func[0]=draw_ply_0;
ply_drawing_func[1]=draw_ply_1;
}


void new_ply(int tvn1,int tvn2,int tvn3,int tvn4,int type,int x,int layer){
    int n;
    for(n=0;n<num_plys;n++)if(!ply[n].state){
        if(tvn4==-1){
            if(get_tri_dir(tvn1,tvn2,tvn3)!=1){
                ply[n].tvn[0]=tvn2;
                ply[n].tvn[1]=tvn1;
                ply[n].tvn[2]=tvn3;
                
                ply[n].tvn[3]=tvn4;
            } else {
    
                ply[n].tvn[0]=tvn1;
                ply[n].tvn[1]=tvn2;
                ply[n].tvn[2]=tvn3;
                
                ply[n].tvn[3]=tvn4;
            }
    
        }   else {
            ply[n].tvn[0]=tvn1;
            ply[n].tvn[1]=tvn2;
            ply[n].tvn[2]=tvn3;
            ply[n].tvn[3]=tvn4;
        
        }
        
                  
            
        ply[n].type=type;
        ply[n].x=x;  
        ply[n].state=1;
        ply[n].layer=layer;
        break;
    }
    
}


void delete_ply(int n){
   ply[n].state=0;
   update_region_plys();

}

