#include "TW.h"

//possibly only a prototype for bodies







double tri_num(int x){
    return((x+1)/2);
}




double pos_only(double x){
  if(x>0)return(x);
  return(0);
}









//when deleting a body remember to free pnts corresponding to body parts...

void alloc_body_mem(){
  body=(body_struct *)malloc(num_bodies*sizeof(body_struct));
}

void free_body_mem(){
  free(body);
}

void clear_bodies(){
  int n,m;
  
  for(n=0;n<num_bodies;n++){
    body[n].state=0;
    for(m=0;m<8;m++){
      body[n].bodp[m].state=0;
    }
  }
  
  
}

int new_body(double x,double y,double xx,double yy,double ang,double ang_v){
  int n,m;
  
  for(n=0;n<num_bodies;n++)if(!body[n].state){
    body[n].state=1;
    body[n].x=x;
    body[n].y=y;
    body[n].xx=xx;
    body[n].yy=yy;
    body[n].xx_old=0;
    body[n].yy_old=0;
    
    body[n].ang=ang;
    body[n].ang_v=ang_v;
    body[n].ang_v_old=0;
    
    
    for(m=0;m<8;m++){
      body[n].bodp[m].state=0;
    }
    
    //for test (below)
    
    
    body[n].fdir=f[15];
    body[n].x=f[1];
    body[n].y=f[2];
    body[n].xx=0;
    body[n].yy=0;
    body[n].ang=f[3];
    body[n].ang_v=0;
    
    body[n].bodp[0].state=1;
    body[n].bodp[0].rad=(double)22/180;
    body[n].bodp[0].x=0;
    body[n].bodp[0].y=-(double)20/180;
    body[n].bodp[0].mass=1;
    body[n].bodp[0].pntn=new_pnt(0,0,24,0,0);
    
    body[n].bodp[1].state=1;
    body[n].bodp[1].rad=(double)22/180;
    body[n].bodp[1].x=0;
    body[n].bodp[1].y=(double)20/180;
    body[n].bodp[1].mass=1;
    body[n].bodp[1].pntn=new_pnt(0,0,24,0,0);
    
    body[n].bodp[2].state=1;
    body[n].bodp[2].rad=(double)21/180;
    body[n].bodp[2].x=-(double)8/180;
    body[n].bodp[2].y=0;
    body[n].bodp[2].mass=1;
    body[n].bodp[2].pntn=new_pnt(0,0,24,0,0);
    
  
  
    body[n].h=(double)44/180;
    body[n].foot=1;
    //for test (above)
    
    //load_body_parts();
    
    body[n].jntn=-1;
    body[n].jntx=0;
    body[n].jntvx=0;
    
    return(n);
  }

  
  
  return(0);
}



void delete_body(int n){
  int m;
  
  body[n].state=0;
  for(m=0;m<8;m++)pnt[body[n].bodp[m].pntn].state=0;
}



void update_body_pnts(int bodyn){
  int n;

  for(n=0;n<8;n++)if(body[bodyn].bodp[n].state){
    rot_point(body[bodyn].x+body[bodyn].bodp[n].x,
              body[bodyn].y+body[bodyn].bodp[n].y,
              body[bodyn].x,body[bodyn].y,body[bodyn].ang,
              &(pnt[body[bodyn].bodp[n].pntn].x),
              &(pnt[body[bodyn].bodp[n].pntn].y));
  }
  
  
}


void body_landing(int n,vect_struct norm,int which_jnt,double hfa){
  vect_struct body_upright,jv,pv;
  double a;
  int foot;
  
  foot=body[n].foot;
  body_upright.x = body[n].x - pnt[body[n].bodp[foot].pntn].x;
  body_upright.y = body[n].y - pnt[body[n].bodp[foot].pntn].y;
  unit_vect(body_upright,&body_upright);

  a=dot_prod(body_upright,norm);
  if(a<0)a=-a;

  if((a>0.86||j[1]>24)||j[4]<2||j[8]==100){
    if(!j[23])j[2]=20;
    body[n].jntn=which_jnt;
    body[n].ang_v=0;
    body[n].ang_v_old=0;
    get_jnt_vect(which_jnt,&jv);
    unit_vect(jv,&jv);
    pv.x=body[n].xx;
    pv.y=body[n].yy;
    body[n].jntvx=dot_prod(pv,jv);
    body[n].jntx=hfa;
  } else {  
    if(a<0.84&&j[4]>4){  //lose control
    j[3]=30;
   
  }
  
  }

}

void update_body_on_jnt(int n,double extra_height){
  vect_struct a; 
  double px,py,mag;
  
  if(body[n].jntn==-1)return;
  
  get_jnt_vect(body[n].jntn,&a);
  mag=vect_mag(a);
    
  a.x*=body[n].jntx;
  a.y*=body[n].jntx;
  
  clever_func(body[n].jntn,body[n].jntx,-(body[n].h + extra_height),&px,&py);
    
  a.x+=tv[jnt[body[n].jntn].tvn[0]].x;
  a.y+=tv[jnt[body[n].jntn].tvn[0]].y;
    
  a.x=px-a.x;
  a.y=py-a.y;
    
  ///calculate the angle of the body  
 
  body[n].ang=atan2(a.y,a.x) +J_PI/2;

  body[n].vdir.x=-a.y;
  body[n].vdir.y=a.x;
  unit_vect(body[n].vdir,&body[n].vdir);
  
  //xx,yy set here are the implied velocity componants
  body[n].x=px;
  body[n].y=py;
  body[n].xx=-body[n].vdir.x*body[n].jntvx;
  body[n].yy=-body[n].vdir.y*body[n].jntvx;  

}



void body_on_jnt(int n,int N){
  vect_struct a,c; 
  double px,py,mag,mag2;
  int old_jnt,new_jnt;

   
  
    if(j[8])return;
  
    get_jnt_vect(body[n].jntn,&a);
    mag=vect_mag(a);
    unit_vect(a,&a);
    
    body[n].jntx+=(body[n].jntvx/mag)/N;
    
    if(body[n].jntvx_old*body[n].jntvx<0)body[n].jntvx+=(0.5*body[n].jntvx-body[n].jntvx)/tri_num(N); //friction due to change in direction...
    body[n].jntvx_old=body[n].jntvx; 
    
    body[n].jntvx+=(0.985*body[n].jntvx-body[n].jntvx)/tri_num(N);
    if(!j[17])body[n].jntvx-=(0.7*a.y/320)/tri_num(N); //GRAVITY WHILE ON A JNT
    else      body[n].jntvx-=(0.3*a.y/320)/tri_num(N);
    
    body[n].ang_v=0;
    

    
    if(body[n].jntx<0){
      old_jnt=body[n].jntn;
      new_jnt=jnt[body[n].jntn].njnt[0];
      if(jnt[new_jnt].type==2)new_jnt=-1;
      body[n].jntn=new_jnt;
      if(new_jnt==-1){  //to avoid immediate landing
         body[n].ang+=0.15;
      } 
      get_jnt_vect(new_jnt,&c);
      mag2=vect_mag(c);
      body[n].jntx=1+(body[n].jntx*mag/mag2);
    }
    
    if(body[n].jntx>1){
      old_jnt=body[n].jntn;
      new_jnt=jnt[body[n].jntn].njnt[1];
      if(jnt[new_jnt].type==2)new_jnt=-1;
      body[n].jntn=new_jnt;
      if(new_jnt==-1){  //to avoid immediate landing
        body[n].ang-=0.15;
      }
      get_jnt_vect(new_jnt,&c);
      mag2=vect_mag(c);
      body[n].jntx=(((body[n].jntx-1))*mag/mag2);    
    }
    

  
  update_body_on_jnt(n,(double)4/320);
 
  
  
}


void body_physics(){
  int n,a,m,N,cnt,jn;
  int *ajnt; //list of adjacent joints
  double dist,dtp,mag,hfa,jntax,radsq;  //hfa = how far along jnt was the collision made
  int on_jnt;
  int friction;
  vect_struct d,v; 
    
 
  for(n=0;n<num_bodies;n++)if(body[n].state){
 
   //uses implied xx,yy when jntn=-1
   N=1+ 400*(sqrt(body[n].xx*body[n].xx+body[n].yy*body[n].yy)/2)+((absf(body[n].ang_v)*2)/3);
    
   j[4]=N;
    
        
    for(cnt=0;cnt<N;cnt++){
    
    
        if(body[n].jntn!=-1) body_on_jnt(n,N);   
        
        update_body_pnts(n);
        
        for(m=0;m<8;m++)if(body[n].bodp[m].state){
 
            ajnt=get_adj_jnts(body[n].bodp[m].pntn);
            a=get_num_adj_jnts();
    
            friction=0;
            
            
            
             
            for(jn=0;jn<a;jn++)if(jnt[ajnt[jn]].type!=3){
        
                dist=pnt_jnt_perp_dist(body[n].bodp[m].pntn,ajnt[jn],&(d.x),&(d.y),&on_jnt,&hfa);
                
               
                
       
                radsq=body[n].bodp[m].rad;
                radsq*=radsq;
              
                
                if(dist<radsq&&dist>0){
                
                    friction=1;
                    mag=sqrt(radsq-dist);
            
                    if(dist<radsq/16)mag*=3;
                    if(dist<radsq/8)mag*=3;
                    if(dist<radsq/4)mag*=3;
                    if(dist<radsq/2)mag*=3;
                    
            
                    unit_vect(d,&d);
                    
                                            
                       
                    //hitting a different jnt while riding jnts
                
                     
                    if(body[n].jntn!=-1&&ajnt[jn]!=body[n].jntn){
                        
                        
                        
                        if(N<16){
                 
 
                            jntax=dot_prod(d,body[n].vdir);
                         
                          //  if(body[n].jntvx*jntax<0)
                            body[n].jntvx+=(jntax*mag/30)/tri_num(N);
                          //  else body[n].jntvx+=(jntax*mag/8)/tri_num(N);
                        
                        } else {
                            update_body_on_jnt(n,(double)8/320);
                            update_body_pnts(n);
                           body[n].jntn=-1;
                           if(N>30)j[3]=30;
                        }
                        
                        
                    }
                        
                    
                  
                    

                     
                    
                    if(body[n].jntn==-1){
                    
                        if(m==body[n].foot&&jnt[ajnt[jn]].type==1&&on_jnt)
                        body_landing(n,d,ajnt[jn],hfa);
                    
                    
                        if(cnt==0){
                        
                            j[7]++; 
                        
                            if(j[7]>12&&jnt[ajnt[jn]].type==1&&on_jnt){ 
                                vect_struct v1,v2;
                                double dp;
                                get_jnt_vect(ajnt[jn],&v1);
                                unit_vect(v1,&v1);
                                v2.x=0;
                                v2.y=1;
                                dp=dot_prod(v1,v2);
                                if(dp>-0.5&&dp<0.5){    //fall flat
                                    j[7]=0;
                                    j[8]=100;
                                    f[4]=body[n].x;
                                    f[5]=body[n].y;
                                    //f[6]=atan2(v1.x,v1.y);
                                    body_landing(n,d,ajnt[jn],hfa);
                                    update_body_on_jnt(n,(double)1/320);
                                    
                                }
                            }
                            
                        }
                        
                        
                    
                        if(body[n].xx*d.x>0)
                        body[n].xx-=(d.x*mag/16)/tri_num(N);
                        else body[n].xx-=(d.x*mag/17)/tri_num(N);
                        if(body[n].yy*d.y>0)
                        body[n].yy-=(d.y*mag/16)/tri_num(N);
                        else body[n].yy-=(d.y*mag/17)/tri_num(N);
            
       
            
            
                       //for body rotation
                        v.x=body[n].x-pnt[body[n].bodp[m].pntn].x;
                        v.y=body[n].y-pnt[body[n].bodp[m].pntn].y;
                        perp_vect(v,&v);
                        unit_vect(v,&v);
                        dtp=dot_prod(d,v);
                        body[n].ang_v+=(dtp*mag*8)/tri_num(N);}
                    }
                    
                    
                    
                }
            }
        
    
    
    
        if(body[n].jntn==-1){
      
    
            if(friction){  //ie friction due to contact with surface
                body[n].xx+=(0.975*body[n].xx-body[n].xx)/tri_num(N);
                body[n].yy+=(0.975*body[n].yy-body[n].yy)/tri_num(N);
                body[n].ang_v+=(0.960*body[n].ang_v-body[n].ang_v)/tri_num(N);

            } else {      //friction due to wind resistance (hence function of v^2)
                body[n].xx+= (body[n].xx*pos_only(1-(0.002*(body[n].xx*body[n].xx+1)*3))-body[n].xx)/tri_num(N);
                body[n].yy+= (body[n].yy*pos_only(1-(0.002*(body[n].yy*body[n].yy+1)*3))-body[n].yy)/tri_num(N);
                body[n].ang_v+=(0.992*body[n].ang_v-body[n].ang_v)/tri_num(N); 
            }
                
                if(!j[17])body[n].yy-= (0.001/tri_num(N));   //GRAVITY WHILE FREE
                else      body[n].yy-= (0.0008/tri_num(N));  //slightly less while playing electric
        
 
        
    


                body[n].x+=(body[n].xx/N);
                body[n].y+=(body[n].yy/N);
                body[n].ang+= ((body[n].ang_v/20)/N);
                
                if(body[n].xx_old*body[n].xx<0)body[n].xx+=(0.5*body[n].xx-body[n].xx)/tri_num(N);
                if(body[n].yy_old*body[n].yy<0)body[n].yy+=(0.5*body[n].yy-body[n].yy)/tri_num(N);
                if(body[n].ang_v_old*body[n].ang_v<0)body[n].ang_v+=(0.5*body[n].ang_v-body[n].ang_v)/tri_num(N); 
        
        
        
                body[n].xx_old=body[n].xx;
                body[n].yy_old=body[n].yy;
                body[n].ang_v_old=body[n].ang_v;
    
        
    
    
    
       
       
            }
        
        }
        
        
  }

}







void draw_bodies(){
    double x,y,sx,sy,s,ad,ang;
    double dx,dy;
    int n,m,a,d,pic;
   

trans_map();
   for(n=0;n<num_bodies;n++)if(body[n].state){



        if(j[8]){
        body[n].x=f[4],body[n].y=f[5];
        if(j[8]==1)body[n].jntvx=0,body[n].jntvx_old=0,body[n].xx=0,body[n].yy=0;
        }

        ad=ang_diff(body[n].ang,body[n].draw_ang,&d);
        
        if(ad>0.1){
        body[n].draw_ang+= ((ad/5) + 0.01)*d;
        }
        
        
       
        
        if(j[2]){
        ang=body[n].draw_ang;
        if(ad>0.2)pic=3; else pic=2;
        pic=3;
        }  else{
        
            ang = body[n].ang,pic=2;
              if(!j[13]&&body[0].jntn!=-1&&(keyr[KEY_LEFT]||keyr[KEY_RIGHT]))pic=12;
            if(!j[13]&&body[n].jntn!=-1&&keyr[KEY_ENTER])pic=27;
        
        }
        if(j[3])pic=5;
        
        if(body[0].jntn==-1&&!j[3])pic=12;
        
      
        if(j[17]){
        if(j[17]>150||(j[17]>92&&j[17]<112))pic=32+((j[0]/4)%2);
        else pic=34;
        }

        if(j[8])pic=20;


         x=body[n].x;
         y=body[n].y;
         
         sx=0.24;
         sy=0.24;
         glColor4f(1.0,1.0,1.0,1);
         if(j[13]){
         ad = (cos((float)j[0]/3)+1)/2;
         glColor4f(1.0,ad,ad,1);
         if(pic==2&&(j[0]%12)>7)pic=30;
         }
         
         
if(j[17]>180){
    double trail_ang;
    double tx,ty;
    if(body[n].jntn!=-1){
        if(body[n].fdir==0)trail_ang=body[n].ang;
                      else trail_ang=J_PI+body[n].ang;
                  
    } else {
    trail_ang =atan2(body[n].yy,body[n].xx) + J_PI;
    }
    
    dx=cos(trail_ang);
    dy=sin(trail_ang);              


    for(m=4;m>0;m--){
      tx = dx*m*0.2*(j[17]-180)*0.05;
      ty = dy*m*0.2*(j[17]-180)*0.05;
      glColor4f(0.6-(float)m/10,1.0,0.6-(float)m/10,0.6-(float)m/10);
      tmap(x-sx+tx,y+sy+ty,x-sx+tx,y-sy+ty,x+sx+tx,y-sy+ty,x+sx+tx,y+sy+ty,terrain_tex[pic],sx,-sy,ang +(J_PI ),body[n].fdir);
    }
    glColor4f(1.0,1.0,1.0,1);
}


if(j[21])glColor4f(0.1,0.1,0.1,1);


tmap(x-sx,y+sy,x-sx,y-sy,x+sx,y-sy,x+sx,y+sy,terrain_tex[pic],sx,-sy,ang +(J_PI ),body[n].fdir);
        
      
         


   }
   
}






double convert_angle(double ang){
  double x;
  int n; 

  if(ang<0){

    x = -ang / (2*J_PI);
    n = x + 1;
    return(ang + n*2*J_PI);

  }  else  {

    x = ang / (2*J_PI);
    n = -x;
    return(ang + n*2*J_PI);
  }


}

double ang_diff(double a1,double a2,int *d){
  double ang1;
  double ang2;
  
  a1=convert_angle(a1);
  a2=convert_angle(a2);

  ang1=convert_angle(a2-a1);
  ang2=convert_angle(a1-a2);

  if(ang1<ang2){(*d)=-1; return(ang1);}
  if(ang2<ang1){(*d)=1;  return(ang2);}
  *d=0;
  return(0);
}




