#include "TW.h"

//regionalized doodads

static GLuint doodad_tex[100];
static int NUM_DTEX=0;



static void (*dad_drawing_func[20])(int bdrn);  //array of pointers to functions for drawing polys


int GET_num_dadtex(){
    return(NUM_DTEX);
}

GLuint GET_doodad_tex(int n){
    return(doodad_tex[n]);
}


void update_dads_onscreen(){ //sets state to 1 if on-screen else 2
    int n;
    double sx,sy;
    
    rot_point(scr_px,scr_py,0,0,-world_ang*J_PI/(double)180,&sx,&sy);
    for(n=0;n<num_dads;n++)if(dad[n].state){
        if(-sx+dad[n].px>-4&&-sx+dad[n].px<4&&-sy+dad[n].py>-4&&-sy+dad[n].py<4){
            dad[n].state=1;
        } else dad[n].state=2;  //out of the visable area
    } 

}

//get_tex_size(terrain_tex[x],&tx,&ty);

void draw_dads(int layer){
    int n;
    
    for(n=0;n<num_dads;n++)if(dad[n].state==1&&dad[n].layer==layer){
        (*dad_drawing_func[  dad[n].type  ])(n);
    }
}


void draw_dad_0(int n){
    double x,y,sx,sy;
    
        get_tex_size(doodad_tex[dad[n].pic],&sx,&sy);
        dad[n].sx=sx;
        dad[n].sy=sy;
    
    x=dad[n].px;
    y=dad[n].py;
    sx=(double)dad[n].sx/320;
    sy=(double)dad[n].sy/320;
    glColor4f (1.0, 1.0, 1.0 , 1);
    selected_doodad(n); //editor func
    if(dad[n].pic>=19&&dad[n].pic<=20){  //lava
        float fa,fb,fc;
        fa=((float)j[0])*0.2;
        fb=(float)(j[0]+n*13)*0.0797912;
        fc=(float)(j[0]+n*11)*0.13241;
        fa=(cos(fa)+1)*0.5 +0.5;
        fb=(cos(fb)+1)*0.3 ;
        fc=(cos(fc)+1)*0.2 + 0.6;
        glColor4f (1.0,fa,fb,fc);
    
    }
    tmap(x-sx,y+sy,x-sx,y-sy,x+sx,y-sy,x+sx,y+sy,doodad_tex[dad[n].pic],sx,-sy,dad[n].ang,0);
}




void init_dad_drawing_funcs(){
dad_drawing_func[0]=draw_dad_0;
}



int new_dad(double px,double py,double ang,int pic,int type,int layer){
    int n;
    double sx;
    double sy;
    
    for(n=0;n<num_dads;n++)if(!dad[n].state){
        dad[n].state=1;
        dad[n].px = px;
        dad[n].py = py;
        dad[n].ang = ang;
        dad[n].pic = pic;
        dad[n].type = type;
        dad[n].layer = layer;
        get_tex_size(doodad_tex[pic],&sx,&sy);
        dad[n].sx=sx;
        dad[n].sy=sy;
        return(n);
    }

}



void delete_doodad(int n){
    dad[n].state=0;
}


void generate_level_sign(){
    DATAFILE *tmp_dat;
    BITMAP *lev_sign = create_bitmap(128,64);

    
    glDeleteTextures(1,&doodad_tex[18]);
    
    tmp_dat = load_datafile("doodads01.dat");

    blit(tmp_dat[18].dat,lev_sign,0,0,0,0,128,64);
    
    
    textprintf(lev_sign,font,32,13,makecol24(50,50,0),"Stage %i",current_level+1);
    textprintf(lev_sign,font,33,14,makecol24(200,200,0),"Stage %i",current_level+1);

    doodad_tex[18]=allegro_gl_make_masked_texture(lev_sign);
    
    
    unload_datafile(tmp_dat);
    destroy_bitmap(lev_sign);


}


void load_doodad_textures(){
    DATAFILE *tmp_dat;
    int n;




    tmp_dat = load_datafile("doodads01.dat");
    
    if (!tmp_dat) {
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Unable to load doodads.dat!\n");
		return ;
    }
   
    for(NUM_DTEX=0;tmp_dat[NUM_DTEX].type!=DAT_END;NUM_DTEX++);NUM_DTEX--;

    glColor4f (1.0, 1.0, 1.0, 1.0);
    for(n=0;n<NUM_DTEX;n++){
    doodad_tex[n]=allegro_gl_make_masked_texture(tmp_dat[n].dat);
    }
    unload_datafile(tmp_dat);

}





void free_doodad_textures(){
    int n;
    for(n=0;n<NUM_DTEX;n++)glDeleteTextures(1,&doodad_tex[n]);

}



