#include "TW.h"


//static int adj_pnts[1000];
static int adj_jnt[1000]; //prob will never need more than 20
static int num_adj_jnts;


//returns perp dist squared
//dx,dy is a vector giving the direction of the line joining the point and the joint
//on_jnt = 1 if the point is on the jnt, else 0




int get_num_adj_jnts(){
  return(num_adj_jnts);
}


double pnt_jnt_perp_dist(int pntn,int jntn,double *dx,double *dy,int *on_jnt,double *how_far_along){
    double px,py,jx,jy,vx,vy,hx,hy,d;
    
    
    //jx,jy=the first point of the joint
    //hx,hy=point on the joint that is closest to the point
    
    px=pnt[pntn].x;
    py=pnt[pntn].y;

    jx=tv[jnt[jntn].tvn[0]].x;
    jy=tv[jnt[jntn].tvn[0]].y;

    vx=(tv[jnt[jntn].tvn[1]].x)-jx;
    vy=(tv[jnt[jntn].tvn[1]].y)-jy;
    
    //that's a few dot products (see a diagram)
    if(vx*vx+vy*vy<0.00001){
        *dx=0;
        *dy=0;
        *on_jnt=0;
        return(0);
    }
    d=((px-jx)*vx + (py-jy)*vy) / (vx*vx + vy*vy);

    hx=jx+vx*d;
    hy=jy+vy*d;
    
    
    
    if(d<0){
        *dx=(jx-px);
        *dy=(jy-py);
        *on_jnt=0;
    } else if(d>1){
        *dx=(jx+vx-px);
        *dy=(jy+vy-py);
        *on_jnt=0;                
    } else {
        *dx=hx-px;
        *dy=hy-py;
        *on_jnt=1;
        }
    
    
    *how_far_along = d;
    return(((*dx)*(*dx))+((*dy)*(*dy)));    
}






void clear_pnts(){
    int n;
    for(n=0;n<num_pnts;n++)pnt[n].state=0;
}



int *get_adj_jnts(int pntn){
    int xmin,ymin,xmax,ymax,x,y,r,n,jntn;



    
    xmin=((pnt[pntn].x+80)*1.25) -1;
    ymin=((pnt[pntn].y+40)*1.25) -1;
    xmax=xmin+2; 
    ymax=ymin+2;
    
    
    if(xmin<0)xmin=0;
    if(ymin<0)ymin=0;
    if(xmax>=map_sx)xmax=map_sx-1;
    if(ymax>=map_sy)ymax=map_sy-1;
    
    
    for(y=ymin;y<=ymax;y++){  //always a max of 3x3
    for(x=xmin;x<=xmax;x++){
        r=x+y*map_sx;
        
        for(n=0;n<region[r].jnt_x;n++){
            jntn=jnt_list[region[r].jnt_n+n];
            if(jnt[jntn].state)jnt[jntn].state=1;
        }
    }}

    num_adj_jnts=0;
    for(y=ymin;y<=ymax;y++){  //always a max of 3x3
    for(x=xmin;x<=xmax;x++){
        r=x+y*map_sx;
        
        for(n=0;n<region[r].jnt_x;n++){
            jntn=jnt_list[region[r].jnt_n+n];
            if(jnt[jntn].state==1){
                adj_jnt[num_adj_jnts]=jntn;
                jnt[jntn].state=2;
                num_adj_jnts++;
            }
        }
    }}


    return(adj_jnt);
}






//type 0 = main char

int new_pnt(int type,int N,double x,double y,double radius){
    int n;
    for(n=0;n<num_pnts;n++)if(!pnt[n].state){
        pnt[n].state=1;
        pnt[n].x=x;
        pnt[n].y=y;
        pnt[n].pnt_reg=0;
        pnt[n].r=radius;
        pnt[n].type=type;
        pnt[n].n=N;
        return(n);
    }

    return(0);
}





int find_region(double x , double y){
  int a,b; 
  a=(x+80)*1.25;
  b=(y+40)*1.25;  
  if(a<0||b<0||a>=map_sx||b>=map_sy)return(-1);
  return(a+b*map_sx);
}



void update_pnt_regions(){
    int x,y,n;
    int num_regions;
    int offset;
    int pnt_region;


    num_regions=(map_sx*map_sy);  //thats about 10000 - ie not too bad


//set the point count in each region to 0, and pnts added to zero   
    for(n=0;n<num_regions;n++){
        region[n].obs_added=0;
        region[n].pnt_x=0;
    }




//find the regions + count num_pnts in each region
    for(n=0;n<num_pnts;n++)if(pnt[n].state){
        pnt_region=find_region(pnt[n].x,pnt[n].y);
        if(pnt_region!=-1)region[pnt_region].pnt_x++;
        pnt[n].pnt_reg=pnt_region;
    }

//setup region offset
    for(n=0,offset=0;n<num_regions;n++){
        region[n].pnt_n=offset;
        offset+=region[n].pnt_x;
    }


//create pnt list (listed in region order) 
    for(n=0;n<num_pnts;n++)if(pnt[n].state){
        pnt_region=pnt[n].pnt_reg;
        if(pnt_region!=-1){
            pnt_list[region[pnt_region].pnt_n+region[pnt_region].obs_added]=n;
            
            region[pnt_region].obs_added++;
        }
    }




}


