#include "TW.h"


static void (*bdr_drawing_func[20])(int bdrn);  //array of pointers to functions for drawing polys




void update_region_bdrs(){
    int n,a,b;
    double x1,y1,x2,y2;
    double xmin,xmax,ymin,ymax;
    //set num bdrs in each region to 0
    for(b=0;b<map_sy;b++){
    for(a=0;a<map_sx;a++){
        region[b*map_sx+a].bdr_x=0;
        region[b*map_sx+a].obs_added=0;
    }}
    
    
    //count number of joint in each region
    for(n=0;n<num_bdrs;n++)if(bdr[n].state){
        x1=(tv[bdr[n].tvn[0]].x+80)*1.25;
        y1=(tv[bdr[n].tvn[0]].y+40)*1.25;
        x2=(tv[bdr[n].tvn[1]].x+80)*1.25;
        y2=(tv[bdr[n].tvn[1]].y+40)*1.25;

        if(x1<x2)xmin=x1,xmax=x2; else xmin=x2,xmax=x1;
        if(y1<y2)ymin=y1,ymax=y2; else ymin=y2,ymax=y1;

        if(xmin<0)xmin=0;
        if(ymin<0)ymin=0;
        if(xmax>map_sx)xmax=map_sx-1;
        if(ymax>map_sy)ymax=map_sy-1;


        for(b=(int)ymin;b<=(int)ymax;b++){
        for(a=(int)xmin;a<=(int)xmax;a++){
            if(line_in_region(x1,y1,x2,y2,a,b))region[b*map_sx+a].bdr_x++;
        }}

    }
    
    //setup offset into bdr_list
    for(n=0,a=0;n<map_sx*map_sy;n++){
        region[n].bdr_n=a;
        a+=region[n].bdr_x;
    }

    //actually add bdrs to the list 
    for(n=0;n<num_bdrs;n++)if(bdr[n].state){

        x1=(tv[bdr[n].tvn[0]].x+80)*1.25;
        y1=(tv[bdr[n].tvn[0]].y+40)*1.25;
        x2=(tv[bdr[n].tvn[1]].x+80)*1.25;
        y2=(tv[bdr[n].tvn[1]].y+40)*1.25;


        if(x1<x2)xmin=x1,xmax=x2; else xmin=x2,xmax=x1;
        if(y1<y2)ymin=y1,ymax=y2; else ymin=y2,ymax=y1;

        if(xmin<0)xmin=0;
        if(ymin<0)ymin=0;
        if(xmax>map_sx)xmax=map_sx-1;
        if(ymax>map_sy)ymax=map_sy-1;


        for(b=(int)ymin;b<=(int)ymax;b++){
        for(a=(int)xmin;a<=(int)xmax;a++){
            if(line_in_region(x1,y1,x2,y2,a,b))bdr_list[region[b*map_sx+a].bdr_n+region[b*map_sx+a].obs_added]=n,
                                               region[b*map_sx+a].obs_added++;
            
        }}

    }





}





void draw_bdrs(){
    int n,m,a;
    double min_x,max_x,min_y,max_y,sx,sy;
    int N,x;

    rot_point(scr_px,scr_py,0,0,-world_ang*J_PI/(double)180,&sx,&sy);
   
    min_x=(sx+78)*1.25;
    min_x-=1;

    min_y=(sy+38.5)*1.25;
    min_y-=1;

    max_x=(sx+82)*1.25;
    max_x+=1;

    max_y=(sy+41.5)*1.25;
    max_y+=1;


    if(min_x<0)min_x=0;
    if(min_y<0)min_y=0;
    if(max_x>map_sx)max_x=map_sx-1;
    if(max_y>map_sy)max_y=map_sy-1;

    //firstly clear used h_table values (much faster than clearing the whole of the h_table
    for(m=min_y;m<max_y;m++){
    for(n=min_x;n<max_x;n++){
    
    N=region[m*map_sx+n].bdr_n;
    x=region[m*map_sx+n].bdr_x;
    
        for(a=N;a<N+x;a++)h_table[bdr_list[a]]=0;
    }}
    
    //now draw polys, not drawing ones that have already been used (by use of hash table)
    for(m=min_y;m<max_y;m++){
    for(n=min_x;n<max_x;n++){
    
    N=region[m*map_sx+n].bdr_n;
    x=region[m*map_sx+n].bdr_x;
    
        for(a=N;a<N+x;a++)if(!h_table[bdr_list[a]]){
            h_table[bdr_list[a]]=1;
            (*bdr_drawing_func[  bdr[bdr_list[a]].type  ])(bdr_list[a]);
        }
    }}





}



void get_bdr_main_vect(int n,vect_struct *v){
(*v).x=tv[bdr[n].tvn[1]].x-tv[bdr[n].tvn[0]].x;
(*v).y=tv[bdr[n].tvn[1]].y-tv[bdr[n].tvn[0]].y;
}


void draw_bdr_0(int n){ //normal
    int N;
    vect_struct v1[2],va,vb,vpa[2],vpb[2],uvect[2],puvect[2];
    double d[2],a[2],b[2],c[2],x1[2],y1[2],x2[2],y2[2],px[2],py[2],h[2],cnt[2];
    double inc_cnt;
   // double unit_va,unit_vb,mag_va,mag_vb;

    get_bdr_main_vect(n,&va); //va used at temp here
 //   v1_mag=vect_mag(va)+bdr[n].scale;


    va.x=tv[bdr[n].tvn[0]].x-tv[bdr[n].tva[0]].x;  //the first 'angle' vector
    va.y=tv[bdr[n].tvn[0]].y-tv[bdr[n].tva[0]].y;

    vb.x=tv[bdr[n].tvn[1]].x-tv[bdr[n].tva[1]].x;  //the second 'angle' vector
    vb.y=tv[bdr[n].tvn[1]].y-tv[bdr[n].tva[1]].y;
    

    inc_cnt = dot_prod(va,vb)  /  (vect_mag(va)*vect_mag(vb));
    if(inc_cnt>0)inc_cnt=0.025 + 0.1*(inc_cnt*inc_cnt);  else inc_cnt =0.025;


    for(N=0;N<2;N++){


        x1[N]=tv[bdr[n].tvn[0]].x + va.x*(1-N*2);
        y1[N]=tv[bdr[n].tvn[0]].y + va.y*(1-N*2);
        x2[N]=tv[bdr[n].tvn[1]].x + vb.x*(1-N*2);
        y2[N]=tv[bdr[n].tvn[1]].y + vb.y*(1-N*2);


        v1[N].x = x2[N]-x1[N];  //the vector joining the two t verts
        v1[N].y = y2[N]-y1[N];



        projected_vect(va,v1[N],&vpa[N]);  //projected angle vectors
        projected_vect(vb,v1[N],&vpb[N]);

        unit_vect(v1[N],&uvect[N]);  //unit vector in direction of two t verts
        perp_vect(uvect[N],&puvect[N]);  //perp to above


        d[N]=vect_mag(v1[N]);

        if(vpa[N].y==0||vpb[N].y==0)return;
        a[N]= ((vpa[N].x/vpa[N].y) - (vpb[N].x/vpb[N].y))/(2*d[N]);  //two consts for curve equation
        b[N]= -(vpa[N].x/vpa[N].y);
        c[N]= ((vpa[N].x/vpa[N].y) + (vpb[N].x/vpb[N].y))*(d[N]/2);
    }

  
    //glLoadIdentity();
   // glTranslatef(0,0,-1);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D,terrain_tex[bdr[n].x]);
    
    selected_border(n); //editor func
    
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR); 
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);

    
    glBegin(GL_QUAD_STRIP);

    
    if(inc_cnt>d[0])inc_cnt=d[0]/2;
    for(cnt[0]=0;cnt[0]<=d[0];cnt[0]+=inc_cnt){
        cnt[1]=((cnt[0]*d[1])/d[0]);
    
        
        if(cnt[0]+inc_cnt>d[0]){
            px[0]=x2[0];
            px[1]=x2[1];
            py[0]=y2[0];
            py[1]=y2[1];
            cnt[0]=d[0];
            cnt[1]=d[1];
        } else {

        for(N=0;N<2;N++){
            h[N]=(a[N]*cnt[N]*cnt[N])+(b[N]*cnt[N])+(c[N]*(cnt[N]/d[N]));
            px[N]=x1[N]+cnt[N]*uvect[N].x  +  h[N]*puvect[N].x;
            py[N]=y1[N]+cnt[N]*uvect[N].y  +  h[N]*puvect[N].y;
        }}
        
        //glColor4f(1.0,1.0,1.0,1);
        glTexCoord2f(bdr[n].tex_offset  +  ((bdr[n].tex_len*cnt[0])/d[0]  ),1);
        glVertex3f(px[1],py[1], 0.0);
        
      
        glTexCoord2f(bdr[n].tex_offset  +  ((bdr[n].tex_len*cnt[0])/d[0]  ),0);
        glVertex3f(px[0],py[0], 0.0);  
   
    }
    glEnd(); 
  
}



void draw_bdr_1(int n){ //blended ends
    int N,M;
    vect_struct v1[3],va,vb,vpa[3],vpb[3],uvect[3],puvect[3];
    double d[3],a[3],b[3],c[3],x1[3],y1[3],x2[3],y2[3],px[3],py[3],h[3],cnt[3];
    double inc_cnt,tmp;
   // double unit_va,unit_vb,mag_va,mag_vb;

    get_bdr_main_vect(n,&va); //va used at temp here
  //  v1_mag=vect_mag(va)+bdr[n].scale;


    va.x=tv[bdr[n].tvn[0]].x-tv[bdr[n].tva[0]].x;  //the first 'angle' vector
    va.y=tv[bdr[n].tvn[0]].y-tv[bdr[n].tva[0]].y;

    vb.x=tv[bdr[n].tvn[1]].x-tv[bdr[n].tva[1]].x;  //the second 'angle' vector
    vb.y=tv[bdr[n].tvn[1]].y-tv[bdr[n].tva[1]].y;
    

    inc_cnt = dot_prod(va,vb)  /  (vect_mag(va)*vect_mag(vb));
    if(inc_cnt>0)inc_cnt=0.025 + 0.1*(inc_cnt*inc_cnt);  else inc_cnt =0.025;


    for(N=0;N<3;N++){

        if(N==0)tmp = 1;
        if(N==1)tmp = 0.3;
        if(N==2)tmp = -1;
        x1[N]=tv[bdr[n].tvn[0]].x + va.x*tmp;
        y1[N]=tv[bdr[n].tvn[0]].y + va.y*tmp;
        x2[N]=tv[bdr[n].tvn[1]].x + vb.x*tmp;
        y2[N]=tv[bdr[n].tvn[1]].y + vb.y*tmp;


        v1[N].x = x2[N]-x1[N];  //the vector joining the two t verts
        v1[N].y = y2[N]-y1[N];



        projected_vect(va,v1[N],&vpa[N]);  //projected angle vectors
        projected_vect(vb,v1[N],&vpb[N]);

        unit_vect(v1[N],&uvect[N]);  //unit vector in direction of two t verts
        perp_vect(uvect[N],&puvect[N]);  //perp to above


        d[N]=vect_mag(v1[N]);

        if(vpa[N].y==0||vpb[N].y==0)return;
        a[N]= ((vpa[N].x/vpa[N].y) - (vpb[N].x/vpb[N].y))/(2*d[N]);  //two consts for curve equation
        b[N]= -(vpa[N].x/vpa[N].y);
        c[N]= ((vpa[N].x/vpa[N].y) + (vpb[N].x/vpb[N].y))*(d[N]/2);
    }

  
    //glLoadIdentity();
   // glTranslatef(0,0,-1);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D,terrain_tex[bdr[n].x]);
    
    
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR); 
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
   // glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);	
    
    glBegin(GL_QUAD_STRIP);
    //glBegin(GL_LINES);
    
    if(inc_cnt>d[1])inc_cnt=d[1]/2;
    
    for(M=0;M<2;M++){
        for(cnt[1]=0;cnt[1]<=d[1];cnt[1]+=inc_cnt){
            cnt[0]=((cnt[1]*d[0])/d[1]);
            cnt[2]=((cnt[1]*d[2])/d[1]);
    
        
            if(cnt[1]+inc_cnt>d[1]){
                px[0]=x2[0];
                px[1]=x2[1];
                px[2]=x2[2];
                py[0]=y2[0];
                py[1]=y2[1];
                py[2]=y2[2];
                cnt[0]=d[0];
                cnt[1]=d[1];
                cnt[2]=d[2];
            } else {

            for(N=0;N<2;N++){
                h[N+M]=(a[N+M]*cnt[N+M]*cnt[N+M])+(b[N+M]*cnt[N+M])+(c[N+M]*(cnt[N+M]/d[N+M]));
                px[N+M]=x1[N+M]+cnt[N+M]*uvect[N+M].x  +  h[N+M]*puvect[N+M].x;
                py[N+M]=y1[N+M]+cnt[N+M]*uvect[N+M].y  +  h[N+M]*puvect[N+M].y;
            
            
            }}
        
            glColor4f(1.0,1.0,1.0,1);
            selected_border(n); //editor func
            glTexCoord2f(bdr[n].tex_offset  +  ((bdr[n].tex_len*cnt[1])/d[1]),0.5+(double)M/2);
            glVertex3f(px[M+1],py[M+1], 0.0);
        
            if(M==0)glColor4f(1.0,1.0,1.0,0);
            selected_border(n); //editor func
            glTexCoord2f(bdr[n].tex_offset  +  ((bdr[n].tex_len*cnt[1])/d[1]),0+(double)M/2);
            glVertex3f(px[M],py[M], 0.0);  
   
        
        }
    }
    glEnd(); 
  
}

void draw_bdr_2(int n){
if(bdr[n].wpn==j[6]){
glColor4f(1.0,1.0,1.0,(float)(j[0]%100)/100);
draw_bdr_0(n);}
}

void init_bdr_drawing_funcs(){
bdr_drawing_func[0]=draw_bdr_0;
bdr_drawing_func[1]=draw_bdr_1;
bdr_drawing_func[2]=draw_bdr_2;
}





void new_bdr(int tvn1,int tvn2,int tva1,int tva2,int type,int x){
    int n;
    for(n=0;n<num_bdrs;n++)if(!bdr[n].state){
        bdr[n].state=1;
        bdr[n].tvn[0]=tvn1;
        bdr[n].tvn[1]=tvn2;
        bdr[n].tva[0]=tva1;
        bdr[n].tva[1]=tva2;
        bdr[n].type=type;
        bdr[n].x=x;
        bdr[n].tex_len=0;
        bdr[n].next_b=-1;
        bdr[n].last_b=-1;
        bdr[n].tex_offset=0;
   
        //set_tex_offset(n);
        //joint_bdr(n);
        break;
    }
    
}

//for editor 


void update_border_wrapping(){
    int n,a,b,aa,bb;
    int num_str; //number of stretches of texture (so that border rings fit together nicely)
    double s_ratio; //for scaling the border loops to fit nicely
    vect_struct v;
    
   
    for(n=0;n<num_bdrs;n++)if(bdr[n].state&&bdr[n].last_b==-1){
        a=n;
        

        for(;;){
            b=bdr[a].next_b;
            if(b==-1){break;}
            if(b==n){  //found a border loop
    
                num_str = bdr[a].tex_offset + bdr[a].tex_len;
                s_ratio = (double)num_str/ (bdr[a].tex_offset + bdr[a].tex_len);
                if(s_ratio>0.99999&&s_ratio<1.00001)break;
                aa=n;
                
                for(;;){ 
                    bb=bdr[aa].next_b;
                    bdr[aa].tex_len *= s_ratio;
                    if(bb==n)break;
                    bdr[bb].tex_offset = bdr[aa].tex_offset+bdr[aa].tex_len;
                    aa=bb;
                }
            
                break;
            }
    
            get_bdr_main_vect(a,&v);
     
            bdr[b].tex_offset=bdr[a].tex_offset+bdr[a].tex_len;
            a=b;
        }
    
    
    }


}


int get_last_bdr_from_tv(int tvn){
    int n;
    for(n=0;n<num_bdrs;n++)if(bdr[n].state){
        if(bdr[n].tvn[1]==tvn)return(n);
    }

return(-1);
}

int get_next_bdr_from_tv(int tvn){
    int n;
    for(n=0;n<num_bdrs;n++)if(bdr[n].state){
        if(bdr[n].tvn[0]==tvn)return(n);
    }

return(-1);
}

int get_bdr_from_tv(int tvn){
    int n;
    for(n=0;n<num_bdrs;n++)if(bdr[n].state){
        if(bdr[n].tvn[0]==tvn)return(n);
    }

return(-1);
}








void new_bdr2(int tvn1,int tvn2,int type,int x){
    int n,adj_bdr,tri_dir,N;
    vect_struct mv[2],pmv,bisec;
    double tx,ty;
    
    for(n=0;n<num_bdrs;n++)if(!bdr[n].state){
        bdr[n].state=1;
        bdr[n].tvn[0]=tvn1;
        bdr[n].tvn[1]=tvn2;
        bdr[n].type=type;
        bdr[n].x=x;
        bdr[n].wpn=j[6];
        
        
        get_tex_size(terrain_tex[x],&tx,&ty);
        
        get_bdr_main_vect(n,&mv[0]);
        bdr[n].tex_len = (vect_mag(mv[0])/tx)*256;
        perp_vect(mv[0],&pmv);
        unit_vect(pmv,&pmv);
        
        for(N=0;N<2;N++){
            
            if(N==0)adj_bdr=get_last_bdr_from_tv(tvn1);
            if(N==1)adj_bdr=get_next_bdr_from_tv(tvn2);
            
            
            if(adj_bdr==-1){
                if(N==0)bdr[n].tva[0]=new_tv(tv[tvn1].x+(pmv.x*ty*0.0020),tv[tvn1].y+(pmv.y*ty*0.0020)),bdr[n].last_b=-1;
                if(N==1)bdr[n].tva[1]=new_tv(tv[tvn2].x+(pmv.x*ty*0.0020),tv[tvn2].y+(pmv.y*ty*0.0020)),bdr[n].next_b=-1;
                bdr[n].tex_offset=0;
            }  else {
            
                bdr[n].tva[N]=bdr[adj_bdr].tva[1-N];
            
            
                if(N==0)tri_dir=get_tri_dir(bdr[adj_bdr].tvn[0],tvn1,tvn2);
                if(N==1)tri_dir=get_tri_dir(tvn1,bdr[adj_bdr].tvn[1],tvn2);
                
                get_bdr_main_vect(adj_bdr,&mv[1]);
            
                if(N==0){
                    bdr[n].tex_offset=bdr[adj_bdr].tex_offset+bdr[adj_bdr].tex_len;
                    bdr[adj_bdr].next_b=n;
                    bdr[n].last_b=adj_bdr;
                }
                if(N==1)bdr[n].next_b=adj_bdr;
            
            
                unit_vect(mv[0],&mv[0]);
                unit_vect(mv[1],&mv[1]);
                bisec.x=(mv[1].x-mv[0].x)*tri_dir;
                bisec.y=(mv[1].y-mv[0].y)*tri_dir;
                if(vect_mag(bisec)<0.00001)perp_vect(mv[0],&bisec),bisec.x*=-1,bisec.y*=-1;
                unit_vect(bisec,&bisec);
            
            
                tv[bdr[n].tva[N]].x=tv[bdr[n].tvn[N]].x - (bisec.x*ty*0.0020);
                tv[bdr[n].tva[N]].y=tv[bdr[n].tvn[N]].y - (bisec.y*ty*0.0020);
            
            
            
        
            }
        
        
        }


        
        update_border_wrapping();
        break;
    }
    
}



void delete_bdr(int n){
    bdr[n].state=0;
    
    if(bdr[n].last_b==-1)
        delete_tv(bdr[n].tva[0]);
    
    if(bdr[n].next_b==-1)
        delete_tv(bdr[n].tva[1]);
    
    
    if(bdr[n].last_b!=-1)
        bdr[bdr[n].last_b].next_b=-1;
   
     if(bdr[n].next_b!=-1)
        bdr[bdr[n].next_b].last_b=-1;
    
    update_border_wrapping();
    update_region_bdrs();
    
}

