#include <stdio.h>
#include <string.h>
#include "globals.h"
#include "data.h"
#include "water.h"
#include "screens.h"

char *title_texts[]={
  "",
  "WATER KILLS",
  "S P E E D H A C K",
  "1999",
  "",
  NULL
};

char *ending_texts[]={
  "",
  "Vincent Penquerc'h",
  "Code/GFX/SFX",
  "",
  "Aaron Shutt",
  "SpeedHack contest",
  "organization",
  "Happy Birthday-29",
  "",
  "Shawn Hargraves",
  "Michael Bukin",
  "George Foot",
  "Jason Wilkins",
  "and many others",
  "Allegro",
  "",
  "Shawn Hargraves",
  "Allegro demo data",
  "",
  "Garett Thomson",
  "MIDI tune",
  "",
  "Mukesh Prasad",
  "Fast intersection",
  "of line segments",
  "Graphics Gems II",
  "",
  "Linus Torvalds",
  "and many others",
  "Linux",
  "",
  "Richard M Stallman",
  "DJ Delorie",
  "GCC & DJGPP",
  "",
  "Future Crew",
  "Unreal",
  "The first demo",
  "I ever experienced",
  "",
  NULL
};

char *ass_texts[]={
  "",
  "ASS",
  "wins !",
  "",
  NULL
};

char *player_texts[]={
  "",
  "Player",
  "wins !",
  "",
  NULL
};



#define WRITE_FRAMES 500
#define WAIT_FRAMES 80

static char spaced_text[250];
char *space(char *text)
{
  char *ptr1,*ptr2;

  ptr1=text;
  ptr2=spaced_text;
  for (;*ptr1;ptr1++) {
    *ptr2++=*ptr1;
    *ptr2++=' ';
  }
  *ptr2=0;
  return spaced_text;
}

void Screen(char *texts[],int highlight)
{
  BITMAP *ts1,*ts2,*tmp;
  FONT *sf=(FONT*)(data[dat_font1].dat);
  char **write=texts;
  int lines,n;
  int sine;

  set_clip(drawable,0,0,SCREEN_W,SCREEN_H);
  ts1=create_bitmap_ex(8,SCREEN_W/WATERSCALE2+2*BORDER,SCREEN_H/WATERSCALE2+2*BORDER);
  ts2=create_bitmap_ex(8,SCREEN_W/WATERSCALE2+2*BORDER,SCREEN_H/WATERSCALE2+2*BORDER);
  if (!ts1 || !ts2) Error("Not enough memory");
  clear(ts1);
  clear(ts2);

  screen_timeout=0;
  lines=0;
  sine=ticks;
  while (!keypressed()) {
    if (screen_timeout>WAIT_FRAMES) {
      for (n=0;n<lines;n++) {
        textprintf_centre(
          ts2,sf,
          BORDER+(SCREEN_W/WATERSCALE2)/2+((highlight==n)?(fsin((ticks-sine)*65536/* *32 */)/8192):0),
//          (SCREEN_W/WATERSCALE2)/2,
          BORDER+(SCREEN_H/WATERSCALE2)/2-((lines/2-n)*2+1)*text_height(sf)/2,
          255,space(*(write+n))
        );
      }
    }
    else if (screen_timeout<=0) {
      screen_timeout=WRITE_FRAMES+WAIT_FRAMES;
      write+=lines+1;
      if (!*write) break;
      lines=0;
      for (char **w=write;*w && (*w)[0];lines++,w++);
    }
    SWaterScreen(ts1,ts2,0,0,0,0,SCREEN_W,SCREEN_H);
    blit(drawable,screen,0,0,0,0,SCREEN_W,SCREEN_H);
    tmp=ts1;
    ts1=ts2;
    ts2=tmp;
    screen_timeout--;
  }
  while (keypressed()) readkey();
  destroy_bitmap(ts1);
  destroy_bitmap(ts2);
}

void TitleScreen()
{
  Screen(title_texts,-1);
}

void EndScreen()
{
  Screen(ending_texts,-1);
}

void WinScreen(int index)
{
  Screen(player_texts,-1);
}

void LoseScreen()
{
  Screen(ass_texts,-1);
}

char *menu_texts[]={
  "Race",
  "Against the clock",
  "Train",
  "Change map",
  "View scores",
  "Quit",
  NULL,
};

int Menu(char **texts)
{
  BITMAP *ts1,*ts2,*tmp;
  FONT *sf=(FONT*)(data[dat_font1].dat);
  char **write=texts;
  int lines,n;
  int item=0;
  int key=-1;
  int sine;

  set_clip(drawable,0,0,SCREEN_W,SCREEN_H);
  ts1=create_bitmap_ex(8,SCREEN_W/WATERSCALE2+2*BORDER,SCREEN_H/WATERSCALE2+2*BORDER);
  ts2=create_bitmap_ex(8,SCREEN_W/WATERSCALE2+2*BORDER,SCREEN_H/WATERSCALE2+2*BORDER);
  if (!ts1 || !ts2) Error("Not enough memory");
  clear(ts1);
  clear(ts2);

  for (lines=0,write=texts;*write;*write++,lines++);

  sine=ticks;
  while (key!=KEY_ESC && key!=KEY_ENTER && key!=KEY_SPACE) {
    if (keypressed()) {
      key=readkey()>>8;
      switch (key) {
        case KEY_UP:
          if (item>0) item--;
          sine=ticks;
          break;
        case KEY_DOWN:
          if (item<lines-1) item++;
          sine=ticks;
          break;
      }
    }
    for (n=0;n<lines;n++) {
      textprintf_centre(
        ts2,sf,
        BORDER+(SCREEN_W/WATERSCALE2)/2+((item==n)?(fsin((ticks-sine)*65536/* *32 */)/8192):0),
        BORDER+(SCREEN_H/WATERSCALE2)/2-((lines/2-n)*2+1)*text_height(sf)/2,
        255,space(*(texts+n))
      );
    }
    SWaterScreen(ts1,ts2,0,0,0,0,SCREEN_W,SCREEN_H);
    blit(drawable,screen,0,0,0,0,SCREEN_W,SCREEN_H);
    tmp=ts1;
    ts1=ts2;
    ts2=tmp;
  }
  while (keypressed()) readkey();
  destroy_bitmap(ts1);
  destroy_bitmap(ts2);

  if (key==KEY_ESC) return -1;
  return item;
}

int Menu()
{
  return Menu(menu_texts);
}

char *maps_texts[]={
  "29",
  "rocks",
  "closed",
  NULL,
};

char *SelectMap()
{
  int map;

  map=Menu(maps_texts);
  if (map==-1) return NULL;
  return maps_texts[map];
}

void ShowScores(int highlight)
{
  char *score_texts[9];
  int n;

  score_texts[0]=strdup("");
  score_texts[1]=strdup("SCORES");
  score_texts[2]=strdup(" ");
  score_texts[7]=strdup("");
  score_texts[8]=NULL;
  for (n=0;n<4;n++) {
    score_texts[n+3]=(char*)malloc(80);
    if (scores[n]==-1)
     sprintf(score_texts[n+3],"...");
    else
     sprintf(score_texts[n+3],"%d''%02d",scores[n]/100,scores[n]%100);
  }
  Screen((char**)score_texts,highlight==-1?-1:highlight+2);
  for (n=0;n<8;n++) free(score_texts[n]);
}

