#include <stdio.h>
#include "render.h"
#include "water.h"
#include "data.h"
#include "globals.h"

#define SMAP_SCALE 16

void Render()
{
  int n;
  BITMAP *swapper;
  FONT *f=(FONT*)(data[dat_font1].dat);
  static char text[80];
  int c;
  int x,y;

  for (n=0;n<((training|clockmode)?1:nplayers);n++) ships[n]->viewer.Draw();

  for (n=0;n<((training|clockmode)?1:nships);n++) ships[n]->Status(4,20+n*40);

  set_clip(drawable,0,0,SCREEN_W,SCREEN_H);
  sprintf(text,"%d:%02d",race_ticks/GAME_SPEED,race_ticks%GAME_SPEED);
  textprintf(
    drawable,f,SCREEN_W-text_length(f,text)-20,4,makecol(255,0,0),text
  );

  if (training) {
    c=makecol(255,255,0);
    for (n=0;n<map->nbuoys;n++) {
      x=SCREEN_W/2+((map->buoys[n].x>>16)-+(ships[0]->x>>16)/*/2*/)/SMAP_SCALE;
      y=SCREEN_H/2+((map->buoys[n].y>>16)-+(ships[0]->y>>16)/*/2*/)/SMAP_SCALE;
      putpixel(drawable,x,y-1,c);
      putpixel(drawable,x-1,y,c);
      putpixel(drawable,x,y,c);
      putpixel(drawable,x+1,y,c);
      putpixel(drawable,x,y+1,c);
    }
  }

  if (showfps)
   textprintf(drawable,font,SCREEN_W-80,SCREEN_H-16,-1,"%d FPS",fps);

  frames++;

  swapper=water1;
  water1=water2;
  water2=swapper;
}


