#ifndef _MAP_
#define _MAP_

#include <allegro.h>

#define FINISH 64

class Ship;

typedef struct {
  fixed x;
  fixed y;
} Buoy;

typedef struct {
  fixed x;
  fixed y;
  int type;
} Rock;

typedef struct {
  fixed x;
  fixed y;
} Nenuphar;

typedef struct {
  fixed x;
  fixed y;
} JumpPad;

typedef struct {
  fixed x;
  fixed y;
} SpeedPad;

typedef struct {
  fixed x0;
  fixed y0;
  fixed x1;
  fixed y1;
} Waypoint;

class Map {
public:
  int nbuoys;
  Buoy *buoys;

  int nrocks;
  Rock *rocks;

  int nnenuphars;
  Nenuphar *nenuphars;

  int njumppads;
  JumpPad *jumppads;

  int nspeedpads;
  SpeedPad *speedpads;

  fixed wind_dir;
  fixed wind_spd;

  int nwaypoints;
  Waypoint waypoints[16];

  fixed startx;
  fixed starty;

  fixed width;
  fixed height;

  char filename[1024];

public:
  Map();
  void Init();
  void AddBuoy(int x,int y);
  void AddRock(int x,int y);
  void AddNenuphar(int x,int y);
  void AddJumpPad(int x,int y);
  void AddSpeedPad(int x,int y);
  void AddWaypoint(int n,int x,int y);
  int Load(char *filename);
  void Unload();
  void Draw(fixed x,fixed y,int sx,int sy,int sw,int sh,int DX,int DY);
  void Think();
};

class MapViewer {
public:
  int sx;
  int sy;
  int sw;
  int sh;

  fixed DX;
  fixed DY;
  int start;

  Ship *ship;

public:
  void Init();
  void Draw();
};

#endif

