#ifndef _SHIP_
#define _SHIP_

#include <allegro.h>
#include "map.h"

#define MAX_SHIPS 3

class Ship {
public:
  BITMAP *image;
  fixed turn_rate;
  fixed power_rate;
  fixed crossing;

  fixed x;
  fixed y;
  fixed head_dir;
  fixed move_dir;
  fixed move_spd;

  int key_left;
  int key_right;
  int key_go;
  int jumping;
  int jump_length;
  int landed;
  int input;
  int speeding;
  fixed speeding_dir;

  int waypoint;
  int voice;
  int color;
  int type;
  void *lastcol;

  fixed last_render_x;
  fixed last_render_y;

  MapViewer viewer;

public:
  Ship();
  void Init(fixed startx,fixed starty);
  void Left();
  void Right();
  void Go();
  void Jump();
  void ApplyForce(fixed dir,fixed spd);
  void Control();
  void AI();
  int Think(int ai);
  void Draw(fixed x,fixed y,int sx,int sy,int sw,int sh);
  void DrawTrail(fixed x,fixed y,int sx,int sy,int sw,int sh);
  void Status(int sx,int sy);
};

class ArrowShip: public Ship {
public:
  ArrowShip();
};

class CatamaranShip: public Ship {
public:
  CatamaranShip();
};

class EvergladesShip: public Ship {
public:
  EvergladesShip();
};

class MediumShip: public Ship {
public:
  MediumShip();
};

class StarshipShip: public Ship {
public:
  StarshipShip();
};

class ZodiacShip: public Ship {
public:
  ZodiacShip();
};

#endif
