#ifndef _GLOBALS_
#define _GLOBALS_

#include <allegro.h>
#include "ship.h"
#include "map.h"

#ifdef DEBUG
#define LogExec() Log("Runtime exec: %s:%d\n",__FILE__,__LINE__)
#else
#define LogExec() ((void)NULL)
#endif

#define GAME_SPEED 100

extern volatile int ticks;
extern volatile int think;
extern volatile int race_ticks;
extern BITMAP *drawable;
extern DATAFILE *data;
extern int nplayers;
extern int nships;
extern int width;
extern int height;
extern int depth;
extern Map *map;
extern char *track;
extern Ship **ships;
extern volatile int fps;
extern volatile int frames;
extern int *voices;
extern int horz;
extern int joystick;
extern BITMAP *bg;
extern PALETTE palette;
extern int water;
extern BITMAP *water1;
extern BITMAP *water2;
extern MIDI *midi;
extern int ass_level;
extern int wind;
extern int trans;
extern int marker;
extern int clockmode;
extern int scores[4];
extern int showfps;
extern int training;
extern int nosound;
extern int nomusic;
extern int wait_vsync;

#ifdef DEBUG
extern int Log(char *msg,...);
#endif

extern void DoError(char *msg,...);
extern int CheckCollision(
  int x1,int y1,int w1,int h1,int x2,int y2,int w2,int h2
);

#define Error(a,b...) {LogExec(); DoError(a, ## b);}

#endif

