// Moon Defense ver 1.2 Jakub Debski '2004

#ifndef MOON_DEF_OBJECTS_H
#define MOON_DEF_OBJECTS_H

#include <allegro.h>
#include <list>
#include "data.h"
#include <stdlib.h>
using namespace std;

#define EXPLOSION_SIZE 50
#define EXPLOSION_TYPES 4

#define UFO_FRAMES 24
#define UFO_SIZE_X 60
#define UFO_SIZE_Y 20

#define MOON_SIZE_X 200
#define MOON_SIZE_Y 195

#define BOMB_SIZE 40

#define SCREEN_SIZE_X 800
#define SCREEN_SIZE_Y 600

#define MIN_X 0
#define MAX_X SCREEN_SIZE_X
#define MIN_Y 0
#define MAX_Y SCREEN_SIZE_Y


enum {
	BLK_NOTHING=0,
	BLK_FRIENDLY_MISSILE,
	BLK_ENEMY_MISSILE,
	BLK_PLANET,
	BLK_BOMB,
	BLK_EXPLOSION
};

class sprite {
	
protected:
 int X,Y,hotX,hotY;
 BITMAP *sprite_buffer;
 int size_x, size_y;
 char *sprite_mask;
	
public:
 sprite(int _X,int _Y,BITMAP *img, char *mask);
 sprite(int _X,int _Y);
 virtual ~sprite() {};
 
 virtual void draw(BITMAP*dest);
 
 int remove_blocking(int color);
 virtual int paste_blocking(int color);
 
 inline int getX() { return X; };
 inline int getY() { return Y; };
 virtual void place(int NX,int NY);
 virtual void move(int DX,int DY);
 virtual bool animate() { return FALSE; };
 void set_sprite_buffer(BITMAP *img)
 {
	 sprite_buffer = img;
	 size_x = img->w;
	 size_y = img->h;	 
 };
};

typedef list<sprite*> sprite_list;


class CSatellite : public sprite {
protected:
 int frame;
 double angle;
public:
 CSatellite(int _X,int _Y);
 virtual bool animate();
};

class CSight : public sprite {
protected:
 int frame;
public:
 virtual void draw(BITMAP*dest);
 CSight(int _X,int _Y);
 virtual bool animate();
};


class CMissile : public sprite {
 double realX , realY;
 double DX , DY;
 int type;
 
public:
 CMissile(double _X,double _Y, double _tx, double _ty, int _type);
 ~CMissile();
 virtual bool animate();
};

class CBomb : public sprite {
 double realX , realY;
 double DX , DY;
 int step;
 int max_steps;
 
public:
 CBomb();
 ~CBomb();
 virtual bool animate(); 
};

class background : public sprite {
public:
 background() : sprite(0,0) {};
 virtual void draw(BITMAP*dest);
};

class CExplosion : public sprite {
protected:
 int frame;
 int explosion_type;
public:
 CExplosion(int _X,int _Y);
 void destroy_backdrop();
 virtual bool animate();
 virtual int paste_blocking(int color); 
};

class CBlocking {
private:
	char *bdata;
public:
	CBlocking() { bdata = new char[SCREEN_SIZE_X * SCREEN_SIZE_Y + 1]; };
	~CBlocking() { delete [] bdata; };
	void clearblocking() { memset(bdata,0,SCREEN_SIZE_X*SCREEN_SIZE_Y); };
	inline void setblocking(int x,int y, int color) {
		if (x<0 || y<0 || x>SCREEN_SIZE_X-1 || y>SCREEN_SIZE_Y-1)
			return;
		bdata[y*SCREEN_SIZE_X+x] = color;
	}
	inline int getblocking(int x,int y) {
		if (x<0 || y<0 || x>SCREEN_SIZE_X-1 || y>SCREEN_SIZE_Y-1)
			return -1;
		return bdata[y*SCREEN_SIZE_X+x];
	}	
};


class CUfo : public sprite {
protected:
 int frame;
 double realX , realY;
 double DX , DY;
 int step;
 int max_steps; 
public:
 CUfo();
 ~CUfo();
 virtual bool animate();
};


#endif

