// Moon Defense ver 1.5 Jakub Debski '2004

#include "objects.h"
#include <math.h>

extern DATAFILE *data;
extern BITMAP *backdrop, *framebuf;
extern CBlocking *blocking;
extern sprite_list sprites;
extern CSatellite *Satellite;
extern int bomb_steps;
extern bool fire_pressed;

extern BITMAP *explosion_anim[EXPLOSION_TYPES][150];
extern BITMAP *explosion_clear[EXPLOSION_TYPES];
extern int score;
extern int satellite_destroyed;
extern int satellite_immortal;
extern int number_of_satellites;
extern BITMAP *ufo_frame[UFO_FRAMES];
extern BITMAP *friendly_missile_frame;
extern BITMAP *enemy_missile_frame;
extern BITMAP *satellite_frame;
extern BITMAP *satellite_immortal_frame;
extern BITMAP *sight_frame;
extern BITMAP *bomb_frame[360];

extern char *mask_explosion_anim[EXPLOSION_TYPES][150];
extern char *mask_explosion_clear[EXPLOSION_TYPES];
extern char *mask_ufo_frame;
extern char *mask_missile;
extern char *mask_bomb[360];

extern int number_of_ufo;
extern int number_of_bombs;

extern bool game_over;
extern bool control_mouse; 

#ifdef MOUSE_REQUIRES_TIME
extern bool mouse_can_fire;
extern long mouse_without_move;
#endif



int pan = 128;
int pitch = 1000;

extern bool run_without_sound;
extern bool inverse_sound;

int number_of_missiles=0;

sprite::sprite(int _X,int _Y,BITMAP *img, char *mask)
{
  X=_X;
  Y=_Y;
  set_sprite_buffer(img);
  sprite_mask=mask;
}

sprite::sprite(int _X,int _Y)
{ 
	X=_X;
	Y=_Y;
	size_x=0;
	size_y=0;
	sprite_buffer = NULL;
	sprite_mask=NULL;
};

void sprite::place(int NX,int NY)
{
	hotX=X=NX;
	hotY=Y=NY;
	if (sprite_buffer!=NULL)
	{
		hotX-=size_x/2;
		hotY-=size_y/2;
	}
};

void sprite::move(int DX,int DY)
{ 
	X+=DX;
	Y+=DY; 
	hotX=X;
	hotY=Y;
	if (sprite_buffer!=NULL)
	{
		hotX-=size_x/2;
		hotY-=size_y/2;
	}
};

void sprite::draw(BITMAP*dest)
{
	draw_sprite(dest,sprite_buffer,hotX,hotY);
};

void CSight::draw(BITMAP*dest)
{
	sprite::draw(dest);
#ifdef MOUSE_REQUIRES_TIME	
	// display mouse blocker
	if (control_mouse && mouse_can_fire)
	{
		int x,y;
		for (int index=0;index<4;index++)
		{
			double angle = (mouse_without_move*3+index*90)%360;		   
			x=(int )getX() + (int) (14*(sin((angle*3.1415926535897932384626433832795)/180)));
			y=(int )getY() + (int) (14*(cos((angle*3.1415926535897932384626433832795)/180)));
			putpixel(dest,x,y,78);
		}
	}
#endif
};



CMissile::CMissile(double _X,double _Y, double _tx, double _ty, int _type)
: sprite((int) _X,(int) _Y,_type==BLK_FRIENDLY_MISSILE?friendly_missile_frame:enemy_missile_frame, mask_missile)
{
	type = _type;
	
	if (type==BLK_FRIENDLY_MISSILE)
		number_of_missiles++;

    place((int) _X,(int) _Y);
    
    realX = _X;
    realY = _Y;
    
    double nx = _tx - _X;
    double ny = _ty - _Y;
    
    double dist = sqrt(nx*nx + ny*ny)/2;
    
    DX = ((nx / dist) * 0.5);
    DY = ((ny / dist) * 0.5);

   // play sample


   if (!run_without_sound)
   {
	   pan = (getX()*256)/SCREEN_SIZE_X;
	   if (inverse_sound)
		   pan = 255-pan;
	   
	   play_sample((SAMPLE*)data[OBJ_SOUND_FIRE].dat, 255, pan, pitch, FALSE);   
   }
}

CMissile::~CMissile()
{
	if (type==BLK_FRIENDLY_MISSILE)		
		number_of_missiles--;
}


CBomb::CBomb()
: sprite(0,0)
{
	number_of_bombs++;

    // choose starting position
    
    int a = rand()%400;
    int ax, ay;
    
    if (a<100)
    {
        ax = rand()%SCREEN_SIZE_X;
        ay = -40;
    }
    else if (a<200)
    {
        ax = rand()%SCREEN_SIZE_X;
        ay = SCREEN_SIZE_Y+40;
    }
    else if (a<300)
    {
        ax = -40;
        ay = rand()%SCREEN_SIZE_Y;
    }
    else if (a<400)
    {
        ax = SCREEN_SIZE_X+40;
        ay = rand()%SCREEN_SIZE_X;
    }        
    
    // place in position
    
    place(ax,ay);
    
    realX = ax;
    realY = ay;
    
    // target - centre of the screen minus half of bomb
    
    double nx = SCREEN_SIZE_X/2 - ax - size_x/2;
    double ny = SCREEN_SIZE_Y/2 - ay - size_y/2;
    
    DX = (nx / (bomb_steps/5))/3;
    DY = (ny / (bomb_steps/5))/3;    
    
    step=0;
    max_steps=(bomb_steps/5)*3;    
    
    // rotate bomb

    double angle;    
    
    nx = -nx;
      
    angle = atan(nx/ny)*180/3.14159;
    
    if (ny>=0)
        angle+=180;

	while (angle>359)
		angle-=360;
	while (angle<0)
		angle+=360;

	set_sprite_buffer(bomb_frame[(int) angle]);	
	sprite_mask = mask_bomb[(int) angle];				    
}

CBomb::~CBomb()
{
	number_of_bombs--;
	if (!game_over)
	{
	  if (bomb_steps>200)
              bomb_steps-=10;
	}
}

bool CMissile::animate()
{  
	bool destroy_missile=false;
    if (sprite::remove_blocking(type))
		destroy_missile=true;
	else
	{

		realX = realX + DX;
		realY = realY + DY;
		
		place((int) realX,(int) realY);

		if (hotX<MIN_X || hotX>MAX_X || hotY<MIN_Y || hotY>MAX_Y)
		{
			return true;
		}
	}
	
    if (sprite::paste_blocking(type))
		destroy_missile=true;		

	if (destroy_missile)
	{
      sprite::remove_blocking(type);
    
      sprites.push_back(new CExplosion(X,Y));  
      return true;
    }      
      
	return false;
}

int sprite::remove_blocking(int color)
{
  int col;
  int was_other_color=false;
  for (int ax=0;ax<size_x;ax++)
    for (int ay=0;ay<size_y;ay++)
    {		
  	  col = sprite_mask[size_x*ay+ax];
      if (col!=0)
      {
    	  col = blocking->getblocking(hotX+ax,hotY+ay);
    	  if (col!=BLK_NOTHING && col!=color && col!=-1)
			  was_other_color=col;
		  
		  blocking->setblocking(hotX+ax,hotY+ay, BLK_NOTHING);
      }
    }

  return was_other_color;
} 
 
int sprite::paste_blocking(int color)
{
  int col;
  for (int ax=0;ax<size_x;ax++)
    for (int ay=0;ay<size_y;ay++)
    {
	  col = sprite_mask[size_x*ay+ax];
      if (col!=0)
      {
		  col = blocking->getblocking(hotX+ax,hotY+ay);
		  if (col!=color && col!=BLK_NOTHING && col!=-1)
			return col;
		  blocking->setblocking(hotX+ax,hotY+ay, color);
      }
    }
    return false;
}
 
bool CBomb::animate()
{  
	bool destroy_bomb=false;

	int block_type=sprite::remove_blocking(BLK_BOMB);

	if (block_type)
	{
		destroy_bomb=true;
	}
	else
	{
		realX = realX + DX;
		realY = realY + DY;
		
		place((int) realX,(int) realY);
		
		block_type=sprite::paste_blocking(BLK_BOMB);
        if (block_type)
		   destroy_bomb=true;
        else
        {
	      // explode near centre of planet
	      if (step++ > max_steps)
	         destroy_bomb=true;
        }				
	}
	
	if (destroy_bomb==true)
	{
      sprite::remove_blocking(BLK_BOMB);

	  double DX_mod=0,DY_mod=0;

	  // bomb goes a bit into planet
	  if (block_type==BLK_PLANET)
	  {
		  while (abs((int )DX_mod)<10 && abs((int )DY_mod)<10)
		  {
			  DX_mod+=DX;
			  DY_mod+=DY;
		  }
	  }
	  else if (!game_over) // not hit the moon
	  {
		score+=50;		  
	  }
		  	  
      sprites.push_back( new CExplosion(X+(int )DX_mod,Y+(int )DY_mod) );
      return true;
    }      
    
    return false;
}


bool CSight::animate()
{
 sprite::animate();

 int DX=0,DY=0;

 if (control_mouse)
 {
	 place(mouse_x,mouse_y);
 }
 else
 {
	 if (getX()>15 && (key[KEY_LEFT]||joy_left)) DX-=1;
	 if (getX()<SCREEN_SIZE_X-15 && (key[KEY_RIGHT]||joy_right)) DX+=1;
	 if (getY()>15 && (key[KEY_UP]||joy_up)) DY-=1;
	 if (getY()<SCREEN_SIZE_Y-15 && (key[KEY_DOWN]||joy_down)) DY+=1; 	 
	 move(DX,DY);
 }


  if ( !satellite_destroyed &&
       fire_pressed==false &&
       (joy_b1||key_shifts&KB_CTRL_FLAG||key[KEY_SPACE]||mouse_b&1) &&
       number_of_missiles<5)
  {
#ifdef MOUSE_REQUIRES_TIME
	  if (!control_mouse || mouse_can_fire)
#endif	  
	  {
		  CMissile *n = new CMissile(Satellite->getX(),Satellite->getY(),X,Y,BLK_FRIENDLY_MISSILE);
		  sprites.push_back(n);
		  fire_pressed=true;
	  }
  }

 return FALSE;
}

bool CSatellite::animate()
{
 int tx,ty;

 if ((satellite_immortal/15)%2==0)
	 sprite_buffer = satellite_frame;
 else
	 sprite_buffer = satellite_immortal_frame;
 
 sprite::animate();
 
 angle-=0.3;
 
 if (angle<0)
  angle=360;
    
 tx = SCREEN_SIZE_X/2 + (int) (150*sin((angle*3.1415926535897932384626433832795)/180));
 ty = SCREEN_SIZE_Y/2 + (int) (150*cos((angle*3.1415926535897932384626433832795)/180));

 place(tx,ty);

 if (!satellite_immortal && blocking->getblocking(X,Y)==BLK_BOMB)
 {
	 sprites.push_back( new CExplosion(X-7,Y-2) );  
	 sprites.push_back( new CExplosion(X+5,Y-6) );  
	 sprites.push_back( new CExplosion(X+7,Y+4) );  
     sprites.push_back( new CExplosion(X,Y) );  
     satellite_destroyed=400;
     number_of_satellites--;
 } 
 return FALSE;
}


CSatellite::CSatellite(int _X,int _Y)
  : sprite(_X,_Y, satellite_frame, NULL) {
  frame=0;
  angle=0;
  
  int tx,ty;
  tx = SCREEN_SIZE_X/2 + (int) (150*sin((angle*3.1415926535897932384626433832795)/180));
  ty = SCREEN_SIZE_Y/2 + (int) (150*cos((angle*3.1415926535897932384626433832795)/180));
  place(tx,ty);
  
 }
 
CSight::CSight(int _X,int _Y)
  : sprite(_X,_Y,sight_frame,NULL)
{
  frame=0;
  place(SCREEN_SIZE_X/2,SCREEN_SIZE_Y/2);
}
 
void background::draw(BITMAP*dest) {
  blit(backdrop,dest,0,0,0,0,backdrop->w,backdrop->h);
}

CExplosion::CExplosion(int _X,int _Y)
  : sprite(_X,_Y)
{
   frame = 0;
   explosion_type = rand()%4;
   set_sprite_buffer(explosion_anim[explosion_type][0]);

   hotX=X - EXPLOSION_SIZE/2;
   hotY=Y - EXPLOSION_SIZE/2;
   
   // play sample
   if (!run_without_sound)
   {
      if (!game_over)
	  {
			  pan = (getX()*256)/SCREEN_SIZE_X;
			  if (inverse_sound)
				  pan = 255-pan;

			  play_sample((SAMPLE*)data[OBJ_SOUND_EXPL].dat, 255, pan, pitch, FALSE);			  
	  }
   }
}

bool CExplosion::animate()
{      
    sprite_buffer = explosion_anim[explosion_type][frame/3];
    sprite_mask = mask_explosion_anim[explosion_type][frame/3];
	
    if (frame%5==0)    
    {
	   paste_blocking(BLK_EXPLOSION);		
       destroy_backdrop();		
    }
	
    if (frame==149*3)
	{
	  sprite_mask = mask_explosion_clear[explosion_type];
      sprite::remove_blocking(BLK_EXPLOSION);		
      destroy_backdrop();
      return true;
	}
	
    frame++;	
    return false;
}


void CExplosion::destroy_backdrop()
{
	int col;
    if (!((X>SCREEN_SIZE_X/2-MOON_SIZE_X/2-size_x/2-1) &&
	       (X<SCREEN_SIZE_X/2+MOON_SIZE_X/2+size_x/2+1) &&
           (Y>SCREEN_SIZE_Y/2-MOON_SIZE_Y/2-size_y/2-1) &&
           (Y<SCREEN_SIZE_Y/2+MOON_SIZE_Y/2+size_y/2+1)))
        return;
	
     for (int ax=0;ax<size_x;ax++)
	    for (int ay=0;ay<size_y;ay++)
	    {
			col = sprite_mask[size_x*ay+ax];
			if (col!=0)
				putpixel(backdrop,hotX+ax,hotY+ay, 0);
	    }		  			
}

int CExplosion::paste_blocking(int color)
{
	int col;
	for (int ax=0;ax<size_x;ax++)
		for (int ay=0;ay<size_x;ay++)
		{
			col = sprite_mask[size_x*ay+ax];
			if (col!=0)
				blocking->setblocking(hotX+ax,hotY+ay, color);
		}
		return false;
}


CUfo::CUfo()
: sprite(0,0,ufo_frame[0], mask_ufo_frame)
{
    // choose starting and destination point
    
    int a = rand()%400;
    int ax, ay, tx, ty;
    
    if (a<100)
    {
        ax = rand()%SCREEN_SIZE_X;
        ay = -20;
        if (ax>SCREEN_SIZE_X/2)
          tx = SCREEN_SIZE_X;
        else
          tx = 0;
        ty = SCREEN_SIZE_Y+20;
    }
    else if (a<200)
    {
        ax = rand()%SCREEN_SIZE_X;
        ay = SCREEN_SIZE_Y+20;
        if (ax>SCREEN_SIZE_X/2)
          tx = SCREEN_SIZE_X;
        else
          tx = 0;
        ty = -20;
    }
    else if (a<300)
    {
        ax = -30;
        ay = rand()%SCREEN_SIZE_Y;
        tx = SCREEN_SIZE_X+30;
        if (ay>SCREEN_SIZE_Y/2)
          ty = SCREEN_SIZE_Y;
        else
          ty = 0;
        
        ty = rand()%ay;
        
    }
    else if (a<400)
    {
        ax = SCREEN_SIZE_X+30;
        ay = rand()%SCREEN_SIZE_Y;
        tx = -30;
        if (ay>SCREEN_SIZE_Y/2)
          ty = SCREEN_SIZE_Y;
        else
          ty = 0;
    }        
    
    // place in position
    
    place(ax,ay);
    
    realX = ax;
    realY = ay;
 
    double nx = tx - ax - size_x/2;
    double ny = ty - ay - size_y/2;
    
    double dist = sqrt(nx*nx + ny*ny)/2;

	dist=dist*8;
    
    DX = (nx / dist)/3;
    DY = (ny / dist)/3;
    
    step=0;
    max_steps=(int) dist;        
    frame=0;
    
    if (number_of_ufo==0)
    {
       if (!run_without_sound)    
	   {
		   pan = (getX()*256)/SCREEN_SIZE_X;
		   if (inverse_sound)
			   pan = 255-pan;
		   
		   play_sample((SAMPLE*)data[OBJ_UFO_WARNING].dat, 255, pan, pitch, TRUE);
	   }
    }
          
    number_of_ufo++;
}


bool CUfo::animate()
{  
	bool destroy_ufo=false;
    if (sprite::remove_blocking(BLK_ENEMY_MISSILE))
		destroy_ufo=true;
	else
	{
		realX = realX + DX;
		realY = realY + DY;
		
		place((int) realX,(int) realY);
		
        sprite_buffer = ufo_frame[frame/5];
    
        frame++;
        if (frame>=UFO_FRAMES*5)
           frame=0;		
		
        if (sprite::paste_blocking(BLK_ENEMY_MISSILE))
		   destroy_ufo=true;
        else
        {
	      // explode near centre of planet
        }				
	}
	
    if (step++ > max_steps)
        return true;
	
	if (destroy_ufo==true)
	{
      sprite::remove_blocking(BLK_ENEMY_MISSILE);
    
      sprites.push_back(new CExplosion(X-15,Y));  
      sprites.push_back(new CExplosion(X+15,Y));  
      sprites.push_back(new CExplosion(X,Y));  
      return true;
    }

	if (X>MIN_X && X<MAX_X && Y>MIN_Y && Y<MAX_Y)
	{
		if (rand()%600==0)
		{
			CMissile *n = new CMissile(X,Y,SCREEN_SIZE_X/2,SCREEN_SIZE_Y/2,BLK_ENEMY_MISSILE);
			sprites.push_back(n);        
		}    
	}
   
    return false;
}

CUfo::~CUfo()
{
    if (!game_over)
       score+=200;

    number_of_ufo--;
    if (number_of_ufo==0)
    {
       if (!run_without_sound)    
           stop_sample((SAMPLE*)data[OBJ_UFO_WARNING].dat);              
    }
}
