//
//  **************************************************************************
//
//  protdisp.cpp
//  (C) 2004 Bosco K. Ho 
//
//  ProteinDisplay is a child of Protein and includes drawing functions
//  to a GraphicsView object and other graphics orientated operations.
//
//  **************************************************************************
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published
//  by the Free Software Foundation; either version 2.1 of the License, or (at
//  your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,  but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details. 
//  
//  You should have received a copy of the GNU Lesser General Public License 
//  along with this program; if not, write to the Free Software Foundation, 
//  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//  **************************************************************************
//


#include "protdisp.h"

using namespace std;
           
int atomColor(int resKey, int atomKey)
{
	switch (getAtomName(resKey, atomKey)[1])
	{
		case 'C':
			return LIGHT_GREY;
			break;
		case 'H':
			return  WHITE;
			break;
		case 'O':
			return  RED;
			break;
		case 'N':
			return  BLUE;
			break;
		case 'S':
			return  YELLOW;
			break;
	}
  return LIGHT_GREY;
}

               

void ProteinDisplay::rebuild(void)
{
  if (nRes() < 1) return;

  rebuildBackboneFromScratch(1);
	sproutWholeSidechain(1);

	for (int i=2; i<=nRes(); i++)
  {
		sproutBackboneFromPrev(i);
		sproutWholeSidechain(i);
	}
}



//  Translating graphical objects into 3d graphics primitives

void ProteinDisplay::draw_line(int i, int a, int j, int b, int color)
{
  if (hasAtom(i,a) && hasAtom(j,b))
	{
    Vector3d& p1 = res(i).atom(a).pos;
    Vector3d& p2 = res(j).atom(b).pos;
    if (!isSolid)
      graphicsView->project_thinline(p1, p2, color);
    else
      graphicsView->project_thickline(p1, p2, color, DISPLAY_LINE_WIDTH);
  }
}



void ProteinDisplay::draw_bond(int i, int a, int j, int b)
{
  if ( !isHydrogen )
    if ( (getAtomName(res(i).resKey, res(i).atom(a).atomKey)[1] == 'H' ) ||
         (getAtomName(res(j).resKey, res(j).atom(b).atomKey)[1] == 'H' ) )
      return;

  if (hasAtom(i,a) && hasAtom(j,b))
	{
    Vector3d& p1 = res(i).atom(a).pos;
    Vector3d& p2 = res(j).atom(b).pos;
    Vector3d mid = (p1 + p2) * 0.5;
    if (!isSolid)
		{
      graphicsView->project_thinline(p1, mid, atomColor(res(i).resKey, a));
      graphicsView->project_thinline(p2, mid, atomColor(res(j).resKey, b));
    }
    else
		{
      graphicsView->project_thickline(p1, p2, GREY, DISPLAY_LINE_WIDTH);
    }
  }
}



void ProteinDisplay::draw_atom(int r, int a)
{
	Vector3d& p = atom(r, a).pos;

	if (isSolid)
     graphicsView->project_circlefill(p, DISPLAY_ATOM_RADIUS, atomColor(res(r).resKey, a));

  int zout;
  if (graphicsView->isInCircle(p, DISPLAY_ATOM_RADIUS, mouse_x, mouse_y, &zout))
  {
	  if (highlight_res == 0)
		{
			highlight_res = r;
			highlight_atom = a;
			highlight_z = zout;
		}
		else if (zout < highlight_z)
		{
			highlight_res = r;
			highlight_atom = a;
			highlight_z = zout;
		}

  }
}



void ProteinDisplay::draw_highlight_atom(int res, int a, int color, int highlight_size)
{
	if (res == 0) return;
	graphicsView->project_enlarged_circle(atom(res, a).pos, DISPLAY_ATOM_RADIUS, highlight_size, color);
}



void ProteinDisplay::draw_peptide_plane(int i)
{
  Vector3d v[4];

	if (res(i).resKey == PRO)
  {
    if ( hasAtom(i-1, CA) && hasAtom(i-1, O) && hasAtom(i, CA) && hasAtom(i, CD1) )
    {

	  	v[0] = atom(i-1, CA).pos;
		  v[1] = atom(i-1, O).pos;
  		v[2] = atom(i,   CA).pos;
	  	v[3] = atom(i,   CD1).pos;
		  graphicsView->project_quad(v, DARK_GREY);
  	}
  }
	else
	{
    if ( hasAtom(i-1, CA) && hasAtom(i-1, O) && hasAtom(i, CA) && hasAtom(i, N) )
    {
      v[0] = atom(i-1, CA).pos;
  		v[1] = atom(i-1, O).pos;
    	v[2] = atom(i,   CA).pos;
      if (isHydrogen && hasAtom(i, H))
        v[3] = atom(i, H).pos;
      else
        v[3] = atom(i, N).pos;

		  graphicsView->project_quad(v, DARK_GREY);
    }
	}
}



void ProteinDisplay::draw_distance_measure(int i, int a, int j, int b)
{
	draw_line(i, a, j, b, BLUE);
	draw_highlight_atom(i, a, BLUE, 4);

	draw_highlight_atom(j, b, BLUE, 4);

  Vector3d& p1 = res(i).atom(a).pos;
  Vector3d& p2 = res(j).atom(b).pos;
  Vector3d mid = (p1 + p2) * 0.5;
	graphicsView->project_number(mid, LIGHT_BLUE, sqrt(distanceSquared(p1, p2)));
}



void ProteinDisplay::draw_residue(int i)
{
	draw_bond(i, CA, i, HA1);
	draw_bond(i, CA, i, C);
	draw_bond(i, C,  i, O);
	draw_bond(i, CA, i, N);
	draw_bond(i, N, i, H);

  draw_bond(i, C,  i, OXT);
	draw_bond(i, OXT,i, HXT);
  draw_bond(i, N, i, H2);
	draw_bond(i, N, i, H3);

	if (res(i).resKey != GLY)
    draw_bond(i, CA, i, CB);
  else
		draw_bond(i, CA, i, HA2);

	if (res(i).resKey == PRO)
  {
		draw_bond(i, CB,  i, CG1);
		draw_bond(i, CG1, i, CD1);
		draw_bond(i, CA,  i, N);
		draw_bond(i, N,   i, CD1);

		draw_bond(i, CD1, i, N);
		draw_bond(i, CD1, i, HD11);
		draw_bond(i, CD1, i, HD12);
		draw_bond(i, CB,  i, HB1);
		draw_bond(i, CB,  i, HB2);
		draw_bond(i, CG1, i, HG11);
		draw_bond(i, CG1, i, HG12);
  }

  if (isSidechain)
	{
		switch (res(i).resKey)
		{
			case ALA:
				draw_bond(i, CB, i, HB1);
				draw_bond(i, CB, i, HB2);
				draw_bond(i, CB, i, HB3);

				break;
			case CYS:
				draw_bond(i, CB, i, HB1);
				draw_bond(i, CB, i, HB2);
				draw_bond(i, CB, i, SG1);
				draw_bond(i, SG1, i, HG11);

				break;
			case SER:
				draw_bond(i, CB,  i, HB1);
				draw_bond(i, CB,  i, HB2);
				draw_bond(i, CB,  i, OG1);
				draw_bond(i, OG1, i, HG11);
				break;
			case ASP:
				draw_bond(i, CB,  i, HB1);

				draw_bond(i, CB,  i, HB2);
				draw_bond(i, CB,  i, CG1);
				draw_bond(i, CG1, i, OD1);
				draw_bond(i, CG1, i, OD2);
				draw_bond(i, OD1 ,i, HD11);
				draw_bond(i, OD2 ,i, HD21);

				break;
			case ASN:
				draw_bond(i, CB,  i, HB1);
				draw_bond(i, CB,  i, HB2);
				draw_bond(i, CB,  i, CG1);
				draw_bond(i, CG1, i, OD1);
				draw_bond(i, CG1, i, ND2);
				draw_bond(i, ND2, i, HD21);
				draw_bond(i, ND2, i, HD22);

				break;
			case GLU:
				draw_bond(i, CB,  i, HB1);
				draw_bond(i, CB,  i, HB2);
				draw_bond(i, CB,  i, CG1);

				draw_bond(i, CG1, i, HG11);
				draw_bond(i, CG1, i, HG12);
				draw_bond(i, CG1, i, CD1);
				draw_bond(i, CD1, i, OE1);
				draw_bond(i, CD1, i, OE2);
				draw_bond(i, OE1 ,i, HE11);
				draw_bond(i, OE2 ,i, HE21);

				break;
			case GLN:
				draw_bond(i, CB,  i, HB1);
				draw_bond(i, CB,  i, HB2);
				draw_bond(i, CB,  i, CG1);
				draw_bond(i, CG1, i, HG11);
				draw_bond(i, CG1, i, HG12);
				draw_bond(i, CG1, i, CD1);
				draw_bond(i, CD1, i, OE1);
				draw_bond(i, CD1, i, NE2);
				draw_bond(i, NE2, i, HE21);
				draw_bond(i, NE2, i, HE22);

				break;
			case THR:

				draw_bond(i, CB,  i, HB1);

				draw_bond(i, CB,  i, OG1);
				draw_bond(i, OG1, i, HG11);

				draw_bond(i, CB,  i, CG2);
				draw_bond(i, CG2, i, HG21);
				draw_bond(i, CG2, i, HG22);
				draw_bond(i, CG2, i, HG23);

				break;
			case VAL:
				draw_bond(i, CB,  i, HB1);

				draw_bond(i, CB,  i, CG1);
				draw_bond(i, CG1, i, HG11);
				draw_bond(i, CG1, i, HG12);
				draw_bond(i, CG1, i, HG13);

				draw_bond(i, CB,  i, CG2);
				draw_bond(i, CG2, i, HG21);
				draw_bond(i, CG2, i, HG22);
				draw_bond(i, CG2, i, HG23);

				break;
			case ILE:
				draw_bond(i, CB,  i, HB1);

				draw_bond(i, CB,  i, CG1);
				draw_bond(i, CG1, i, HG11);
				draw_bond(i, CG1, i, HG12);


				draw_bond(i, CG1, i, CD1);
				draw_bond(i, CD1, i, HD11);
				draw_bond(i, CD1, i, HD12);
				draw_bond(i, CD1, i, HD13);

				draw_bond(i, CB,  i, CG2);
				draw_bond(i, CG2, i, HG21);
				draw_bond(i, CG2, i, HG22);
				draw_bond(i, CG2, i, HG23);


				break;
			case LEU:
				draw_bond(i, CB,  i, HB1);
				draw_bond(i, CB,  i, HB2);

				draw_bond(i, CB,  i, CG1);
				draw_bond(i, CG1, i, HG11);

				draw_bond(i, CG1, i, CD1);
				draw_bond(i, CD1, i, HD11);
				draw_bond(i, CD1, i, HD12);
				draw_bond(i, CD1, i, HD13);
				draw_bond(i, CG1, i, CD2);
				draw_bond(i, CD2, i, HD21);
				draw_bond(i, CD2, i, HD22);
				draw_bond(i, CD2, i, HD23);

				break;
			case LYS:
				draw_bond(i, CB, i, HB1);
				draw_bond(i, CB, i, HB2);

				draw_bond(i, CB, i, CG1);
				draw_bond(i, CG1, i, HG11);
				draw_bond(i, CG1, i, HG12);

				draw_bond(i, CG1, i, CD1);
				draw_bond(i, CD1, i, HD11);
				draw_bond(i, CD1, i, HD12);

				draw_bond(i, CD1, i, CE1);
				draw_bond(i, CE1, i, HE11);
				draw_bond(i, CE1, i, HE12);

				draw_bond(i, CE1, i, NZ1);
				draw_bond(i, NZ1, i, HZ11);
				draw_bond(i, NZ1, i, HZ12);
				draw_bond(i, NZ1, i, HZ13);

				break;
			case MET:
				draw_bond(i, CB, i, HB1);
				draw_bond(i, CB, i, HB2);

				draw_bond(i, CB, i, CG1);
				draw_bond(i, CG1, i, HG11);
				draw_bond(i, CG1, i, HG12);

				draw_bond(i, CG1, i, SD1);

				draw_bond(i, SD1, i, CE1);
				draw_bond(i, CE1, i, HE11);
				draw_bond(i, CE1, i, HE12);
				draw_bond(i, CE1, i, HE13);


				break;
			case ARG:
				draw_bond(i, CB, i, HB1);
				draw_bond(i, CB, i, HB2);

				draw_bond(i, CB, i, CG1);
				draw_bond(i, CG1, i, HG11);
				draw_bond(i, CG1, i, HG12);

				draw_bond(i, CG1, i, CD1);
				draw_bond(i, CD1, i, HD11);
				draw_bond(i, CD1, i, HD12);

				draw_bond(i, CD1, i, NE1);
				draw_bond(i, NE1, i, HE11);

				draw_bond(i, NE1, i, CZ1);

				draw_bond(i, CZ1, i, NH1);
				draw_bond(i, NH1, i, HH11);
				draw_bond(i, NH1, i, HH12);

				draw_bond(i, CZ1, i, NH2);
				draw_bond(i, NH2, i, HH21);
				draw_bond(i, NH2, i, HH22);
				break;
			case HIS:
				draw_bond(i, CB, i, HB1);
				draw_bond(i, CB, i, HB2);

				draw_bond(i, CB, i, CG1);
				draw_bond(i, CG1, i, ND1);
				draw_bond(i, ND1, i, CE1);
				draw_bond(i, CE1, i, NE2);
				draw_bond(i, NE2, i, CD2);
				draw_bond(i, CD2, i, CG1);

				draw_bond(i, ND1, i, HD11);
				draw_bond(i, CE1, i, HE11);
				draw_bond(i, CG2, i, HG21);
				draw_bond(i, CD2, i, HD21);
				draw_bond(i, NE2, i, HE21);

				break;
			case TRP:
				draw_bond(i, CB, i, HB1);
				draw_bond(i, CB, i, HB2);

				draw_bond(i, CB, i, CG1);
				draw_bond(i, CG1, i, CD1);
				draw_bond(i, CD1, i, NE1);
				draw_bond(i, NE1, i, CE2);
				draw_bond(i, CE2, i, CD2);
				draw_bond(i, CD2, i, CG1);

				draw_bond(i, CE2, i, CZ2);
				draw_bond(i, CZ2, i, CH2);
				draw_bond(i, CD2, i, CE3);
				draw_bond(i, CE3, i, CZ3);
				draw_bond(i, CZ3, i, CH2);

				draw_bond(i, CD1, i, HD11);
				draw_bond(i, NE1, i, HE11);
				draw_bond(i, CG2, i, HG21);
				draw_bond(i, CE3, i, HE31);
				draw_bond(i, CZ2, i, HZ21);
				draw_bond(i, CZ3, i, HZ31);
				draw_bond(i, CH2, i, HH21);
				break;
			case PHE:
				draw_bond(i, CB, i, HB1);

				draw_bond(i, CB, i, HB2);

				draw_bond(i, CB, i, CG1);
				draw_bond(i, CG1, i, CD1);
				draw_bond(i, CD1, i, CE1);
				draw_bond(i, CE1, i, CZ1);
				draw_bond(i, CZ1, i, CE2);
				draw_bond(i, CE2, i, CD2);
				draw_bond(i, CD2, i, CG1);

				draw_bond(i, CD1, i, HD11);
				draw_bond(i, CE1, i, HE11);
				draw_bond(i, CZ1, i, HZ11);
				draw_bond(i, CG2, i, HG21);
				draw_bond(i, CD2, i, HD21);
				draw_bond(i, CE2, i, HE21);

				break;
			case TYR:
				draw_bond(i, CB, i, HB1);
				draw_bond(i, CB, i, HB2);

				draw_bond(i, CB, i, CG1);
				draw_bond(i, CG1, i, CD1);
				draw_bond(i, CD1, i, CE1);
				draw_bond(i, CE1, i, CZ1);
				draw_bond(i, CZ1, i, CE2);
				draw_bond(i, CE2, i, CD2);
				draw_bond(i, CD2, i, CG1);

				draw_bond(i, CD1, i, HD11);
				draw_bond(i, CE1, i, HE11);
				draw_bond(i, CZ1, i, OH1);
				draw_bond(i, OH1, i, HH11);
				draw_bond(i, CG2, i, HG21);
				draw_bond(i, CD2, i, HD21);
				draw_bond(i, CE2, i, HE21);

				break;
		}
  }

  for (AtomIter a = res(i).atomBegin(); a != res(i).atomEnd(); a++)
    if ( !(!isHydrogen && (getAtomName(a->resKey, a->atomKey)[1] == 'H')) )
		{
  	  if ( (a->atomKey > CB) && (a->resKey != PRO) )
			{
        if (isSidechain) draw_atom(i, a->atomKey);
      }
      else
        draw_atom(i, a->atomKey);
    }

}




