//
//  **************************************************************************
//
//  pdbreader.h
//  (C) 2003 Bosco K. Ho 
//
//  Adapted from the The Biomolecule Toolkit (C) 2001, Eric Alm 
//	Keep the PDB interface separate from the rest of the code. 
//
//  **************************************************************************
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published
//  by the Free Software Foundation; either version 2.1 of the License, or (at
//  your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,  but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details. 
//  
//  You should have received a copy of the GNU Lesser General Public License 
//  along with this program; if not, write to the Free Software Foundation, 
//  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//  **************************************************************************
//


#ifndef pdbreader_h
#define pdbreader_h

#include <string>
#include <vector>
#include <iostream>
#include "protein.h"



class PdbReader
{
  public:

    PdbReader(std::string const & filename) : 
      _filename(filename), _stream(NULL), _buffer(), 
      _hasLoadedModel(false), _hasLoadedStream(false)
    {
      loadStream();
    }

    PdbReader(std::istream& stream) : 
      _filename(), _stream(&stream), _buffer(), 
      _hasLoadedModel(false), _hasLoadedStream(false) {}

    ~PdbReader();

    std::string       getHeader();
    void              loadChain(Protein& p, const char chainLabel = '?');
    std::vector<char> getChainLabels();
    std::string       getPdbCode();
    bool              isFileLoaded() { return _hasLoadedStream; };
  
  private:
    void loadStream(); // prepares for input from a stream
    void loadModel();  // loads a complete model into _buffer
  
    typedef std::deque<std::string> BufferList;

    std::string       _filename;
    std::istream*     _stream;
    BufferList        _buffer;
    bool              _hasLoadedModel;
    bool              _hasLoadedStream;
};
  


#endif // pdbreader_h


