//
//  ****************************************************************************
//
//  molecule.h
//
//  (C) 2003 Bosco K. Ho 
//  Adapted from The Biomolecule Toolkit (C) 2001, Eric Alm 
//
//  ****************************************************************************
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published
//  by the Free Software Foundation; either version 2.1 of the License, or (at
//  your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,  but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details. 
//  
//  You should have received a copy of the GNU Lesser General Public License 
//  along with this program; if not, write to the Free Software Foundation, 
//  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//  ****************************************************************************
//
 

#ifndef molecule_h_
#define molecule_h_

#include <vector>
#include "vector3d.h"
#include "atoms.h"


class Molecule {

public:
  Molecule(char chain_id = ' ', const std::string& name = "untitled");
  Molecule(const Molecule& rhs): _atomList(rhs._atomList), _id(rhs._id), _name(rhs._name), 
					 _principalAxes(rhs._principalAxes), _centerOfMass(rhs._centerOfMass) {}
  virtual ~Molecule() {};

  void setName(const std::string& name)  { _name = name; }
  std::string getName() const            { return _name; }
  
  void setId(char id)                    { _id = id; }
  char getId() const                     { return _id; }

	AtomIter getAtomIter(int i);
  void insert(int i, Molecule& molecule);
  void erase(int i, int j);
	Molecule extract(int i, int j);

  void computeCenterOfMass();
  Vector3d getCenterOfMass() const { return _centerOfMass;}

  virtual double getMaxLength();
  
  // It calls computecenterOfMass().
  // virtual void computePrincipalAxes();
	// Vector3d getPrincipalAxis(int i) { return _principalAxes[i];}

  void translate(const Vector3d& delta);
  void rotate(const Vector3d& axis, double theta, const Vector3d& centerOfRotation);
  void rotate(const Vector3d& axis, double theta) { rotate(axis, theta, _centerOfMass); }
  void rotate(const Matrix3d& rotateMatrix, const Vector3d& centerOfRotation);

  void applyMatrix(const Matrix3d& transformMatrix);

  AtomSizeType nAtoms() const { return _atomList.size(); }

	AtomIter atomIter(int i) { 
		AtomIter a = _atomList.begin();
		for (int j=0; j<i; j++)
			a++;
		return a;
	}
	Atom& atom(int i)                          { return *atomIter(i);	}
	AtomIter atomBegin()                       { return _atomList.begin(); }
	AtomIter atomEnd()                         { return _atomList.end(); }
	void pushAtom(Atom& a)                     { _atomList.push_back(a); }
	AtomIter insertAtom(AtomIter& iter, Atom& a)
                                             { return _atomList.insert(iter, a); }
	void clear()                               { _atomList.clear(); }

//protected:

  AtomList               _atomList;
  char                   _id;
  std::string            _name;
  std::vector<Vector3d>  _principalAxes; 
  Vector3d               _centerOfMass; 

};


#endif
