//
//  ****************************************************************************
//
//  graphic3d.h
//
//  (C) Thu Mar 29 2004 Bosco K. Ho 
//
//  ****************************************************************************
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published
//  by the Free Software Foundation; either version 2.1 of the License, or (at
//  your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,  but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details. 
//  
//  You should have received a copy of the GNU Lesser General Public License 
//  along with this program; if not, write to the Free Software Foundation, 
//  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//  ****************************************************************************
//
//

#ifndef _display_h
#define _display_h

#include <math.h>
#include <string>
#include <vector>
#include <list>
#include <fstream>

#include <allegro.h>
#include "protein.h"
#include "pdbreader.h"
#include "vector3d.h"
#include "graphic3d.h"
#include "protdisp.h"
#include "widget.h"
#include "bond.h"


// the CA-CA distance limit for the sphere view
const  double   CA_DIST_SQ       = 10.0 * 10.0;

// length of the scrollbar
const  int      VIEW_SIZE        = 30;

// action mode for left mouse clicks
const  int      PICK_RESIDUE     = 0;
const  int      PICK_DISTANCE    = 1;

// display mode for protein
const  int      SHOW_ALL         = 0;
const  int      SHOW_SEGMENT     = 1;
const  int      SHOW_SPHERE      = 2;

// display mode for protein
const  int      STEREO_NONE         = 0;
const  int      STEREO_CROSSEYE     = 1;
const  int      STEREO_WALL_TO_WALL = 2;

// This class mediates interaction from program with 3d view and
// proteins
class DisplayBox : public Widget
{
public:

  int      showState;
  int      pickState;
  int      stereoState;

  // orientation for camera relative to protein
  Vector3d focus_pos;
  Vector3d focus_up;
  Vector3d focus_axis;

  Vector3d camera_look;
  Vector3d camera_up;

  bool     isCentered;
  bool     isHbond;
  bool     isSidechain;
  bool     isSolid;
  bool     isPeptide;
  bool     isHydrogen;
  
  int      highlight_res;
  int      highlight_atom;
  int      highlight_z;

  int      view_left_res;
  int      view_right_res;

  int      focus_res;
  int      focus_atom;

  // residues that can be changed 
  int      active_left_res;
  int      active_right_res;

  // atoms to be measured
  int      line_res;
  int      line_atom;
  int      line_res2;
  int      line_atom2;

  GraphicsView graphicsView;

  HbondList hbondList;
  WeakHbondList weakHbondList;
  DisulfideBondList disulfideBondList;

  DisplayBox(ProteinDisplay* p, int x, int y, int w, int h);

  int handle(int event);
	void draw(BITMAP *b);

  void computeCamera(void);
  void setFocus(void);
  void setFocusWithSameOrientation(void);
  void initializeFocus(void);
  void countBonds();

  int _saveMouseY;
	int _saveMouseX;

  ProteinDisplay* protein;
};

#endif

