//
//  **************************************************************************
//
//  widget.cpp
//  (C) 2003 Bosco K. Ho 
//
//  Basic definition of a screen/mouse widget. Simple widgets are
//  included: clickable, toggle and state buttons. As well, a mouse drawing
//  function is included that displays text.
//
//  **************************************************************************
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published
//  by the Free Software Foundation; either version 2.1 of the License, or (at
//  your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,  but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details. 
//  
//  You should have received a copy of the GNU Lesser General Public License 
//  along with this program; if not, write to the Free Software Foundation, 
//  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//  **************************************************************************
//


#include "widget.h"



// string to show next to mouse
static std::string mouseText = "";

void setMouseText(std::string newMouseText)
{
  mouseText = newMouseText;
}



void drawMouse(BITMAP *buffer)
{
  draw_sprite(buffer, mouse_sprite, mouse_x, mouse_y);

  if (mouseText == "")
    return;

  textout(buffer, font, mouseText.c_str(), mouse_x + 12, mouse_y + 10,  BLACK);
  textout(buffer, font, mouseText.c_str(), mouse_x + 12, mouse_y + 11,  BLACK);
  textout(buffer, font, mouseText.c_str(), mouse_x + 13, mouse_y + 10,  BLACK);

  textout(buffer, font, mouseText.c_str(), mouse_x + 11, mouse_y + 9,   BLACK);
  textout(buffer, font, mouseText.c_str(), mouse_x + 11, mouse_y + 10,  BLACK);
  textout(buffer, font, mouseText.c_str(), mouse_x + 12, mouse_y + 9,   BLACK);

  textout(buffer, font, mouseText.c_str(), mouse_x + 14, mouse_y + 11,  BLACK);
  textout(buffer, font, mouseText.c_str(), mouse_x + 14, mouse_y + 12,  BLACK);
  textout(buffer, font, mouseText.c_str(), mouse_x + 13, mouse_y + 12,  BLACK);

  textout(buffer, font, mouseText.c_str(), mouse_x + 15, mouse_y + 12,  BLACK);
  textout(buffer, font, mouseText.c_str(), mouse_x + 15, mouse_y + 13,  BLACK);
  textout(buffer, font, mouseText.c_str(), mouse_x + 14, mouse_y + 13,  BLACK);

  textout(buffer, font, mouseText.c_str(), mouse_x + 13, mouse_y + 11,  WHITE);
}




////********* screen widgets **************



int Button::handle (int event) 
{
  if (event == WGT_MOUSE_B1_DOWN) 
	{
    _isMouseDown = true;
		return 1;
	}
  else if (event == WGT_MOUSE_B1_RELEASE) 
	{
	  _isMouseDown = false;
    if (isInside(mouse_x, mouse_y) && _proc != NULL)
		  (*_proc)();
		return 1;
	}
	else
    return 0;
}



void Button::draw (BITMAP *bmp) 
{
 	text_mode (-1);
	if ((_isMouseDown) && isInside(mouse_x, mouse_y)) 
	{
		rectfill (bmp, _x, _y, _x + _w - 1, _y + _h - 1, WHITE);
		textout_centre (bmp, font, _name.c_str (), _x + _w/2, _y + 4, BLACK);
	}
	else 
	{
		rect (bmp, _x, _y, _x + _w - 1, _y + _h - 1, WHITE);
		textout_centre (bmp, font, _name.c_str (), _x + _w/2, _y + 4, WHITE);
	}
}



int ToggleButton::handle (int event) 
{
  if (event == WGT_MOUSE_B1_DOWN) 
	{
    *_flagPtr = ! *_flagPtr;
    if (_proc != NULL)
		  (*_proc)();
		return 1;
	}
	else
    return 0;
}



void ToggleButton::draw (BITMAP *bmp) 
{
 	text_mode (-1);
	if (*_flagPtr) 
	{
		rectfill (bmp, _x, _y, _x + _w - 1, _y + _h - 1, WHITE);
		textout_centre (bmp, font, _name.c_str (), _x + _w/2, _y + 4, BLACK);
	}
	else 
	{
		rect (bmp, _x, _y, _x + _w - 1, _y + _h - 1, WHITE);
		textout_centre (bmp, font, _name.c_str (), _x + _w/2, _y + 4, WHITE);
	}
}



/// State selector


int StateSelector::handle (int event)
{
	if (event == WGT_MOUSE_B1_DOWN) 
	{
    *_valPtr = _val;
    if (_proc != NULL)
		  (*_proc)();
    return 1;
  }
  return 0;
}


void StateSelector::draw (BITMAP *bmp) 
{
 	text_mode (-1);
	if (*_valPtr == _val) 
	{
		rectfill (bmp, _x, _y, _x + _w - 1, _y + _h - 1, WHITE);
		textout_centre (bmp, font, _name.c_str (), _x + _w/2, _y + 4, BLACK);
	}
	else {
		rect (bmp, _x, _y, _x + _w - 1, _y + _h - 1, WHITE);
		textout_centre (bmp, font, _name.c_str (), _x + _w/2, _y + 4, WHITE);
	}
}



void WidgetList::draw(BITMAP *bmp)
{
  clear_bitmap(bmp);
  for (int i=0; i<_widgets.size(); i++) 
	  _widgets[i]->draw(bmp);
}



void WidgetList::handle_mouse()
{
    // send input from mouse to _widgets
		if (mouseB1Index != -1) 
		{
			if (mouse_b & 1) 
        _widgets[mouseB1Index]->handle (WGT_MOUSE_B1_DRAG);
			else 
			{
        _widgets[mouseB1Index]->handle (WGT_MOUSE_B1_RELEASE);
        mouseB1Index = -1;
 			}
		}
		else if (mouse_b & 1) 
		{
      for (int i = _widgets.size () - 1; i >= 0; i--) 
        if (_widgets[i]->isInside (mouse_x, mouse_y)) 
				{
          mouseB1Index = i;
          _widgets[i]->handle (WGT_MOUSE_B1_DOWN);
					break;
				}
    }

		if (mouseB2Index != -1) 
		{
			if (mouse_b & 2) 
        _widgets[mouseB2Index]->handle (WGT_MOUSE_B2_DRAG);
			else 
			{
        _widgets[mouseB2Index]->handle (WGT_MOUSE_B2_RELEASE);
        mouseB2Index = -1;
 			}
		}
		else if (mouse_b & 2) 
		{
      for (int i = _widgets.size () - 1; i >= 0; i--) 
        if (_widgets[i]->isInside (mouse_x, mouse_y)) 
				{
          mouseB2Index = i;
          _widgets[i]->handle (WGT_MOUSE_B2_DOWN);
					break;
				}
    }

}


