//
//  ****************************************************************************
//
//  graphic3d.h
//
//  (C) Thu Mar 25 2004 Bosco K. Ho 
//
//  ****************************************************************************
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published
//  by the Free Software Foundation; either version 2.1 of the License, or (at
//  your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,  but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details. 
//  
//  You should have received a copy of the GNU Lesser General Public License 
//  along with this program; if not, write to the Free Software Foundation, 
//  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//  ****************************************************************************
//
//

#ifndef _graphic3d_h_
#define _graphic3d_h_

#include <allegro.h>
#include <list>
#include "vector3d.h"

// graphical objects for display //
typedef enum 
{
  GFX_QUADFILL,
  GFX_CIRCLEFILL,
  GFX_CIRCLE,
  GFX_QUAD,
  GFX_LINE,
  GFX_NUMBER,
  GFX_QUAD_OUTLINE,
  GFX_CIRCLE_OUTLINE
};



class GfxObject 
{
  public:
  	int id;
  	int v[8];
  	int z;
    float val;
  	int color;
    friend bool operator < (const GfxObject& a, const GfxObject& b) 
    {
     return (a.z > b.z);
    }
};



class GfxList
{
  public:
    GfxList() {}
    ~GfxList() {}

    void clear();
    void sort();
    void draw(BITMAP *bmp);

    void project_thickline (Vector3d& p1, Vector3d& p2, int color, double width);
    void project_thinline (Vector3d& p1, Vector3d& p2, int color);
    void project_number (Vector3d& p1, int color, double val);
    void project_quad (Vector3d v[], int color);
    void project_circlefill (Vector3d& p, double r, int color);
    void project_enlarged_circle (Vector3d& p, double r, int enlarged_r, int color);

    void setXOffset(int x) { xOffset = x; }
    void calculateMatrix(Vector3d& pos, Vector3d& front, Vector3d& up);
    void getTransform(Vector3d& v, double r,
                int *xout, int *yout, int *zout, int *radius);
    void projectPoint(Vector3d p, fixed *xout, fixed *yout, fixed *zout);

  private:
    void push(GfxObject& g);

    typedef   std::list<GfxObject> GList;
    GList    _gList;

    MATRIX    projectionMatrix;
    int      xOffset;
    Vector3d  cameraPos;
    Vector3d	cameraFront;
    Vector3d	cameraUp;
};





// this class produces a stereo display 
class GraphicsView
{
  public:
    // parameters for stereo
    bool    isStereo;
    double  stereoViewAngle;
    int     stereoSeparation;

    GfxList grList;
    GfxList grListR;

    GraphicsView() : isStereo(false), stereoViewAngle(-8.0), stereoSeparation(300) {};
    ~GraphicsView() {};

    void clear() { grList.clear(); if (isStereo) grListR.clear(); };
    void sort() { grList.sort(); if (isStereo) grListR.sort(); };
    void draw(BITMAP *bmp);
    void calculateMatrix(Vector3d& pos, Vector3d& front, Vector3d& up);

    void project_thickline (Vector3d& p1, Vector3d& p2, int color, double width);
    void project_thinline (Vector3d& p1, Vector3d& p2, int color);
    void project_number (Vector3d& p1, int color, double val);
    void project_quad (Vector3d v[], int color);
    void project_circlefill (Vector3d& p, double r, int color);
    void project_enlarged_circle (Vector3d& p, double r, int enlarged_r, int color);

    bool isInCircle(Vector3d& v, double r, int testX, int testY, int *zout);

    void setStereoSeparation(int separation) { stereoSeparation = separation; };
    void setStereoViewAngle(float viewAngle) { stereoViewAngle = viewAngle; };
};


#endif
