//
//  ***************************************************************************
//
//  atoms.cpp
//  (C) 2003 Bosco K. Ho 
//
//  definition for class atom, which is used for data storage
//  Adapted from the The Biomolecule Toolkit (C) 2001, Eric Alm 
//
//  ***************************************************************************
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published
//  by the Free Software Foundation; either version 2.1 of the License, or (at
//  your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,  but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details. 
//  
//  You should have received a copy of the GNU Lesser General Public License 
//  along with this program; if not, write to the Free Software Foundation, 
//  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//  ****************************************************************************
//


#include <iostream>
#include "atoms.h"

using namespace std;



void applyMatrix(AtomIter begin, AtomIter end, Matrix3d transMatrix) 
{
  for (AtomIter i = begin; i != end; i++)
    i->pos.applyMatrix(transMatrix);
}



ostream& operator << (ostream& os, const Atom& a)
{

  os << "Atom (atom name: " << a.atomName << ", " << a.atomKey 
     << "  on: " << a.isOn << " built: " << endl;
  os << "  aa type: " << a.resName << ", " << a.resKey << " res no: " << a.resNo << endl;
  os << "  position: " << a.pos << ")" << endl;

  return os;
}



