# include <stdio.h>
# include <stdlib.h>
# include <allegro.h>

BEGIN_COLOR_DEPTH_LIST
	COLOR_DEPTH_8
END_COLOR_DEPTH_LIST

# define H 480 // risoluzione schermo
# define W 640
# define SX 10 //coordinate dello schermo di gioco
# define DX 630
# define UP 10
# define DOWN 470
# define SU 1
# define GIU 2
# define DESTRA 3
# define SINISTRA 4


# define casuale(n) (int) (n*rand()/(RAND_MAX+1.0) )
# define abs(n) n>0?n:(-n)
# define VERO 1
# define FALSO 0
int HARD,DEBUG,N_CPU;
BITMAP *buffer;
int LATO=5;
int COLORE=3;
int COLORE_MELA=12;
int COLORE_B=45;
int TIME=50;


	
	
struct blocco
{
  int x;
  int y;
  char dir;
  struct blocco *next;
};

struct m
{
	int x;
	int y;
	int punt;
}mela;

struct serpe
{
  struct blocco *cambi;
  struct blocco *corpo;
  struct blocco *coda;
  short es;
}snake;

struct serpe *cpu;


void init_allegro(void);
void crea_serpe(int num);
void muovi_serpe();
void cambio_dir(int dir, struct serpe *s);
void esci();
void collision();
void control_dir();
void pop_blocco(struct serpe *b);
int occupato(int x,int y, struct blocco *ver);
void destroy_serpe(struct serpe *s);
void ia();
void set_parametri();

void cambio_dir(int dir,struct serpe *s)
{
	struct blocco *head;
	int x,y,n;
	x=s->corpo->x;
	y=s->corpo->y;
	if(!s->cambi)
	{
		s->cambi=malloc(sizeof(struct blocco));
		head=s->cambi;
	}
	else
	{
	 head=s->cambi;
	 while(head->next)
	 	head=head->next;
	 head->next=malloc(sizeof(struct blocco));
	 head=head->next;
	}
	head->x=x;
	head->y=y;
	head->dir=dir;
	head->next=NULL;
	if(DEBUG)
	textprintf(buffer,font,x,y,COLORE,"cambio %d,%d",x,y);

		
}

void ia()
{
	int n;
	srand(time(0));
	for(n=0;n!=N_CPU;++n)
	{
		int c;
		if(!cpu[n].es) continue;
		switch(cpu[n].corpo->dir)
		{
			case SU:
				if(occupato(cpu[n].corpo->x, cpu[n].corpo->y-LATO, cpu[n].corpo) || ( (mela.x!=cpu[n].corpo->x) &&
				(occupato(cpu[n].corpo->x,cpu[n].corpo->y-2*LATO, cpu[n].corpo))))
				{
					if((mela.x>=cpu[n].corpo->x) && (!occupato(cpu[n].corpo->x+LATO,cpu[n].corpo->y,cpu[n].corpo)))
						cambio_dir(DESTRA,&cpu[n]);
					if((mela.x<cpu[n].corpo->x ) && (!occupato(cpu[n].corpo->x-LATO,cpu[n].corpo->y,cpu[n].corpo)))
						cambio_dir(SINISTRA,&cpu[n]);
					continue;
					
				}

				break;		
			case GIU:
				if(occupato(cpu[n].corpo->x, cpu[n].corpo->y+LATO, cpu[n].corpo)|| ( (mela.x!=cpu[n].corpo->x) &&
				(occupato(cpu[n].corpo->x,cpu[n].corpo->y+2*LATO, cpu[n].corpo))))
				{
					if((mela.x>=cpu[n].corpo->x) && (!occupato(cpu[n].corpo->x+LATO,cpu[n].corpo->y,cpu[n].corpo)))
						cambio_dir(DESTRA,&cpu[n]);
					if((mela.x<cpu[n].corpo->x ) && (!occupato(cpu[n].corpo->x-LATO,cpu[n].corpo->y,cpu[n].corpo)))
						cambio_dir(SINISTRA,&cpu[n]);
					continue;
				}
					
				break;
				
			case SINISTRA:
				if(occupato(cpu[n].corpo->x-LATO, cpu[n].corpo->y, cpu[n].corpo)|| ( (mela.y!=cpu[n].corpo->y) &&
				(occupato(cpu[n].corpo->x-2*LATO,cpu[n].corpo->y, cpu[n].corpo))))
				{
					if((mela.y>=cpu[n].corpo->y) && (!occupato(cpu[n].corpo->x,cpu[n].corpo->y+LATO,cpu[n].corpo)))
							cambio_dir(GIU,&cpu[n]);
					if((mela.y<cpu[n].corpo->y ) && (!occupato(cpu[n].corpo->x,cpu[n].corpo->y-LATO,cpu[n].corpo)))
							cambio_dir(SU,&cpu[n]);
					continue;							
				}

				break;				
												
			case DESTRA:
				if(occupato(cpu[n].corpo->x+LATO, cpu[n].corpo->y, cpu[n].corpo)|| ( (mela.y!=cpu[n].corpo->y) &&
				(occupato(cpu[n].corpo->x+2*LATO,cpu[n].corpo->y, cpu[n].corpo))))
				{
					if((mela.y>=cpu[n].corpo->y) && (!occupato(cpu[n].corpo->x,cpu[n].corpo->y+LATO,cpu[n].corpo)))
							cambio_dir(GIU,&cpu[n]);
					if((mela.y<cpu[n].corpo->y ) && (!occupato(cpu[n].corpo->x,cpu[n].corpo->y-LATO,cpu[n].corpo)))
							cambio_dir(SU,&cpu[n]);
					continue;		
				
				}
				
			
		}
		if( ((cpu[n].corpo->dir==SU) || (cpu[n].corpo->dir==GIU)) && (mela.y==cpu[n].corpo->y))
		{
			if((mela.x>cpu[n].corpo->x) && (!occupato(cpu[n].corpo->x+LATO,cpu[n].corpo->y,cpu[n].corpo)))
			{
				cambio_dir(DESTRA,&cpu[n]);
				break;
			}
			if((mela.x<cpu[n].corpo->x ) && (!occupato(cpu[n].corpo->x-LATO,cpu[n].corpo->y,cpu[n].corpo)))
			{
				cambio_dir(SINISTRA,&cpu[n]);
				break;
			}
		}
		else if( ((cpu[n].corpo->dir==DESTRA) || (cpu[n].corpo->dir==SINISTRA)) && (mela.x==cpu[n].corpo->x))
		{
			if((mela.y>cpu[n].corpo->y) && (!occupato(cpu[n].corpo->x,cpu[n].corpo->y+LATO,cpu[n].corpo)))
			{
				cambio_dir(GIU,&cpu[n]);
				break;				
			}
			if((mela.y<cpu[n].corpo->y ) && (!occupato(cpu[n].corpo->x,cpu[n].corpo->y-LATO,cpu[n].corpo)))
			{
				cambio_dir(SU,&cpu[n]);
				break;				
			}
		}
		if(HARD)
		{
			if((cpu[n].corpo->dir==SU) && (mela.y>cpu[n].corpo->y))
			{
				if( (mela.x>cpu[n].corpo->x) && (!occupato(cpu[n].corpo->x+LATO,cpu[n].corpo->y,cpu[n].corpo)) )
					cambio_dir(DESTRA,&cpu[n]);
				else if (!occupato(cpu[n].corpo->x-LATO,cpu[n].corpo->y,cpu[n].corpo))
					cambio_dir(SINISTRA,&cpu[n]);
			}
			else if((cpu[n].corpo->dir==GIU) && (mela.y<cpu[n].corpo->y))
			{
				if( (mela.x>cpu[n].corpo->x) && (!occupato(cpu[n].corpo->x+LATO,cpu[n].corpo->y,cpu[n].corpo)) )
					cambio_dir(DESTRA,&cpu[n]);
				else if (!occupato(cpu[n].corpo->x-LATO,cpu[n].corpo->y,cpu[n].corpo))
					cambio_dir(SINISTRA,&cpu[n]);
			}
			else if((cpu[n].corpo->dir==DESTRA) && (mela.x<cpu[n].corpo->x))
			{
				if( (mela.x>cpu[n].corpo->x) && (!occupato(cpu[n].corpo->x,cpu[n].corpo->y-LATO,cpu[n].corpo)) )
					cambio_dir(SU,&cpu[n]);
				else if (!occupato(cpu[n].corpo->x,cpu[n].corpo->y+LATO,cpu[n].corpo))
					cambio_dir(GIU,&cpu[n]);
			}
			else if((cpu[n].corpo->dir==SINISTRA) && (mela.x>cpu[n].corpo->x))
			{
				if( (mela.x>cpu[n].corpo->x) && (!occupato(cpu[n].corpo->x,cpu[n].corpo->y-LATO,cpu[n].corpo)) )
					cambio_dir(SU,&cpu[n]);
				else if (!occupato(cpu[n].corpo->x,cpu[n].corpo->y+LATO,cpu[n].corpo))
					cambio_dir(GIU,&cpu[n]);
			}
		}
					

	}
}		
		


void destroy_serpe(struct serpe *s)
{
	struct blocco *head=s->cambi;
	s->es=0;
	while(head)
	{
		struct blocco *app=head->next;
		free(head);
		head=app;
	}
	head=s->corpo;
	while(head)
	{
		struct blocco *app=head->next;
		free(head);
		head=app;
	}
}

void crea_serpe(int num)
{
  int n,i=0;
  struct blocco *head;
  srand(time(NULL));
  snake.corpo=malloc(sizeof(struct blocco));
  head=snake.corpo;
  snake.es=VERO;
  n=(rand()%((DX-LATO)/LATO)*LATO)+SX;
  while(1)
  {
   
    ++i;
    head->x=n;
    head->y=DOWN/2+i*LATO;
    head->dir=SU;
    if(i!=num)
    {
        head->next=malloc(sizeof(struct blocco));
	head=head->next;
    }
    else
    {
    	head->next=NULL;
	snake.coda=head;
	break;
    }

    
  }
  
  for(n=0;n!=N_CPU;++n)
  {
  	  int startx,starty;
	  cpu[n].es=VERO; 
	  startx=rand()%((DX-SX)/LATO)*LATO+SX;
	  starty=rand()%((DOWN-UP)/LATO)*LATO+UP;
	  cpu[n].corpo=malloc(sizeof(struct blocco));
 	  head=cpu[n].corpo;
	  i=0;
	  while(1)	
	  {
	    ++i;
	    head->x=startx;
	    head->y=starty+i*LATO;
	    head->dir=SU;
	    if(i!=num)
	    {
        	head->next=malloc(sizeof(struct blocco));
		head=head->next;
	    }
	    else
	    {
	    	head->next=NULL;
		cpu[n].coda=head;
		break;
	    }
	}
	
    
  }
  
}  

void muovi_serpe()
{
	struct blocco *head=snake.corpo;
	int n;
	if(snake.es)
	while(head)
	{
		switch(head->dir)
		{
			case GIU:
				head->y+=LATO;
				break;
			case SU: 
				head->y-=LATO;
				break;
			case DESTRA:
				head->x+=LATO;
				break;
			case SINISTRA:
				head->x-=LATO;
				break;
		}
		head=head->next;
	}
	for(n=0;n!=N_CPU;++n)
	{
		if(!cpu[n].es)
			continue;
		head=cpu[n].corpo;
		while(head)
		{
			switch(head->dir)
			{
				case GIU:
					head->y+=LATO;
					break;
				case SU: 
					head->y-=LATO;
					break;
				case DESTRA:
					head->x+=LATO;
					break;
				case SINISTRA:
					head->x-=LATO;
					break;
			}
			head=head->next;
		}
	}
}


void crea_mela()
{
	srand(time(0));
	mela.x=rand()%((DX-SX)/LATO)*LATO+SX;
	mela.y=rand()%((DOWN-UP)/LATO)*LATO+UP;
}

void control_dir()
{
	struct blocco *head=snake.corpo;
	int n;
	while(head)
	{
		struct blocco *ch=snake.cambi;
		if(snake.es)
		while(ch)
		{
			if( (ch->x==head->x) && (ch->y==head->y) )
			{
				head->dir=ch->dir;
				if(snake.coda==head)
				{
					struct blocco *app=snake.cambi;
					while(app!=ch)
					{
						free(app);
						app=app->next;
					}
					snake.cambi=ch->next;
					break;
				}
			}
			ch=ch->next;
		}
		head=head->next;
	}
	for(n=0;n!=N_CPU;++n)
	{
		if(!cpu[n].es)
			continue;
		head=cpu[n].corpo;
		while(head)
		{
			struct blocco *ch=cpu[n].cambi;
			while(ch)
			{
				if( (ch->x==head->x) && (ch->y==head->y) )
				{
					head->dir=ch->dir;
					if(cpu[n].coda==head)
					{
						struct blocco *app=cpu[n].cambi;
						while(app!=ch)
						{
							free(app);
							app=app->next;
						}
						cpu[n].cambi=ch->next;
						break;
					}
				}
				ch=ch->next;
			}
			head=head->next;
		}
	}
}	
		
			
	
	
	

void draw_serpe(BITMAP *s) //anche mela
{
	struct blocco *head=snake.corpo;
	int n;
	hline(s,SX-1,DOWN+1,DX+1,COLORE_B);
	hline(s,SX-1,UP-1,DX+1,COLORE_B);
	vline(s,SX-1,UP-1,DOWN+1,COLORE_B);
	vline(s,DX+1,UP-1,DOWN+1,COLORE_B);
	rectfill(s,mela.x,mela.y,mela.x+LATO,mela.y+LATO,COLORE_MELA);
	if(snake.es)
	while(head)
	{
		rectfill(s,head->x,head->y,head->x+LATO,head->y+LATO,COLORE);
		head=head->next;
	}
	else
		textprintf(s,font,10,10,COLORE, "Hai perso se vuoi uscire clicca ESC");

	for(n=0;n!=N_CPU;++n)
	{
		if(!cpu[n].es)
			continue;
		head=cpu[n].corpo;
		
			
		while(head)
		{
			rectfill(s,head->x,head->y,head->x+LATO,head->y+LATO,COLORE_B);
			head=head->next;
		}	
	}

	
}	

void collision()
{	
	int n;
	if(snake.es)
	{
		if(occupato(snake.corpo->x,snake.corpo->y,snake.corpo))	
			snake.es=FALSO;
		if( (snake.corpo->x<=SX-LATO) || (snake.corpo->x>=DX) ||(snake.corpo->y<=UP-LATO) || (snake.corpo->y>=DOWN) )
			snake.es=FALSO;
		if( (snake.corpo->x==mela.x) && (snake.corpo->y==mela.y) )
		{
			crea_mela();
			pop_blocco(&snake);
		}
	}
	for(n=0;n!=N_CPU;++n)
	{
		if(!cpu[n].es)
			continue;
		if(occupato(cpu[n].corpo->x,cpu[n].corpo->y,cpu[n].corpo))
			cpu[n].es=FALSO;
		if( (cpu[n].corpo->x<=SX-LATO) || (cpu[n].corpo->x>=DX) ||(cpu[n].corpo->y<=UP-LATO) || (cpu[n].corpo->y>=DOWN) )
			cpu[n].es=FALSO;
		if( (cpu[n].corpo->x==mela.x) && (cpu[n].corpo->y==mela.y) )
		{
			crea_mela();
			pop_blocco(&cpu[n]);
		}
	}
}

int occupato(int x,int y,struct blocco *ver)
{
	int n;
	struct blocco *head=snake.corpo;
	if( (x<=SX-LATO) || (x>=DX-LATO) ||(y<=UP-LATO) || (y>=DOWN-LATO) )
		return 1;
	if(snake.es)
	while(head)
	{
			if( (x==head->x) && (y==head->y) && (head!=ver) )
				return 1;
			head=head->next;
	}
	for(n=0;n!=N_CPU;++n)
	{
		if(!cpu[n].es)
			continue;
		head=cpu[n].corpo;
		while(head)
		{
				if( (x==head->x) && (y==head->y) && (head!=ver) )
					return 1;
				head=head->next;
		}
	}
	return 0;
}


void pop_blocco(struct serpe *b)
{
	struct blocco *prev=b->coda;
	int n;
	prev->next=malloc(sizeof(struct blocco));
	prev->next->dir=prev->dir;
	prev=prev->next;
	switch(prev->dir)
	{
		case SU:
			prev->x=b->coda->x;
			prev->y=b->coda->y+LATO;
			break;
		case GIU:
			prev->x=b->coda->x;
			prev->y=b->coda->y-LATO;
			break;
		case DESTRA:
			prev->x=b->coda->x-LATO;
			prev->y=b->coda->y;
			break;
		case SINISTRA:
			prev->x=b->coda->x+LATO;
			prev->y=b->coda->y;
	}
	prev->next=NULL;
	b->coda=prev;
}
		

	
	
		

void init_allegro(void) //inizializza allegro schermo=H x W
{
 allegro_init();
 set_color_depth(8);
 set_gfx_mode(GFX_AUTODETECT,W,H,W,H);
 install_keyboard();
 install_timer();
}

void esci()
{
	int n;
	clear_keybuf();
	readkey();
	destroy_serpe(&snake);
	for(n=0;n!=N_CPU;++n)
		destroy_serpe(&cpu[n]);	
	exit(EXIT_SUCCESS);
}

void set_parametri()
{
	PALETTE pal;
	BITMAP *cur=load_bitmap("cursore.bmp",pal);
	//set_palette(pal);
	N_CPU=0;
	install_mouse();
	show_mouse(screen);
	textprintf(screen,font,10,50,3, "SNAKE V.0.1b      di fabio colombo(fabiokolo@yahoo.it)");
	textprintf(screen,font,10,70,3, "cliccare sul nome dell'opzione per modificarla (sx aumenta,dx diminuisce)");
	textprintf(screen,font,10,90,3, "premere invio per continuare o esc per uscire");
	textprintf(screen,font,100,210,3, "NUMERO SERPENTI AVVERSARI (NIENTE SBORONATE):");
	textprintf(screen,font,100,230,3, "LIVELLO:");
	textprintf(screen,font,100,250,3, "VELOCITA':");
	textprintf(screen,font,100,270,3, "LATO SERPENTI (NON ESAGERARE)':");
	textprintf(screen,font,100,290,3, "COLORE MELA':");
	textprintf(screen,font,100,310,3, "COLORE TUO SERPENTE':");
	textprintf(screen,font,100,330,3, "COLORE SERPENTI AVVERSARI:");
	while(!key[KEY_ENTER])
	{
		blit(buffer,screen,500,200,500,200,300,600);
		clear(buffer);
		if(key[KEY_ESC])
			exit(0);
		textprintf(buffer,font,500,210,3, "%d",N_CPU);
		textprintf(buffer,font,500,230,3, "%s     ", HARD?"DIFFICILE":"FACILE    ");
	        textprintf(buffer,font,500,250,3, "%d",(550-TIME));
		rectfill(buffer,500,270,500+LATO,270+LATO,COLORE);
		rectfill(buffer,500,290,500+10,290+10,COLORE_MELA);
		rectfill(buffer,500,310,500+10,310+10,COLORE);
		rectfill(buffer,500,330,500+10,330+10,COLORE_B);
		rest(100);
		if(mouse_x>=100 && mouse_x<=200 && mouse_y>=290 && mouse_y<=298)
			if((mouse_b & 2) && (COLORE_MELA!=0))
				COLORE_MELA-=1;
			else if ((mouse_b & 1 ) && (COLORE_MELA!=255))
				++COLORE_MELA;
		if(mouse_x>=100 && mouse_x<=264 && mouse_y>=310 && mouse_y<=317)
			if((mouse_b & 2) && (COLORE!=0))
				COLORE-=1;
			else if ((mouse_b & 1 ) && (COLORE!=255))
				++COLORE;
		if(mouse_x>=100 && mouse_x<=305 && mouse_y>=330 && mouse_y<=338)
			if((mouse_b & 2) && (COLORE_B!=0))
				COLORE_B-=1;
			else if ((mouse_b & 1 ) && (COLORE_B!=255))
				++COLORE_B;				
		if(mouse_x>=100 && mouse_x<=176 && mouse_y>=250 && mouse_y<=258)
			if((mouse_b & 1) && (TIME!=50))
				TIME-=50;
			else if ((mouse_b & 2 ) && (TIME!=500))
				TIME+=50;
		if(mouse_x>=100 && mouse_x<=345 && mouse_y>=270 && mouse_y<=277)
			if((mouse_b & 1) && (LATO!=55))
				LATO+=10;
			else if ((mouse_b & 2 ) && (LATO!=5))
				LATO-=10;
		if(mouse_x>=100 && mouse_x<=457 && mouse_y>=210 && mouse_y<=218)
			if(mouse_b & 1)
				++N_CPU;
			else if ((mouse_b & 2 ) && N_CPU)
				--N_CPU;
		if(mouse_x>=100 && mouse_x<=160 && mouse_y>=230 && mouse_y<=238)
			if(mouse_b )
				HARD=HARD?0:1;
		
		
	}
	remove_mouse();
	set_palette(default_palette);
		

}
	
	
	

int main(int argc, char *argv[])
{
  int n;
  snake.cambi=NULL;
  init_allegro();
   buffer=create_bitmap(W,H);
  set_parametri();
  cpu=malloc(sizeof(struct blocco)*N_CPU);
  for(n=0;n!=N_CPU;++n)
  	cpu[n].cambi=NULL;
  
 
  crea_serpe(10);
  crea_mela();
  
  while(1)
  {
		short x=retrace_count;
		if(key[KEY_ESC])
			esci();
		draw_serpe(buffer);
		blit(buffer,screen,0,0,0,0,W,H);
		clear(buffer);
					
			
		
		if(!DEBUG)
			collision();
		muovi_serpe();
		ia();
		if((snake.corpo->dir==SU) || (snake.corpo->dir==GIU))
		{
			if(key[KEY_RIGHT])
				cambio_dir(DESTRA,&snake);
			else if(key[KEY_LEFT])
				cambio_dir(SINISTRA,&snake);
		}
		else
		{
			if(key[KEY_UP])
				cambio_dir(SU,&snake);
			else if(key[KEY_DOWN])
				cambio_dir(GIU,&snake);
		}
		ia();
		control_dir();

		rest(TIME);
   }
 allegro_exit();
}
END_OF_MAIN()








