#include "includes.h"

void text_object_logic(TEXT_OBJECT * op)
{
	if(op->active)
	{
		switch(op->type)
		{
			case TEXT_OBJECT_DISPLAY:
			{
				break;
			}
			case TEXT_OBJECT_FLYER:
			{
				if(op->time > 0)
				{
					op->time--;
				}
				else
				{
					if(op->ex < op->x)
					{
						op->x -= 2;
					}
					else if(op->ex > op->x)
					{
						op->x += 2;
					}
					if(op->ey < op->y)
					{
						op->y -= 2;
					}
					else if(op->ey > op->y)
					{
						op->y += 2;
					}
					else if(op->x == op->ex && op->y == op->ey)
					{
						op->active = 0;
						game.snake.score += op->val;
					}
				}
				break;
			}
		}
	}
}

void text_object_draw(BITMAP * bp, TEXT_OBJECT * op)
{
	if(op->active)
	{
		switch(op->type)
		{
			case TEXT_OBJECT_DISPLAY:
			case TEXT_OBJECT_FLYER:
			{
				if(op->shadow)
				{
					if(op->outline)
					{
						alfont_textout_centre(bp, op->font, op->text, op->x - 1 + 2, op->y + 2, makecol(0, 0, 0));
						alfont_textout_centre(bp, op->font, op->text, op->x + 1 + 2, op->y + 2, makecol(0, 0, 0));
						alfont_textout_centre(bp, op->font, op->text, op->x + 2, op->y - 1 + 2, makecol(0, 0, 0));
						alfont_textout_centre(bp, op->font, op->text, op->x + 2, op->y + 1 + 2, makecol(0, 0, 0));
					}
					else
					{
						alfont_textout_centre(bp, op->font, op->text, op->x + 2, op->y + 2, makecol(0, 0, 0));
					}
				}
				else
				{
					if(op->outline)
					{
						alfont_textout_centre(bp, op->font, op->text, op->x - 1, op->y, op->outline);
						alfont_textout_centre(bp, op->font, op->text, op->x + 1, op->y, op->outline);
						alfont_textout_centre(bp, op->font, op->text, op->x, op->y - 1, op->outline);
						alfont_textout_centre(bp, op->font, op->text, op->x, op->y + 1, op->outline);
					}
				}
				alfont_textout_centre(bp, op->font, op->text, op->x, op->y, op->color);
				break;
			}
		}
	}
}

void text_effect_object_logic(TEXT_EFFECT_OBJECT * op)
{
	if(op->active)
	{
		op->x += op->vx;
		op->y += op->vy;
		if(op->y >= itofix(SCREEN_H))
		{
			op->active = 0;
		}
		op->z += op->vz;
		op->vy += ftofix(0.5);
	}
}

void text_effect_object_draw(BITMAP * bp, TEXT_EFFECT_OBJECT * op)
{
	if(op->active)
	{
		draw_sprite_3d(bp, op->bp, fixtoi(op->x), fixtoi(op->y), fixtoi(op->z), SCREEN_W / 2, SCREEN_H - 16);
	}
}
