#ifndef SNAKE_H
#define SNAKE_H

#include "map.h"
#include "input.h"

#define SNAKE_MAX_SEGMENTS 256
#define MAX_SNAKES           4

typedef struct
{
	
	char letter;
	int x, y, nx, ny, px, py;
	int marked;
	
} SEGMENT;

typedef struct
{
	
	SEGMENT segment[SNAKE_MAX_SEGMENTS];
	char string[SNAKE_MAX_SEGMENTS + 1];
	int length;
	int score;
	int words;
	int delay, left, speed;
	CONTROLLER controller;

	char * word;
	int word_pos;
	
} SNAKE;

void snake_compile(SNAKE * sp);
//void snake_move(SNAKE * sp, MAP * mp);
void snake_draw(BITMAP * bp, SNAKE * sp, int ox, int oy);

#endif
