#include <allegro.h>
#include <alfont.h>
#include "ncds.h"
#include "data.h"
#include "menu.h"
#include "effects.h"

char gmenu_dtext[256] = {0};
char gmenu_mtext[256] = {0};
char gmenu_wtext[256] = {0};
char gmenu_mvtext[256] = {0};
char gmenu_svtext[256] = {0};
char gmenu_gptext[256] = {0};

void menu_proc_configure(void)
{
	ncds_play_sample(sound[SOUND_MENU_ENTER], 128, -1, -1);
	menu_state = MENU_STATE_CONFIG;
	config_init();
}

void menu_proc_scores(void)
{
	ncds_stop_music();
	ncds_play_sample(sound[SOUND_MENU_ENTER], 128, -1, -1);
	menu_state = MENU_STATE_TO_SCORES;
}

void menu_proc_play(void)
{
	menu_state = MENU_STATE_TO_GAME;
	ncds_stop_music();
	ncds_play_sample(sound[SOUND_MENU_ENTER], 128, -1, -1);
}

void menu_mode_text(void)
{
	strcpy(gmenu_mtext, score_title[game.mode]);
}

void menu_config_text(void)
{
	if(game.snake.controller.gamepad >= 0)
	{
		sprintf(gmenu_gptext, "%d", game.snake.controller.gamepad);
	}
	else
	{
		sprintf(gmenu_gptext, "Disabled");
	}
	sprintf(gmenu_mvtext, "%d%%", music_vol);
	sprintf(gmenu_svtext, "%d%%", sound_vol);
}

void menu_proc_gamepad_left(void)
{
	if(game.snake.controller.gamepad >= 0)
	{
		ncds_play_sample(sound[SOUND_MENU_OPTION], 128, -1, -1);
		game.snake.controller.gamepad--;
		menu_config_text();
	}
}

void menu_proc_gamepad_right(void)
{
	if(game.snake.controller.gamepad < num_joysticks - 1)
	{
		ncds_play_sample(sound[SOUND_MENU_OPTION], 128, -1, -1);
		game.snake.controller.gamepad++;
		menu_config_text();
	}
}

void menu_proc_mvol_left(void)
{
	if(music_vol > 0)
	{
		music_vol -= 5;
		ncds_set_music_volume(music_vol);
		if(music_vol <= 0)
		{
			ncds_disable_music();
			ncds_stop_music();
		}
		ncds_play_sample(sound[SOUND_MENU_OPTION], 128, -1, -1);
		menu_config_text();
	}
}

void menu_proc_mvol_right(void)
{
	if(music_vol < 100)
	{
		if(music_vol <= 0)
		{
			ncds_enable_music();
			ncds_play_music("soup.dat#music/title.xm", 1);
			logic_ticks = 0;
		}
		music_vol += 5;
		ncds_set_music_volume(music_vol);
		ncds_play_sample(sound[SOUND_MENU_OPTION], 128, -1, -1);
		menu_config_text();
	}
}

void menu_proc_svol_left(void)
{
	if(sound_vol > 0)
	{
		sound_vol -= 5;
		ncds_set_sound_volume(sound_vol);
		if(sound_vol <= 0)
		{
			ncds_disable_effects();;
		}
		ncds_play_sample(sound[SOUND_MENU_OPTION], 128, -1, -1);
		menu_config_text();
	}
}

void menu_proc_svol_right(void)
{
	if(sound_vol < 100)
	{
		if(sound_vol <= 0)
		{
			ncds_enable_effects();
		}
		sound_vol += 5;
		ncds_set_sound_volume(sound_vol);
		ncds_play_sample(sound[SOUND_MENU_OPTION], 128, -1, -1);
		menu_config_text();
	}
}

void menu_proc_mode_left(void)
{
	if(game.mode > 0)
	{
		ncds_play_sample(sound[SOUND_MENU_OPTION], 128, -1, -1);
		game.mode--;
		menu_mode_text();
	}
}

void menu_proc_mode_right(void)
{
	if(game.mode < game_modes - 1)
	{
		ncds_play_sample(sound[SOUND_MENU_OPTION], 128, -1, -1);
		game.mode++;
		menu_mode_text();
	}
}

void menu_difficulty_text(void)
{
	switch(game.difficulty)
	{
		case 0:
		{
			strcpy(gmenu_dtext, "Easy");
			break;
		}
		case 1:
		{
			strcpy(gmenu_dtext, "Medium");
			break;
		}
		case 2:
		{
			strcpy(gmenu_dtext, "Hard");
			break;
		}
	}
}

void menu_proc_difficulty_left(void)
{
	if(game.difficulty > 0)
	{
		ncds_play_sample(sound[SOUND_MENU_OPTION], 128, -1, -1);
		game.difficulty--;
		menu_difficulty_text();
	}
}

void menu_proc_difficulty_right(void)
{
	if(game.difficulty < 2)
	{
		ncds_play_sample(sound[SOUND_MENU_OPTION], 128, -1, -1);
		game.difficulty++;
		menu_difficulty_text();
	}
}

void menu_dictionary_text(void)
{
	strcpy(gmenu_wtext, get_filename(word_file[word_selected]));
}

void menu_proc_dictionary_left(void)
{
	if(word_selected > 0)
	{
		ncds_play_sample(sound[SOUND_MENU_OPTION], 128, -1, -1);
		word_selected--;
		dictionary_load(&dictionary[DICTIONARY_MAIN], word_file[word_selected]);
		menu_dictionary_text();
	}
}

void menu_proc_dictionary_right(void)
{
	if(word_selected < word_files - 1)
	{
		ncds_play_sample(sound[SOUND_MENU_OPTION], 128, -1, -1);
		word_selected++;
		dictionary_load(&dictionary[DICTIONARY_MAIN], word_file[word_selected]);
		menu_dictionary_text();
	}
}

void menu_proc_dictionary_enter(void)
{
	char fn[1024] = {0};
	char ofn[1024] = {0};
	
	ncds_pause_music();
	ncds_play_sample(sound[SOUND_MENU_ENTER], 128, -1, -1);
	set_mouse_sprite(NULL);
	if(file_select_ex("Import Dictionary", fn, "txt", 1024, 320, 240))
	{
		strcpy(ofn, fn);
		replace_extension(ofn, ofn, "asd", 1024);
		strcpy(ofn, get_filename(ofn));
		copy_file(fn, ofn);
		build_dictionary_list();
	}
	ncds_resume_music();
	logic_ticks = 0;
}

void config_init(void)
{
	memset(&menu, sizeof(GMENU), 0);
	
	/* set up menu */
	memset(&menu, sizeof(GMENU), 0);
	menu.item[0].type = MENU_ITEM_TYPE_TEXT;
	menu.item[0].data = "Configure";
	menu.item[0].ox = 0;
	menu.item[0].oy = 12;
	menu.item[0].font = gfont[FONT_MENU_HEADER];

	menu.item[1].type = MENU_ITEM_TYPE_BAR;
	menu.item[1].ox = 3;
	menu.item[1].oy = 36;
	
	menu.item[2].type = MENU_ITEM_TYPE_CHOICE;
	menu.item[2].data = "Gamepad";
	menu.item[2].ox = 0;
	menu.item[2].oy = 42;
	menu.item[2].left_proc = menu_proc_gamepad_left;
	menu.item[2].right_proc = menu_proc_gamepad_right;
	menu.item[2].font = gfont[FONT_MENU];

	menu.item[3].type = MENU_ITEM_TYPE_BAR;
	menu.item[3].ox = 1;
	menu.item[3].oy = 59;
	
	menu.item[4].type = MENU_ITEM_TYPE_TEXT;
	menu.item[4].data = gmenu_gptext;
	menu.item[4].ox = 0;
	menu.item[4].oy = 62;
	menu.item[4].font = gfont[FONT_MENU];

	menu.item[5].type = MENU_ITEM_TYPE_BAR;
	menu.item[5].ox = 2;
	menu.item[5].oy = 79;
	
	menu.item[6].type = MENU_ITEM_TYPE_CHOICE;
	menu.item[6].data = "Music Volume";
	menu.item[6].ox = 0;
	menu.item[6].oy = 83;
	menu.item[6].left_proc = menu_proc_mvol_left;
	menu.item[6].right_proc = menu_proc_mvol_right;
	menu.item[6].font = gfont[FONT_MENU];

	menu.item[7].type = MENU_ITEM_TYPE_BAR;
	menu.item[7].ox = 1;
	menu.item[7].oy = 100;
	
	menu.item[8].type = MENU_ITEM_TYPE_TEXT;
	menu.item[8].data = gmenu_mvtext;
	menu.item[8].ox = 0;
	menu.item[8].oy = 103;
	menu.item[8].font = gfont[FONT_MENU];

	menu.item[9].type = MENU_ITEM_TYPE_BAR;
	menu.item[9].ox = 2;
	menu.item[9].oy = 120;
	
	menu.item[10].type = MENU_ITEM_TYPE_CHOICE;
	menu.item[10].data = "Sound Volume";
	menu.item[10].ox = 0;
	menu.item[10].oy = 124;
	menu.item[10].left_proc = menu_proc_svol_left;
	menu.item[10].right_proc = menu_proc_svol_right;
	menu.item[10].font = gfont[FONT_MENU];

	menu.item[11].type = MENU_ITEM_TYPE_BAR;
	menu.item[11].ox = 1;
	menu.item[11].oy = 141;
	
	menu.item[12].type = MENU_ITEM_TYPE_TEXT;
	menu.item[12].data = gmenu_svtext;
	menu.item[12].ox = 0;
	menu.item[12].oy = 144;
	menu.item[12].font = gfont[FONT_MENU];
	menu_config_text();

	menu.items = 13;
	menu.selected = 2;
}

void menu_init(void)
{
	/* set up menu */
	memset(&menu, sizeof(GMENU), 0);
	menu.item[0].type = MENU_ITEM_TYPE_TEXT;
	menu.item[0].data = "Options";
	menu.item[0].ox = 0;
	menu.item[0].oy = 12;
	menu.item[0].font = gfont[FONT_MENU_HEADER];

	menu.item[1].type = MENU_ITEM_TYPE_BAR;
	menu.item[1].ox = 3;
	menu.item[1].oy = 36;
	
	menu.item[2].type = MENU_ITEM_TYPE_CHOICE;
	menu.item[2].data = "Game Mode";
	menu.item[2].ox = 0;
	menu.item[2].oy = 42;
	menu.item[2].left_proc = menu_proc_mode_left;
	menu.item[2].right_proc = menu_proc_mode_right;
	menu.item[2].font = gfont[FONT_MENU];

	menu.item[3].type = MENU_ITEM_TYPE_BAR;
	menu.item[3].ox = 1;
	menu.item[3].oy = 59;
	
	menu.item[4].type = MENU_ITEM_TYPE_TEXT;
	menu.item[4].data = gmenu_mtext;
	menu.item[4].ox = 0;
	menu.item[4].oy = 62;
	menu.item[4].font = gfont[FONT_MENU];
	menu_mode_text();

	menu.item[5].type = MENU_ITEM_TYPE_BAR;
	menu.item[5].ox = 2;
	menu.item[5].oy = 79;
	
	menu.item[6].type = MENU_ITEM_TYPE_CHOICE;
	menu.item[6].data = "Difficulty";
	menu.item[6].ox = 0;
	menu.item[6].oy = 83;
	menu.item[6].left_proc = menu_proc_difficulty_left;
	menu.item[6].right_proc = menu_proc_difficulty_right;
	menu.item[6].font = gfont[FONT_MENU];

	menu.item[7].type = MENU_ITEM_TYPE_BAR;
	menu.item[7].ox = 1;
	menu.item[7].oy = 100;
	
	menu.item[8].type = MENU_ITEM_TYPE_TEXT;
	menu.item[8].data = gmenu_dtext;
	menu.item[8].ox = 0;
	menu.item[8].oy = 103;
	menu.item[8].font = gfont[FONT_MENU];
	menu_difficulty_text();

	menu.item[9].type = MENU_ITEM_TYPE_BAR;
	menu.item[9].ox = 2;
	menu.item[9].oy = 120;
	
	menu.item[10].type = MENU_ITEM_TYPE_CHOICE;
	menu.item[10].data = "Dictionary";
	menu.item[10].ox = 0;
	menu.item[10].oy = 124;
	menu.item[10].enter_proc = menu_proc_dictionary_enter;
	menu.item[10].left_proc = menu_proc_dictionary_left;
	menu.item[10].right_proc = menu_proc_dictionary_right;
	menu.item[10].font = gfont[FONT_MENU];

	menu.item[11].type = MENU_ITEM_TYPE_BAR;
	menu.item[11].ox = 1;
	menu.item[11].oy = 141;
	
	menu.item[12].type = MENU_ITEM_TYPE_TEXT;
	menu.item[12].data = gmenu_wtext;
	menu.item[12].ox = 0;
	menu.item[12].oy = 144;
	menu.item[12].font = gfont[FONT_MENU];
	menu_dictionary_text();

	menu.item[13].type = MENU_ITEM_TYPE_BAR;
	menu.item[13].ox = 2;
	menu.item[13].oy = 161;
	
	menu.item[14].type = MENU_ITEM_TYPE_CHOICE;
	menu.item[14].data = "Configure";
	menu.item[14].ox = 0;
	menu.item[14].oy = 165;
	menu.item[14].enter_proc = menu_proc_configure;
	menu.item[14].font = gfont[FONT_MENU];

	menu.item[15].type = MENU_ITEM_TYPE_BAR;
	menu.item[15].ox = 1;
	menu.item[15].oy = 182;
	
	menu.item[16].type = MENU_ITEM_TYPE_CHOICE;
	menu.item[16].data = "View Scores";
	menu.item[16].ox = 0;
	menu.item[16].oy = 185;
	menu.item[16].enter_proc = menu_proc_scores;
	menu.item[16].font = gfont[FONT_MENU];

	menu.item[17].type = MENU_ITEM_TYPE_BAR;
	menu.item[17].ox = 1;
	menu.item[17].oy = 202;
	
	menu.item[18].type = MENU_ITEM_TYPE_CHOICE;
	menu.item[18].data = "Play";
	menu.item[18].ox = 0;
	menu.item[18].oy = 205;
	menu.item[18].font = gfont[FONT_MENU];
	menu.item[18].enter_proc = menu_proc_play;
	menu.selected = 18;

	menu.items = 19;
}

void gmenu_next_item(void)
{
	menu.selected++;
	if(menu.selected >= menu.items)
	{
		menu.selected = 0;
	}
}

void gmenu_prev_item(void)
{
	menu.selected--;
	if(menu.selected < 0)
	{
		menu.selected = menu.items - 1;
	}
}

void gmenu_next(void)
{
	gmenu_next_item();
	while(menu.item[menu.selected].type != MENU_ITEM_TYPE_CHOICE)
	{
		gmenu_next_item();
	}
}

void gmenu_prev(void)
{
	gmenu_prev_item();
	while(menu.item[menu.selected].type != MENU_ITEM_TYPE_CHOICE)
	{
		gmenu_prev_item();
	}
}

void menu_logic(void)
{
	int i;
	int f = frame;
	char k;
	
	if(keypressed())
	{
		k = readkey() >> 8;
	}
	else
	{
		k = 0;
	}
	switch(menu_state)
	{
		case MENU_STATE_TO_MENU:
		{
			can_y += 8;
			if(can_y >= CAN_START_Y)
			{
				menu_state = MENU_STATE_MAIN;
			}
			break;
		}
		case MENU_STATE_TO_OS:
		{
			can_y -= 8;
			if(can_y < -CAN_H - 8)
			{
				menu_state = MENU_STATE_CREDITS;
//				state = STATE_FIN;
			}
			break;
		}
		case MENU_STATE_MAIN:
		{
			if(k == KEY_ESC)
			{
				menu_state = MENU_STATE_TO_OS;
				ncds_play_sample(sound[SOUND_MENU_ENTER], 128, -1, -1);
			}
			if(k == KEY_ENTER)
			{
				menu_state = MENU_STATE_TO_OPTIONS;
				ncds_play_sample(sound[SOUND_MENU_ENTER], 128, -1, -1);
			}
			break;
		}
		case MENU_STATE_TO_OPTIONS:
		{
			can_ofs += 8;
			if(can_ofs - CAN_START_OFS >= image[IMAGE_SOUP_CAN]->w / 2)
			{
				menu_state = MENU_STATE_OPTIONS;
			}
			break;
		}
		case MENU_STATE_OPTIONS:
		{
			if(k == KEY_ESC)
			{
				menu_state = MENU_STATE_TO_MAIN;
				ncds_play_sample(sound[SOUND_MENU_ENTER], 128, -1, -1);
			}
			
			/* menu input */
			if(k == KEY_UP)
			{
				gmenu_prev();
				ncds_play_sample(sound[SOUND_MENU_MOVE], 128, -1, -1);
			}
			if(k == KEY_DOWN)
			{
				gmenu_next();
				ncds_play_sample(sound[SOUND_MENU_MOVE], 128, -1, -1);
			}
			if(k == KEY_LEFT && menu.item[menu.selected].left_proc)
			{
				menu.item[menu.selected].left_proc();
			}
			if(k == KEY_RIGHT && menu.item[menu.selected].right_proc)
			{
				menu.item[menu.selected].right_proc();
			}
			if(k == KEY_ENTER && menu.item[menu.selected].enter_proc)
			{
				menu.item[menu.selected].enter_proc();
			}
			break;
		}
		case MENU_STATE_CONFIG:
		{
			if(k == KEY_ESC)
			{
				menu_state = MENU_STATE_OPTIONS;
				ncds_play_sample(sound[SOUND_MENU_ENTER], 128, -1, -1);
				menu_init();
			}
			
			/* menu input */
			if(k == KEY_UP)
			{
				gmenu_prev();
				ncds_play_sample(sound[SOUND_MENU_MOVE], 128, -1, -1);
			}
			if(k == KEY_DOWN)
			{
				gmenu_next();
				ncds_play_sample(sound[SOUND_MENU_MOVE], 128, -1, -1);
			}
			if(k == KEY_LEFT && menu.item[menu.selected].left_proc)
			{
				menu.item[menu.selected].left_proc();
			}
			if(k == KEY_RIGHT && menu.item[menu.selected].right_proc)
			{
				menu.item[menu.selected].right_proc();
			}
			if(k == KEY_ENTER && menu.item[menu.selected].enter_proc)
			{
				menu.item[menu.selected].enter_proc();
			}
			break;
		}
		case MENU_STATE_TO_MAIN:
		{
			can_ofs -= 8;
			if(can_ofs - CAN_START_OFS <= 0)
			{
				menu_state = MENU_STATE_MAIN;
			}
			break;
		}
		case MENU_STATE_TO_GAME:
		{
			can_y += 8;
			if(can_y > 480)
			{
				game_start(&game);
				bowl_x = -image[IMAGE_GAME_BACKGROUND]->w - 8;
				bowl_y = 32;
				game_state = GAME_STATE_IN;
			}
			break;
		}
		case MENU_STATE_TO_SCORES:
		{
			can_y -= 8;
			if(can_y < -CAN_H - 8)
			{
				state = STATE_SCORES;
				score_state = SCORE_STATE_IN;
				scores_x = 0;
				scores_y = SCREEN_H;
				high_scores[score_view].lit = -1;
			}
			break;
		}
		case MENU_STATE_FROM_SCORES:
		{
			can_y += 8;
			if(can_y >= CAN_START_Y)
			{
				menu_state = MENU_STATE_OPTIONS;
			}
			break;
		}
		case MENU_STATE_CREDITS:
		{
			if(k || credits.y + credits.item[credits.items - 1].oy + 32 < 0)
			{
				state = STATE_FIN;
			}
			credits_logic(&credits);
		}
	}
	clear_keybuf();
}

void menu_render_can(void)
{
	int i;
	
	/* clear the surface */
	clear_to_color(image[IMAGE_MENU_SURFACE], image[IMAGE_MENU_SURFACE]->line[0][0]);
	rect(image[IMAGE_MENU_SURFACE], 50, 10, image[IMAGE_MENU_SURFACE]->w - 50 - 1, (menu.item[menu.items - 1].oy + 19) - 1, makecol(0, 0, 0));
	rect(image[IMAGE_MENU_SURFACE], 51, 10, image[IMAGE_MENU_SURFACE]->w - 51 - 1, (menu.item[menu.items - 1].oy + 19) - 1, makecol(0, 0, 0));
	
	for(i = 0; i < menu.items; i++)
	{
		switch(menu.item[i].type)
		{
			case MENU_ITEM_TYPE_CHOICE:
			{
				if(i == menu.selected)
				{
					alfont_textprintf_centre(image[IMAGE_MENU_SURFACE], menu.item[i].font, image[IMAGE_MENU_SURFACE]->w / 2, menu.item[i].oy, makecol(255, 0, 0), "%s", menu.item[i].data);
				}
				else
				{
					alfont_textprintf_centre(image[IMAGE_MENU_SURFACE], menu.item[i].font, image[IMAGE_MENU_SURFACE]->w / 2, menu.item[i].oy, makecol(0, 0, 0), "%s", menu.item[i].data);
				}
				break;
			}
			case MENU_ITEM_TYPE_TEXT:
			{
				alfont_textprintf_centre(image[IMAGE_MENU_SURFACE], menu.item[i].font, image[IMAGE_MENU_SURFACE]->w / 2, menu.item[i].oy, makecol(0, 0, 0), "%s", menu.item[i].data);
				break;
			}
			case MENU_ITEM_TYPE_BAR:
			{
				rectfill(image[IMAGE_MENU_SURFACE], 56, menu.item[i].oy, image[IMAGE_MENU_SURFACE]->w - 56 - 1, menu.item[i].oy + menu.item[i].ox, makecol(0, 0, 0));
				break;
			}
		}
	}
}

void menu_render(void)
{
	int i, j;
	
//	clear_to_color(buffer, makecol(0, 0, 128));
/*	for(i = 0; i < SCREEN_H / image[IMAGE_MENU_SHAPE_1]->h + 2; i++)
	{
		for(j = 0; j < SCREEN_W / image[IMAGE_MENU_SHAPE_1]->w + 2; j++)
		{
			draw_sprite(buffer, image[IMAGE_MENU_SHAPE_1 + j % 4], j * image[IMAGE_MENU_SHAPE_1]->w - bg_x % image[IMAGE_MENU_SHAPE_1]->w, i * image[IMAGE_MENU_SHAPE_1]->h - bg_y % image[IMAGE_MENU_SHAPE_1]->h);
		}
	} */
	blit(image[IMAGE_MENU_BG], buffer, 0, 0, 0, 0, buffer->w, buffer->h);
	menu_render_can();
	mapped_cylinder(buffer, can_x + CAN_R, can_y, CAN_R, CAN_H, image[IMAGE_SOUP_CAN], can_ofs);
	draw_shadow(buffer, can_x, can_y, CAN_R * 2, CAN_H, 8, 8);
	draw_trans_sprite(buffer, image[IMAGE_SOUP_SHADOW], can_x, can_y);
	
	if(menu_state == MENU_STATE_CREDITS)
	{
		credits_render(buffer, &credits);
	}
}

void menu_draw(void)
{
	blit(buffer, screen, 0, 0, 0, 0, 640, 480);
}

//int misc, lw_pl, lw_pos;

void scores_logic(void)
{
	int k;
	
	switch(score_state)
	{
		case SCORE_STATE_VIEW:
		{
			if(keypressed())
			{
				k = readkey() >> 8;
			}
			else
			{
				k = 0;
			}
			if(k == KEY_ESC)
			{
				score_state = SCORE_STATE_OUT;
			}
			if(k == KEY_LEFT && score_view > 0)
			{
				score_view--;
				high_scores[score_view].lit = -1;
				ncds_play_sample(sound[SOUND_PAPER], 128, -1, -1);
			}
			if(k == KEY_RIGHT && score_view < game_modes - 1)
			{
				score_view++;
				high_scores[score_view].lit = -1;
				ncds_play_sample(sound[SOUND_PAPER], 128, -1, -1);
			}
			break;
		}
		case SCORE_STATE_ENTER:
		{
			if(keypressed())
			{
				k = readkey() & 0xFF;
				switch(k)
				{
					/* enter */
					case 0xD:
					{
		            	high_scores[game.mode].place[score_place].name[score_pos] = '\0';
						high_scores[game.mode].lit = -1;
						score_state = SCORE_STATE_VIEW;
						game.snake.score = 0;
						key[KEY_ENTER] = 0;
						break;
					}
				
					/* escape */
					case 0x1B:
					{
						strcpy(high_scores[game.mode].place[score_place].name, "No Name");
						high_scores[game.mode].lit = -1;
						score_state = SCORE_STATE_VIEW;
						game.snake.score = 0;
						key[KEY_ESC] = 0;
						break;
					}	
				
					/* backspace */
					case 0x8:
					{
            			high_scores[game.mode].place[score_place].name[score_pos] = '\0';
       					if(score_pos > 0)
       					{	
	               			score_pos--;
           					high_scores[game.mode].place[score_place].name[score_pos] = '\0';
       					}
						break;
					}
				
					/* normal key */
					default:
					{
            			high_scores[game.mode].place[score_place].name[score_pos] = k;
       					score_pos++;
       					high_scores[game.mode].place[score_place].name[score_pos] = '\0';
						break;
					}
				}
			}
			break;
		}
		case SCORE_STATE_IN:
		{
			scores_y -= 8;
			if(scores_y <= 0)
			{
				score_state = SCORE_STATE_VIEW;
				clear_keybuf();
			}
			break;
		}
		case SCORE_STATE_ENTER_IN:
		{
			scores_y -= 8;
			if(scores_y <= 0)
			{
				clear_keybuf();
				score_state = SCORE_STATE_ENTER;
			}
			break;
		}
		case SCORE_STATE_OUT:
		{
			scores_y += 8;
			if(scores_y > SCREEN_H)
			{
				can_x = SCREEN_W / 2 - CAN_R;
				can_y = -CAN_H;
//				can_ofs = CAN_START_OFS;
				state = STATE_MENU;
				menu_state = MENU_STATE_FROM_SCORES;
				ncds_play_music("soup.dat#music/title.xm", 1);
				logic_ticks = 0;
			}
			break;
		}
	}
}

void scores_render(void)
{
	blit(image[IMAGE_MENU_BG], buffer, 0, 0, 0, 0, buffer->w, buffer->h);
	draw_sprite(buffer, image[IMAGE_PAPER], 0, scores_y);
	draw_shadow(buffer, 32, scores_y + 32, image[IMAGE_PAPER]->w - 64, image[IMAGE_PAPER]->h, 8, 8);
	alfont_textprintf_centre(buffer, gfont[FONT_GAME], SCREEN_W / 2, scores_y + 55, makecol(0, 0, 0), "%s", score_title[score_view]);
//	hs_render_ex(buffer, &high_scores[score_view], gfont[FONT_GAME], scores_x, scores_y, 160, 32, 31, 24, makecol(0, 0, 0));
	hs_render_ex(buffer, &high_scores[score_view], gfont[FONT_GAME], scores_x, scores_y + 22, 160, 32, makecol(0, 0, 0), makecol(192, 192, 192), -1);
}

void scores_draw(void)
{
	vsync();
	blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}
