#include "includes.h"

void map_auto_shuffle(MAP * mp, SNAKE * sp)
{
	int i, p;
	
	for(i = 0; i < MAX_LETTERS; i++)
	{
		if(mp->letter[i].active)
		{
			if(mp->letter[i].val == sp->word[sp->word_pos])
			{
				return;
			}
		}
	}
	
	/* if we get this far, shuffle */
	p = sp->word_pos;
	for(i = 0; i < MAX_LETTERS; i++)
	{
		if(mp->letter[i].active)
		{
			mp->letter[i].val = sp->word[p];
			p++;
			if(p >= strlen(sp->word))
			{
				p = 0;
			}
		}
	}
}

void map_update_blocked(MAP * mp, SNAKE * sp)
{
	int i, j;
	
	/* clear the map */
	for(i = 0; i < MAP_H; i++)
	{
		for(j = 0; j < MAP_W; j++)
		{
			mp->blocked[i][j] = 0;
		}
	}
	
	/* block off active letters */
	for(i = 0; i < MAX_LETTERS; i++)
	{
		if(mp->letter[i].active)
		{
			mp->blocked[mp->letter[i].y][mp->letter[i].x] = 1;
		}
	}
	
	/* block off snake segments */
	for(i = 0; i < sp->length; i++)
	{
		mp->blocked[sp->segment[i].y][sp->segment[i].x] = 1;
	}
	
	/* block off spaces immediately next to snake head */
	if(sp->segment[0].y > 0)
	{
		if(sp->segment[0].x > 0)
		{
			mp->blocked[sp->segment[0].y - 1][sp->segment[0].x - 1] = 1;
		}
		mp->blocked[sp->segment[0].y - 1][sp->segment[0].x] = 1;
		if(sp->segment[0].x < MAP_W - 1)
		{
			mp->blocked[sp->segment[0].y - 1][sp->segment[0].x + 1] = 1;
		}
	}
	if(sp->segment[0].x > 0)
	{
		mp->blocked[sp->segment[0].y][sp->segment[0].x - 1] = 1;
	}
	mp->blocked[sp->segment[0].y][sp->segment[0].x] = 1;
	if(sp->segment[0].x < MAP_W - 1)
	{
		mp->blocked[sp->segment[0].y][sp->segment[0].x + 1] = 1;
	}
	if(sp->segment[0].y < MAP_H - 1)
	{
		if(sp->segment[0].x > 0)
		{
			mp->blocked[sp->segment[0].y + 1][sp->segment[0].x - 1] = 1;
		}
		mp->blocked[sp->segment[0].y + 1][sp->segment[0].x] = 1;
		if(sp->segment[0].x < MAP_W - 1)
		{
			mp->blocked[sp->segment[0].y + 1][sp->segment[0].x + 1] = 1;
		}
	}
}

void map_letter_time(MAP * mp, int i)
{
	switch(game.level)
	{
		case 0:
		{
			mp->letter[i].time = 120 + (rand() % 5) * 60;
			break;
		}
		case 1:
		{
			mp->letter[i].time = 120 + (rand() % 4) * 60;
			break;
		}
		case 2:
		{
			mp->letter[i].time = 60 + (rand() % 4) * 60;
			break;
		}
	}
}

void map_new_letter(MAP * mp, int val, int x, int y)
{
	int i;
	
	for(i = 0; i < MAX_LETTERS; i++)
	{
		if(!mp->letter[i].active)
		{
			mp->letter[i].val = val;
			mp->letter[i].x = x;
			mp->letter[i].y = y;
			mp->letter[i].active = 1;
			mp->letter[i].f = 0;
			map_letter_time(mp, i);
			break;
		}
	}
}

void map_add_letter(MAP * mp, char letter)
{
	int loc;
	int val = rand() % 26;
	int i, j;
	int smap[MAP_H][MAP_W] = {0};
	
	/* find a place to put the letter */
	map_update_blocked(mp, &game.snake);
	mp->list_size = 0;
	for(i = 0; i < game.snake.length; i++)
	{
		smap[game.snake.segment[i].y][game.snake.segment[i].x] = 1;
	}
	for(i = 0; i < MAP_H; i++)
	{
		for(j = 0; j < MAP_W; j++)
		{
			if(!mp->blocked[i][j] && !smap[i][j])
			{
				mp->list[mp->list_size] = i * MAP_W + j;
				mp->list_size++;
			}
		}
	}
	
	/* generate the new letter */
	loc = rand() % mp->list_size;
	map_new_letter(mp, letter, mp->list[loc] % MAP_W, mp->list[loc] / MAP_W);
}

void map_re_letter(MAP * mp, char * wp)
{
	int i;
	
	for(i = 0; i < MAX_LETTERS; i++)
	{
		if(mp->letter[i].active)
		{
			mp->letter[i].val = wp[game.word_inc % strlen(wp)];
			game.word_inc++;
		}
	}
}

void map_clear(MAP * mp)
{
	int i, j;
	
	for(i = 0; i < MAX_LETTERS; i++)
	{
		mp->letter[i].active = 0;
	}
}

void map_logic(MAP * mp)
{
	int i;
	int x, y;
	int mx[4] = {0};
	int my[4] = {0};
	int moves = 0;
	int r;
	
	for(i = 0; i < MAX_LETTERS; i++)
	{
		
		/* animate */
		if(mp->letter[i].active)
		{
			mp->letter[i].f++;
		}
		
		/* see if letter is ready to move */
		if(mp->letter[i].time > 0 && game.mode != GAME_MODE_COLD)
		{
			mp->letter[i].time--;
			if(mp->letter[i].time <= 0)
			{
				
				/* update solid map */
				map_update_blocked(mp, &game.snake);
				x = mp->letter[i].x;
				y = mp->letter[i].y;
				moves = 0;
				
				/* is moving up possible? */
				if(y > 0)
				{
					if(!mp->blocked[y - 1][x])
					{
						mx[moves] = 0;
						my[moves] = -1;
						moves++;
					}
				}
				
				/* is moving down possible? */
				if(y < MAP_H - 1)
				{
					if(!mp->blocked[y + 1][x])
					{
						mx[moves] = 0;
						my[moves] = 1;
						moves++;
					}
				}

				/* is moving right possible? */
				if(x < MAP_W - 1)
				{
					if(!mp->blocked[y][x + 1])
					{
						mx[moves] = 1;
						my[moves] = 0;
						moves++;
					}
				}

				/* is moving left possible? */
				if(x > 0)
				{
					if(!mp->blocked[y][x - 1])
					{
						mx[moves] = -1;
						my[moves] = 0;
						moves++;
					}
				}
				if(moves)
				{
					r = rand() % moves;
					mp->letter[i].x += mx[r];
					mp->letter[i].y += my[r];
				}
				mp->letter[i].time = 120 + (rand() % 5) * 60;
			}
		}
	}
}

void map_draw(BITMAP * bp, MAP * mp, int ox, int oy)
{
	int i, j;
	char str[2] = {'\0', '\0'};
	
	for(i = 0; i < MAX_LETTERS; i++)
	{
		if(mp->letter[i].active)
		{
//			draw_sprite(bp, bg[1], mp->letter[i].x * 32, mp->letter[i].y * 32);
			str[0] = mp->letter[i].val;
			alfont_textout(bp, gfont[FONT_GAME], str, ox + mp->letter[i].x * 32 + 4, oy + mp->letter[i].y * 32 + 4, 200);
			draw_ani(bp, animation[ANIMATION_APPEAR_FG], ox + mp->letter[i].x * 32, oy + mp->letter[i].y * 32, mp->letter[i].f);
		}
	}
}
