#include <allegro.h>
#include <alfont.h>
#include <string.h>
#include "hs.h"

int hs_save_fp(HIGH_SCORES * hp, PACKFILE * fp)
{
	int i, j;
	
	for(i = 0; i < HS_MAX; i++)
	{
		for(j = 0; j < HS_NAME_MAX; j++)
		{
			pack_putc(hp->place[i].name[j], fp);
		}
		pack_iputl(hp->place[i].score, fp);
	}
	return 1;
}

int hs_save(HIGH_SCORES * hp, char * fn)
{
	PACKFILE * fp;
	
	fp = pack_fopen(fn, "w");
	if(!fp)
	{
		return 0;
	}
	hs_save_fp(hp, fp);
	pack_fclose(fp);
	return 1;
}

int hs_load_fp(HIGH_SCORES * hp, PACKFILE * fp)
{
	int i, j;
	
	for(i = 0; i < HS_MAX; i++)
	{
		for(j = 0; j < HS_NAME_MAX; j++)
		{
			hp->place[i].name[j] = pack_getc(fp);
		}
		hp->place[i].score = pack_igetl(fp);
	}
	return 1;
}

int hs_load(HIGH_SCORES * hp, char * fn)
{
	PACKFILE * fp;
	
	if(exists(fn))
	{
		fp = pack_fopen(fn, "r");
		if(!fp)
		{
			hs_default(hp);
			return 1;
		}
		hs_load_fp(hp, fp);
		pack_fclose(fp);
	}
	else
	{
		hs_default(hp);
	}
	return 1;
}

void hs_default(HIGH_SCORES * hp)
{
	int i;
	
	for(i = 0; i < HS_MAX; i++)
	{
		hp->place[i].score = 5000 - i * 500;
		strcpy(hp->place[i].name, "No Name");
	}
}

void hs_insert(HIGH_SCORES * hp, int pos, int score, char * name)
{
	int i;
	
	for(i = HS_MAX - 1; i > pos; i--)
	{
		hp->place[i].score = hp->place[i - 1].score;
		strcpy(hp->place[i].name, hp->place[i - 1].name);
	}
	hp->place[pos].score = score;
	strcpy(hp->place[pos].name, name);
}

int hs_place(HIGH_SCORES * hp, int score)
{
	int i;
	
	for(i = 0; i < 10; i ++)
	{
		if(score >= hp->place[i].score)
		{
			return i;
		}
	}
	return -1;
}

void hs_render(BITMAP * bp, HIGH_SCORES * hp, ALFONT_FONT * fp)
{
	int i, col;
	int end;
	char buffer[128];
	
	for(i = 0; i < HS_MAX; i++)
	{
		if(i == hp->lit || hp->lit < 0)
		{
			col = 31;
		}
		else
		{
			col = 24;
		}
		sprintf(buffer, "%d", hp->place[i].score);
		end = 640 - 160 - alfont_text_length(fp, buffer);
		alfont_textprintf(bp, fp, 160 + 2, i * 32 + 96 + 2, makecol(0, 0, 0), "%s", hp->place[i].name);
		alfont_textprintf(bp, fp, end + 2, i * 32 + 96 + 2, makecol(0, 0, 0), "%d", hp->place[i].score);
		alfont_textprintf(bp, fp, 160, i * 32 + 96, col, "%s", hp->place[i].name);
		alfont_textprintf(bp, fp, end, i * 32 + 96, col, "%d", hp->place[i].score);

	}
}

void hs_render_ex(BITMAP * bp, HIGH_SCORES * hp, ALFONT_FONT * fp, int ox, int oy, int margin, int vy, int lit, int unlit, int shad)
{
	int i, col;
	int end;
	char buffer[128];
	
	for(i = 0; i < HS_MAX; i++)
	{
		if(i == hp->lit || hp->lit < 0)
		{
			col = lit;
		}
		else
		{
			col = unlit;
		}
		sprintf(buffer, "%d", hp->place[i].score);
		end = bp->w - margin - alfont_text_length(fp, buffer);
		if(shad >= 0)
		{
			alfont_textprintf(bp, fp, ox + margin + 2, oy + i * vy + 96 + 2, shad, "%s", hp->place[i].name);
			alfont_textprintf(bp, fp, ox + end + 2, oy + i * vy + 96 + 2, shad, "%d", hp->place[i].score);
		}
		alfont_textprintf(bp, fp, ox + margin, oy + i * vy + 96, col, "%s", hp->place[i].name);
		alfont_textprintf(bp, fp, ox + end, oy + i * vy + 96, col, "%d", hp->place[i].score);

	}
}
