#ifndef GAME_H
#define GAME_H

#include "snake.h"
#include "map.h"
#include "dictionary.h"

#define GAME_STATE_IN          0
#define GAME_STATE_PLAY        1
#define GAME_STATE_OUT         2
#define GAME_STATE_DIE         3
#define GAME_STATE_QUIT        4
#define GAME_STATE_WIN         5

#define MAX_GAME_MODES         32
#define GAME_MODE_SCATTER_WORD  0
#define GAME_MODE_BLIND         1
#define GAME_MODE_ELIMINATION   2
#define GAME_MODE_POISON        3
#define GAME_MODE_FAT           4
#define GAME_MODE_SKINNY        5
#define GAME_MODE_COLD          6
#define GAME_MODE_NIBBLES       7

typedef struct
{
	
	MAP map;
	SNAKE snake;
	int mode;
	int difficulty;
	int level;
	int speed;
	int density;
	int word_min, word_max;
	int word_inc;
	int word_pos;
	
} GAME;

void game_add_letter(GAME * gp);
void game_pick_word(GAME * gp);
void game_start(GAME * gp);
void game_control(void);
void game_logic(GAME * gp);
void game_render(GAME * gp);
void game_draw(GAME * gp);

#endif
