#include "includes.h"

void game_set_level(GAME * gp)
{
	switch(gp->level)
	{
		case 0:
		{
			gp->word_min = 3 > dictionary[DICTIONARY_MAIN].word_max ? dictionary[DICTIONARY_MAIN].word_min : 3;
			gp->word_max = 5;
			gp->density = 10;
			break;
		}
		case 1:
		{
			gp->word_min = 3 > dictionary[DICTIONARY_MAIN].word_max ? dictionary[DICTIONARY_MAIN].word_min : 3;
			gp->word_max = 6;
			gp->density = 11;
			break;
		}
		case 2:
		{
			gp->word_min = 4 > dictionary[DICTIONARY_MAIN].word_max ? dictionary[DICTIONARY_MAIN].word_min : 4;
			gp->word_max = 7;
			gp->density = 12;
			break;
		}
		case 3:
		{
			gp->word_min = 4 > dictionary[DICTIONARY_MAIN].word_max ? dictionary[DICTIONARY_MAIN].word_min : 4;
			gp->word_max = 8;
			gp->density = 13;
			break;
		}
		case 4:
		{
			gp->word_min = 4 > dictionary[DICTIONARY_MAIN].word_max ? dictionary[DICTIONARY_MAIN].word_min : 4;
			gp->word_max = 9;
			gp->density = 14;
			break;
		}
		case 5:
		{
			gp->word_min = 4 > dictionary[DICTIONARY_MAIN].word_max ? dictionary[DICTIONARY_MAIN].word_min : 4;
			gp->word_max = 10;
			gp->density = 15;
			break;
		}
	}
}

void game_set_options(GAME * gp)
{
	switch(gp->difficulty)
	{
		
		/* easy */
		case 0:
		{
			gp->snake.delay = 20;
			break;
		}
		
		/* medium */
		case 1:
		{
			gp->snake.delay = 12;
			break;
		}
		
		/* hard */
		case 2:
		{
			gp->snake.delay = 8;
			break;
		}
	}
	gp->level = 0;
	game_set_level(gp);
}

void game_set_bowl(GAME * gp)
{
	int i;
	
	/* generate map */
	map_clear(&gp->map);
	switch(gp->mode)
	{
		case GAME_MODE_SCATTER_WORD:
		case GAME_MODE_BLIND:
		case GAME_MODE_ELIMINATION:
		case GAME_MODE_POISON:
		case GAME_MODE_FAT:
		case GAME_MODE_SKINNY:
		case GAME_MODE_COLD:
		{
			for(i = 0; i < gp->density; i++)
			{
				map_add_letter(&gp->map, gp->snake.word[gp->word_inc % strlen(gp->snake.word)]);
				gp->word_inc++;
			}
			map_auto_shuffle(&gp->map, &gp->snake);
			break;
		}
		case GAME_MODE_NIBBLES:
		{
			map_add_letter(&gp->map, gp->snake.word[gp->snake.word_pos]);
			break;
		}
	}
}

void game_add_letter(GAME * gp)
{
	switch(gp->mode)
	{
		case GAME_MODE_SCATTER_WORD:
		case GAME_MODE_BLIND:
		case GAME_MODE_ELIMINATION:
		case GAME_MODE_POISON:
		case GAME_MODE_FAT:
		case GAME_MODE_SKINNY:
		case GAME_MODE_COLD:
		{
			map_add_letter(&gp->map, gp->snake.word[gp->word_inc % strlen(gp->snake.word)]);
			gp->word_inc++;
			map_auto_shuffle(&gp->map, &gp->snake);
			break;
		}
		case GAME_MODE_NIBBLES:
		{
			map_add_letter(&gp->map, gp->snake.word[gp->snake.word_pos]);
			break;
		}
	}
}

void game_pick_word(GAME * gp)
{
	switch(gp->mode)
	{
		case GAME_MODE_SCATTER_WORD:
		case GAME_MODE_NIBBLES:
		case GAME_MODE_BLIND:
		case GAME_MODE_POISON:
		case GAME_MODE_FAT:
		case GAME_MODE_SKINNY:
		case GAME_MODE_COLD:
		{
			gp->snake.word = dictionary_rand_word(&dictionary[DICTIONARY_MAIN], gp->word_min, gp->word_max);
			gp->snake.word_pos = 0;
			gp->word_inc = 0;
			break;
		}
		case GAME_MODE_ELIMINATION:
		{
			gp->snake.word = dictionary_rand_word_take(&dictionary[DICTIONARY_MAIN], 0, 64);
			gp->snake.word_pos = 0;
			gp->word_inc = 0;
			break;
		}
	}
	gp->word_pos = SCREEN_H;
}

void game_start(GAME * gp)
{
	/* reload the dictionary */
	dictionary_load(&dictionary[DICTIONARY_MAIN], word_file[word_selected]);
	
	game_set_options(gp);
	
	/* set up player's snake */
	gp->snake.score = 0;
	gp->snake.words = 0;
	gp->snake.segment[0].letter = ' ';
	gp->snake.segment[0].x = 1;
	gp->snake.segment[0].y = 0;
	gp->snake.segment[0].px = 0;
	gp->snake.segment[0].py = 0;
	gp->snake.segment[0].nx = 2;
	gp->snake.segment[0].ny = 0;
	gp->snake.segment[1].letter = ' ';
	gp->snake.segment[1].x = 0;
	gp->snake.segment[1].y = 0;
	gp->snake.segment[1].px = 0;
	gp->snake.segment[1].py = 0;
	gp->snake.segment[1].nx = 1;
	gp->snake.segment[1].ny = 0;
	gp->snake.length = 2;
	gp->snake.left = gp->snake.delay;
	
//	gp->mode = mode;
	game_pick_word(gp);
	game_set_bowl(gp);

	state = STATE_GAME;
}

int game_advance(GAME * gp)
{
	int i, ol;
	int ret = 0;
	
	ol = gp->level;
	gp->level = gp->snake.words / 10;
	
	/* increase the density of the soup at level up */
	if(gp->level > ol)
	{
		switch(gp->mode)
		{
			case GAME_MODE_SCATTER_WORD:
			case GAME_MODE_BLIND:
			case GAME_MODE_POISON:
			case GAME_MODE_FAT:
			case GAME_MODE_SKINNY:
			case GAME_MODE_COLD:
			case GAME_MODE_ELIMINATION:
			{
				map_add_letter(&gp->map, gp->snake.word[rand() % gp->snake.word_pos]);
			}
			break;
		}
		ret = 1;
	}
	
	game_set_level(gp);
	return ret;
}

void game_control(void)
{
	if(key[KEY_ESC] && game_state == GAME_STATE_PLAY)
	{
		game_state = GAME_STATE_QUIT;
//		ncds_stop_music();
		clear_keybuf();
	}
}

void game_logic(GAME * gp)
{
	int i, ok = 1;
	
	for(i = 0; i < MAX_TEXT; i++)
	{
		text_object_logic(&text[i]);
	}
	for(i = 0; i < MAX_TEXT_EFFECT; i++)
	{
		text_effect_object_logic(&text_effect[i]);
	}
	switch(game_state)
	{
		case GAME_STATE_IN:
		{
			bowl_x += 8;
			if(bowl_x >= (SCREEN_W - image[IMAGE_GAME_BACKGROUND]->w) / 2)
			{
				main_render();
				main_draw();
				game_state = GAME_STATE_PLAY;
				ncds_play_music("soup.dat#music/bgm.xm", 1);
				logic_ticks = 0;
			}
			break;
		}
		case GAME_STATE_DIE:
		{
			map_logic(&gp->map);
			for(i = 0; i < MAX_TEXT; i++)
			{
				text_object_logic(&text[i]);
				if(text[i].active)
				{
					ok = 0;
					break;
				}
			}
			if(ok)
			{
				game_state = GAME_STATE_OUT;
				ncds_stop_music();
//				key[KEY_ENTER] = 0;
			}
			break;
		}
		case GAME_STATE_PLAY:
		{
			if(gp->word_pos > SCREEN_H - 32)
			{
				gp->word_pos -= 2;
			}
			map_logic(&gp->map);
			snake_move(&gp->snake, &gp->map);
			break;
		}
		case GAME_STATE_QUIT:
		{
			if(gp->word_pos > SCREEN_H - 32)
			{
				gp->word_pos -= 2;
			}
			map_logic(&gp->map);
			if(key[KEY_N])
			{
				game_state = GAME_STATE_PLAY;
				clear_keybuf();
			}
			else if(key[KEY_Y])
			{
				game_state = GAME_STATE_DIE;
				clear_keybuf();
			}
			break;
		}
		case GAME_STATE_WIN:
		{
			if(gp->word_pos > SCREEN_H - 32)
			{
				gp->word_pos -= 2;
			}
			map_logic(&gp->map);
			if(gtime > 0)
			{
				gtime--;
			}
			else
			{
				game_state = GAME_STATE_DIE;
			}
			if(wy > 0 || gtime < 40)
			{
				wy -= 8;
			}
			break;
		}
		case GAME_STATE_OUT:
		{
			bowl_x -= 8;
			if(bowl_x < -image[IMAGE_GAME_BACKGROUND]->w - 8)
			{
				main_render();
				main_draw();
				state = STATE_SCORES;
				scores_y = SCREEN_H;
				score_place = hs_place(&high_scores[game.mode], game.snake.score);
				if(score_place >= 0)
				{
					score_pos = 0;
					high_scores[game.mode].lit = score_place;
					hs_insert(&high_scores[game.mode], score_place, game.snake.score, "");
//					high_scores[game.mode].place[score_place].score = game.snake.score;
//					high_scores[game.mode].place[score_place].name[0] = 0;
					score_state = SCORE_STATE_ENTER_IN;
				}
				else
				{
					high_scores[game.mode].lit = -1;
					score_state = SCORE_STATE_IN;
				}
				score_view = game.mode;
				logic_ticks = 0;
			}
			break;
		}
	}
	frame++;
}

void game_text_outline(char * text, ALFONT_FONT * fp, int x, int y, int bg, int fg)
{
	alfont_textout(buffer, fp, text, x - 1, y, bg);
	alfont_textout(buffer, fp, text, x + 1, y, bg);
	alfont_textout(buffer, fp, text, x, y - 1, bg);
	alfont_textout(buffer, fp, text, x, y + 1, bg);
	alfont_textout(buffer, fp, text, x, y, fg);
}

void game_text_outline_center(char * text, ALFONT_FONT * fp, int x, int y, int bg, int fg)
{
	alfont_textout_centre(buffer, fp, text, x - 1, y, bg);
	alfont_textout_centre(buffer, fp, text, x + 1, y, bg);
	alfont_textout_centre(buffer, fp, text, x, y - 1, bg);
	alfont_textout_centre(buffer, fp, text, x, y + 1, bg);
	alfont_textout_centre(buffer, fp, text, x, y, fg);
}

void game_draw_word(GAME * gp, ALFONT_FONT * fp, int x, int y)
{
	char text[256] = {0};
	int i;
	int ofs, ofs2;
	
	strcpy(text, gp->snake.word);
	ofs = alfont_text_length(gfont[FONT_GAME], text);
//	game_text_outline_center(text, gfont[FONT_GAME], x, y, makecol(0, 0, 0), makecol(128, 128, 192));

	/* draw shadow */
	game_text_outline(text, gfont[FONT_GAME], x + 2 - ofs / 2, y + 2, makecol(0, 0, 0), makecol(0, 0, 0));
	
	/* show non-eaten letters */
	text[gp->snake.word_pos] = 0;
	ofs2 = alfont_text_length(gfont[FONT_GAME], text);
	strcpy(text, &gp->snake.word[gp->snake.word_pos]);
	text[strlen(gp->snake.word) - gp->snake.word_pos] = 0;
	game_text_outline(text, gfont[FONT_GAME], x + 2 - ofs / 2 + ofs2, y + 2, makecol(0, 0, 0), makecol(128, 128, 192));
	strcpy(text, gp->snake.word);
	
	/* show eaten letters */
	text[gp->snake.word_pos] = 0;
	game_text_outline(text, gfont[FONT_GAME], x - ofs / 2, y, makecol(0, 0, 0), makecol(192, 192, 256));
//	alfont_textout(buffer, gfont[FONT_GAME], text, x - ofs / 2, y, makecol(192, 192, 256));
}

void game_render(GAME * gp)
{
	char score[16] = {0};
	int i;
	
	/* render the backdrop */
	blit(image[IMAGE_MENU_BG], buffer, 0, 0, 0, 0, buffer->w, buffer->h);
	blit(image[IMAGE_GAME_BACKGROUND], buffer, 0, 0, bowl_x, (SCREEN_H - image[IMAGE_GAME_BACKGROUND]->h) / 2, buffer->w, buffer->h);
	draw_shadow(buffer, bowl_x, (SCREEN_H - image[IMAGE_GAME_BACKGROUND]->h) / 2, image[IMAGE_GAME_BACKGROUND]->w, image[IMAGE_GAME_BACKGROUND]->h, 8, 8);
	
	/* render the playing field */
	if(game_state == GAME_STATE_PLAY || game_state == GAME_STATE_DIE || game_state == GAME_STATE_IN || game_state == GAME_STATE_OUT || game_state == GAME_STATE_QUIT || game_state == GAME_STATE_WIN)
	{
		map_draw(buffer, &gp->map, bowl_x + 16, bowl_y + 16);
		snake_draw(buffer, &gp->snake, bowl_x + 16, bowl_y + 16);
	}
	if(game_state == GAME_STATE_PLAY || game_state == GAME_STATE_DIE || game_state == GAME_STATE_QUIT || game_state == GAME_STATE_WIN)
	{
		alfont_text_mode(-1);
		if(game.mode != GAME_MODE_BLIND)
		{
			game_draw_word(gp, gfont[FONT_GAME], SCREEN_W / 2, gp->word_pos);
		}
		sprintf(score, "%d", gp->snake.score);
		game_text_outline_center(score, gfont[FONT_GAME], SCREEN_W / 2 + 2, 2, makecol(0, 0, 0), makecol(0, 0, 0));
		game_text_outline_center(score, gfont[FONT_GAME], SCREEN_W / 2, 0, makecol(0, 0, 0), makecol(255, 255, 255));
		for(i = 0; i < MAX_TEXT; i++)
		{
			text_object_draw(buffer, &text[i]);
		}
		for(i = 0; i < MAX_TEXT_EFFECT; i++)
		{
			text_effect_object_draw(buffer, &text_effect[i]);
		}
	}
	if(game_state == GAME_STATE_QUIT)
	{
		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		rectfill(buffer, 0, 0, buffer->w - 1, buffer->h - 1, makecol(128, 128, 128));
		drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
		game_text_outline_center("Quit? (Y/N)", gfont[FONT_GAME_BIG], SCREEN_W / 2, 216, makecol(0, 0, 0), makecol(255, 255, 255));
	}
	if(game_state == GAME_STATE_WIN)
	{
//		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
//		rectfill(buffer, 0, 0, buffer->w - 1, buffer->h - 1, makecol(128, 128, 128));
//		drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
		game_text_outline_center("Congratulations!", gfont[FONT_GAME_BIG], SCREEN_W / 2, wy + 192, makecol(0, 0, 0), makecol(255, 255, 255));
		game_text_outline_center("You Win!", gfont[FONT_GAME_BIG], SCREEN_W / 2, wy + 240, makecol(0, 0, 0), makecol(255, 255, 255));
	}
}

void game_draw(GAME * gp)
{
	vsync();
	blit(buffer, screen, 0, 0, 0, 0, 640, 480);
}
