#ifndef DATA_H
#define DATA_H

#include <allegro.h>
#include <alfont.h>
#include "hs.h"
#include "animate.h"
#include "map.h"
#include "snake.h"
#include "dictionary.h"
#include "game.h"
#include "menu.h"
#include "text.h"
#include "credits.h"

#define MAX_WORD_FILES 64
#define MAX_SOUNDS     256
#define MAX_IMAGES     256
#define MAX_FONTS       16
#define MAX_ANIMATIONS  64
#define MAX_TEXT        64
#define MAX_TEXT_EFFECT 64


extern int can_x, can_y, can_ofs;
extern int menu_state;
extern int score_state;
extern int score_view;
extern char * score_title[MAX_GAME_MODES];
extern int game_modes;
extern char word_file[MAX_WORD_FILES][1024];
extern char word_files;
extern char word_selected;
extern int configure;
extern int gamepad;
extern int music_vol;
extern int sound_vol;
extern CREDITS credits;

extern int game_state;
extern int bowl_x, bowl_y;
extern int scores_x, scores_y;
extern int score_place;
extern int score_pos;
extern TEXT_OBJECT text[MAX_TEXT];
extern TEXT_EFFECT_OBJECT text_effect[MAX_TEXT_EFFECT];
extern int gtime;
extern int wy;

extern int level_words[20];
extern int level_min[20];
extern int level_max[20];

#define STATE_LOGO   0
#define STATE_MENU   1
#define STATE_GAME   2
#define STATE_FIN    3
#define STATE_SCORES 4

extern int state;
extern int logic_ticks;
extern int frame;

extern BITMAP * buffer;
//extern BITMAP * buffer_map;
extern PALETTE palette;

//extern MAP map;

//extern SNAKE snake[MAX_SNAKES];
extern GAME game;


#define CAN_R 120
#define CAN_H 360

#define MAX_DICTIONARIES 2
#define DICTIONARY_MAIN  0
#define DICTIONARY_PLAY  1

#define IMAGE_GAME_BACKGROUND 0
#define IMAGE_GAME_STATS      1
#define IMAGE_SOUP_CAN        2
#define IMAGE_SOUP_SHADOW     3
#define IMAGE_SOUP_LID        4
#define IMAGE_MENU_BG         5
#define IMAGE_MENU_SHAPE_1    6
#define IMAGE_MENU_SHAPE_2    7
#define IMAGE_MENU_SHAPE_3    8
#define IMAGE_MENU_SHAPE_4    9
#define IMAGE_MENU_SURFACE   10
#define IMAGE_PAPER          11
#define IMAGE_BODY_H         12
#define IMAGE_BODY_V         13
#define IMAGE_BODY_DUL       14
#define IMAGE_BODY_DUR       15
#define IMAGE_BODY_DDL       16
#define IMAGE_BODY_DDR       17
#define IMAGE_HEAD_UP        18
#define IMAGE_HEAD_DOWN      19
#define IMAGE_HEAD_LEFT      20
#define IMAGE_HEAD_RIGHT     21
#define IMAGE_TAIL_UP        22
#define IMAGE_TAIL_DOWN      23
#define IMAGE_TAIL_LEFT      24
#define IMAGE_TAIL_RIGHT     25

#define ANIMATION_APPEAR_BG  0
#define ANIMATION_APPEAR_FG  1
#define ANIMATION_SNAKE_HEAD 2
#define ANIMATION_SNAKE_BODY 3

#define SOUND_BITE            0
#define SOUND_MENU_MOVE       1
#define SOUND_MENU_ENTER      2
#define SOUND_MENU_OPTION     3
#define SOUND_WORD            4
#define SOUND_LEVEL           5
#define SOUND_PAPER           6
#define SOUND_CLAP            7

#define FONT_GAME             0
#define FONT_MENU_HEADER      1
#define FONT_MENU             2
#define FONT_GAME_BIG         3

extern DICTIONARY dictionary[MAX_DICTIONARIES];
extern SAMPLE * sound[MAX_SOUNDS];
extern BITMAP * image[MAX_IMAGES];
extern ALFONT_FONT * gfont[MAX_FONTS];
extern ANIMATION * animation[MAX_ANIMATIONS];
extern COLOR_MAP shadow_map;
extern GMENU menu;
extern GMENU config_menu;
extern HIGH_SCORES high_scores[MAX_GAME_MODES];

void build_dictionary_list(void);
int copy_file(char * f1, char * f2);
int config_load(char * fn);
int config_save(char * fn);
void data_load(void);
void data_free(void);

#endif
