#include <allegro.h>
#include <alfont.h>
#include "hs.h"
#include "animate.h"
#include "data.h"
#include "map.h"
#include "dictionary.h"
#include "game.h"
#include "effects.h"
#include "menu.h"
#include "text.h"
#include "credits.h"

/* main data */
int state = STATE_MENU;
int logic_ticks = 0;
int frame = 0;
char * mem_buffer = NULL;
int mem_buffer_size = 0;
int configure = 0;
int gamepad = 1;
int music_vol = 100;
int sound_vol = 50;

/* menu data */
int can_x, can_y, can_ofs;
int menu_state;
int score_state;
int score_view;
char * score_title[MAX_GAME_MODES] = {"Scatter Word", "Blind Worm", "Elimination", "Poison Letter", "Fat Worm", "Skinny Worm", "Cold Soup", "Nibbles"};
int game_modes = 8;
char word_file[MAX_WORD_FILES][1024] = {0};
char word_files = 0;
char word_selected = 0;
int gtime = 0;
int wy;
CREDITS credits;

/* game data */
int game_state;
int bowl_x, bowl_y;
int scores_x, scores_y;
int score_place;
int score_pos;
TEXT_OBJECT text[MAX_TEXT];
TEXT_EFFECT_OBJECT text_effect[MAX_TEXT_EFFECT];

BITMAP * buffer;
//BITMAP * buffer_map;
//BITMAP * character[256];
PALETTE palette;
SAMPLE * sound[MAX_SOUNDS] = {NULL};
BITMAP * image[MAX_IMAGES] = {NULL};
ALFONT_FONT * gfont[MAX_FONTS] = {NULL};
ANIMATION * animation[MAX_ANIMATIONS] = {NULL};
COLOR_MAP shadow_map;
GMENU menu;
GMENU config_menu;
HIGH_SCORES high_scores[MAX_GAME_MODES];

//MAP map;

//SNAKE snake[MAX_SNAKES];

DICTIONARY dictionary[MAX_DICTIONARIES];

GAME game;

void word_file_add(const char * fn, int attrib, int param)
{
	strcpy(word_file[word_files], fn);
	word_files++;
}

void build_dictionary_list(void)
{
	word_files = 0;
	word_file_add("soup.dat#dictionaries/default.asd", 0, 0);
	word_file_add("soup.dat#dictionaries/kids.asd", 0, 0);
	word_file_add("soup.dat#dictionaries/strange.asd", 0, 0);
	for_each_file("*.asd", FA_ARCH | FA_RDONLY, word_file_add, 0);
	dictionary_load(&dictionary[DICTIONARY_MAIN], word_file[word_selected]);
}

void load_mem_file(char * fn)
{
	PACKFILE * fp;
	int i;
	
	mem_buffer_size = file_size(fn);
	mem_buffer = malloc(mem_buffer_size);
	if(mem_buffer)
	{
		fp = pack_fopen(fn, "r");
		if(!fp)
		{
			free(mem_buffer);
			return;
		}
		for(i = 0; i < mem_buffer_size; i++)
		{
			mem_buffer[i] = pack_getc(fp);
		}
	}
}

void free_mem_file(void)
{
	if(mem_buffer)
	{
		free(mem_buffer);
	}
}

int copy_file(char * f1, char * f2)
{
	PACKFILE * fp1, * fp2;
	
	fp1 = pack_fopen(f1, "r");
	if(!fp1)
	{
		return 0;
	}
	fp2 = pack_fopen(f2, "w");
	if(!fp2)
	{
		pack_fclose(fp1);
		return 0;
	}
	while(!pack_feof(fp1))
	{
		pack_putc(pack_getc(fp1), fp2);
	}
	pack_fclose(fp1);
	pack_fclose(fp2);
	return 1;
}

int config_save(char * fn)
{
	PACKFILE * fp;
	
	fp = pack_fopen(fn, "w");
	if(!fp)
	{
		return 0;
	}
	pack_iputl(game.snake.controller.gamepad, fp);
	pack_iputl(music_vol, fp);
	pack_iputl(sound_vol, fp);
	pack_iputl(game.mode, fp);
	pack_iputl(game.difficulty, fp);
	pack_iputl(word_selected, fp);
	pack_fclose(fp);
	
	return 1;
}

int config_load(char * fn)
{
	PACKFILE * fp;
	
	fp = pack_fopen(fn, "r");
	if(!fp)
	{
		return 0;
	}
	game.snake.controller.gamepad = pack_igetl(fp);
	music_vol = pack_igetl(fp);
	ncds_set_music_volume(music_vol);
	sound_vol = pack_igetl(fp);
	ncds_set_sound_volume(sound_vol);
	game.mode = pack_igetl(fp);
	game.difficulty = pack_igetl(fp);
	word_selected = pack_igetl(fp);
	pack_fclose(fp);
	
	return 1;
}

void data_load(void)
{
	int i;
	
	/* load sounds */
	sound[SOUND_BITE] = load_wav("soup.dat#sounds/eat.wav");
	sound[SOUND_MENU_MOVE] = load_wav("soup.dat#sounds/navigate.wav");
	sound[SOUND_MENU_ENTER] = load_wav("soup.dat#sounds/select.wav");
	sound[SOUND_MENU_OPTION] = load_wav("soup.dat#sounds/option.wav");
	sound[SOUND_WORD] = load_wav("soup.dat#sounds/word.wav");
	sound[SOUND_LEVEL] = load_wav("soup.dat#sounds/level.wav");
	sound[SOUND_PAPER] = load_wav("soup.dat#sounds/paper.wav");
	sound[SOUND_CLAP] = load_wav("soup.dat#sounds/clap.wav");
	
	/* load images */
	image[IMAGE_GAME_BACKGROUND] = load_pcx("soup.dat#images/bowl.pcx", palette);
	image[IMAGE_MENU_BG] = load_pcx("soup.dat#images/background.pcx", NULL);
	image[IMAGE_SOUP_CAN] = load_pcx("soup.dat#images/can_texture.pcx", NULL);
	image[IMAGE_SOUP_SHADOW] = load_pcx("soup.dat#images/can_shadow.pcx", NULL);
	image[IMAGE_MENU_SURFACE] = create_sub_bitmap(image[IMAGE_SOUP_CAN], 0, 90, image[IMAGE_SOUP_CAN]->w / 2, image[IMAGE_SOUP_CAN]->h - 90 - 4);
	image[IMAGE_PAPER] = load_pcx("soup.dat#images/score_sheet.pcx", NULL);
	image[IMAGE_BODY_H] = load_pcx("soup.dat#snake/body_horizontal.pcx", NULL);
	image[IMAGE_BODY_V] = load_pcx("soup.dat#snake/body_vertical.pcx", NULL);
	image[IMAGE_BODY_DUL] = load_pcx("soup.dat#snake/body_up_left.pcx", NULL);
	image[IMAGE_BODY_DUR] = load_pcx("soup.dat#snake/body_up_right.pcx", NULL);
	image[IMAGE_BODY_DDL] = load_pcx("soup.dat#snake/body_down_left.pcx", NULL);
	image[IMAGE_BODY_DDR] = load_pcx("soup.dat#snake/body_down_right.pcx", NULL);
	image[IMAGE_HEAD_UP] = load_pcx("soup.dat#snake/head_up.pcx", NULL);
	image[IMAGE_HEAD_DOWN] = load_pcx("soup.dat#snake/head_down.pcx", NULL);
	image[IMAGE_HEAD_LEFT] = load_pcx("soup.dat#snake/head_left.pcx", NULL);
	image[IMAGE_HEAD_RIGHT] = load_pcx("soup.dat#snake/head_right.pcx", NULL);
	image[IMAGE_TAIL_UP] = load_pcx("soup.dat#snake/tail_up.pcx", NULL);
	image[IMAGE_TAIL_DOWN] = load_pcx("soup.dat#snake/tail_down.pcx", NULL);
	image[IMAGE_TAIL_LEFT] = load_pcx("soup.dat#snake/tail_left.pcx", NULL);
	image[IMAGE_TAIL_RIGHT] = load_pcx("soup.dat#snake/tail_right.pcx", NULL);
	
	set_palette(black_palette);
	gui_fg_color = 224;
	gui_mg_color = 228;
	gui_bg_color = 231;
	create_color_table(&shadow_map, palette, myblend, NULL);
//	set_multiply_blender(255, 255, 255, 127);
	color_map = &shadow_map;
	game.snake.controller.left_key = KEY_LEFT;
	game.snake.controller.right_key = KEY_RIGHT;
	game.snake.controller.up_key = KEY_UP;
	game.snake.controller.down_key = KEY_DOWN;
	game.snake.controller.fire_key = KEY_ENTER;
	game.snake.controller.rotate_key = KEY_SPACE;
	build_dictionary_list();
	
	/* load fonts */
	load_mem_file("soup.dat#fonts/game.ttf");
	gfont[FONT_GAME] = alfont_load_font_from_mem(mem_buffer, mem_buffer_size);
	alfont_set_font_size(gfont[FONT_GAME], 32);
	gfont[FONT_GAME_BIG] = alfont_load_font_from_mem(mem_buffer, mem_buffer_size);
	alfont_set_font_size(gfont[FONT_GAME_BIG], 48);
	free_mem_file();
	load_mem_file("soup.dat#fonts/menu.ttf");
	gfont[FONT_MENU_HEADER] = alfont_load_font_from_mem(mem_buffer, mem_buffer_size);
	alfont_set_font_size(gfont[FONT_MENU_HEADER], 24);
	gfont[FONT_MENU] = alfont_load_font_from_mem(mem_buffer, mem_buffer_size);
	alfont_set_font_size(gfont[FONT_MENU], 16);
	free_mem_file();
	
	/* load animations */
	animation[ANIMATION_APPEAR_FG] = load_ani("soup.dat#animations/letter_appear.ani", NULL);
	
	buffer = create_bitmap(640, 480);
//	buffer_map = create_sub_bitmap(buffer, (SCREEN_W - image[IMAGE_GAME_BACKGROUND]->w) / 2 + 16, (SCREEN_H - image[IMAGE_GAME_BACKGROUND]->h) / 2 + 16, MAP_W * 32, MAP_H * 32);
//	set_palette(black_palette);
	alfont_text_mode(-1);
	
	/* create text effect objects */
	for(i = 0; i < MAX_TEXT_EFFECT; i++)
	{
		text_effect[i].bp = create_bitmap(32, 32);
		clear_bitmap(text_effect[i].bp);
		text_effect[i].active = 0;
	}
	
	/* create credits list */
	select_palette(palette);
	credits.items = 0;
	credits.y = SCREEN_H;
	credits.vy = 1;
	
	credits_add_item(&credits, "Game Concept", gfont[FONT_GAME], 0, makecol(192, 192, 255));
	credits_add_item(&credits, "Todd Cope", gfont[FONT_GAME], 32, makecol(255, 255, 255));

	credits_add_item(&credits, "Game Design", gfont[FONT_GAME], 128, makecol(192, 192, 255));
	credits_add_item(&credits, "Todd Cope", gfont[FONT_GAME], 160, makecol(255, 255, 255));
	credits_add_item(&credits, "Brandy Cope", gfont[FONT_GAME], 192, makecol(255, 255, 255));
	
	credits_add_item(&credits, "Music", gfont[FONT_GAME], 288, makecol(192, 192, 255));
	credits_add_item(&credits, "Todd Cope", gfont[FONT_GAME], 320, makecol(255, 255, 255));
	credits_add_item(&credits, "Brandy Cope", gfont[FONT_GAME], 352, makecol(255, 255, 255));
	
	credits_add_item(&credits, "Sound", gfont[FONT_GAME], 448, makecol(192, 192, 255));
	credits_add_item(&credits, "Todd Cope", gfont[FONT_GAME], 480, makecol(255, 255, 255));
	credits_add_item(&credits, "www.partnersinrhyme.com", gfont[FONT_GAME], 512, makecol(255, 255, 255));
	
	credits_add_item(&credits, "Graphics", gfont[FONT_GAME], 608, makecol(192, 192, 255));
	credits_add_item(&credits, "Todd Cope", gfont[FONT_GAME], 640, makecol(255, 255, 255));

	credits_add_item(&credits, "Web Design", gfont[FONT_GAME], 736, makecol(192, 192, 255));
	credits_add_item(&credits, "DNI Web Design", gfont[FONT_GAME], 768, makecol(255, 255, 255));
	
	credits_add_item(&credits, "Support", gfont[FONT_GAME], 864, makecol(192, 192, 255));
	credits_add_item(&credits, "Brandy Cope", gfont[FONT_GAME], 896, makecol(255, 255, 255));
	credits_add_item(&credits, "Dawson Irvine", gfont[FONT_GAME], 928, makecol(255, 255, 255));
	
	credits_add_item(&credits, "Testing", gfont[FONT_GAME], 1024, makecol(192, 192, 255));
	credits_add_item(&credits, "Todd Cope", gfont[FONT_GAME], 1056, makecol(255, 255, 255));
	credits_add_item(&credits, "Brandy Cope", gfont[FONT_GAME], 1088, makecol(255, 255, 255));
	
	credits_add_item(&credits, "Additional Credits", gfont[FONT_GAME], 1184, makecol(192, 192, 255));
	credits_add_item(&credits, "Allegro Developers", gfont[FONT_GAME], 1216, makecol(255, 255, 255));
	credits_add_item(&credits, "Ben Davis (DUMB)", gfont[FONT_GAME], 1248, makecol(255, 255, 255));
	credits_add_item(&credits, "Javier Gonzalez (AlFont)", gfont[FONT_GAME], 1280, makecol(255, 255, 255));
	credits_add_item(&credits, "Matthew Leverton", gfont[FONT_GAME], 1312, makecol(255, 255, 255));
	credits_add_item(&credits, "SKALE Tracker Developers", gfont[FONT_GAME], 1344, makecol(255, 255, 255));
	credits_add_item(&credits, "GoldWave Inc.", gfont[FONT_GAME], 1376, makecol(255, 255, 255));
	credits_add_item(&credits, "Jasc Software", gfont[FONT_GAME], 1408, makecol(255, 255, 255));
	
	credits_add_item(&credits, "Alphabet Soup (c) 2004", gfont[FONT_GAME], 1888, makecol(255, 255, 255));
	credits_add_item(&credits, "NCD Games. All Rights Reserved.", gfont[FONT_GAME], 1920, makecol(255, 255, 255));
	
	select_palette(black_palette);
}

void data_free(void)
{
	int i;
	
	/* free the images */
	for(i = 0; i < MAX_IMAGES; i++)
	{
		if(image[i])
		{
			destroy_bitmap(image[i]);
		}
	}
	
	/* free the animations */
	for(i = 0; i < MAX_ANIMATIONS; i++)
	{
		if(animation[i])
		{
			destroy_ani(animation[i]);
		}
	}
	
	/* free the sounds */
	for(i = 0; i < MAX_SOUNDS; i++)
	{
		if(sound[i])
		{
			destroy_sample(sound[i]);
		}
	}
	
	/* free the fonts */
	for(i = 0; i < MAX_FONTS; i++)
	{
		if(gfont[i])
		{
			alfont_destroy_font(gfont[i]);
		}
	}
	
	destroy_bitmap(buffer);

	for(i = 0; i < MAX_TEXT_EFFECT; i++)
	{
		destroy_bitmap(text_effect[i].bp);
	}
//	save_score("scores");
}
