#include <allegro.h>

/* draws the starfield */
void draw_sprite_3d(BITMAP * bp, BITMAP * sprite, int x, int y, int z, int px, int py)
{
	float space_x, space_y;
	
	space_x = bp->w;
	space_y = bp->w;
	
	/* upper left and bottom right points in 3d */
	float obj_x[2], obj_y[2], obj_z[2];
	
	/* upper left and bottom right points in 2d */
	float screen_x[2], screen_y[2];
	int screen_w, screen_h;

	obj_x[0] = x - px;
	obj_x[0] *= space_x;
	obj_y[0] = y - py;
	obj_y[0] *= space_y;
	obj_x[1] = x + sprite->w - px;
	obj_x[1] *= space_x;
	obj_y[1] = y + sprite->h - py;
	obj_y[1] *= space_y;
	obj_z[0] = z + SCREEN_W;
	obj_z[1] = z + SCREEN_W;
	
	screen_x[0] = obj_x[0] / obj_z[0] + px;
	screen_x[1] = obj_x[1] / obj_z[0] + px;
	screen_y[0] = obj_y[0] / obj_z[1] + py;
	screen_y[1] = obj_y[1] / obj_z[1] + py;
	screen_w = screen_x[1] - screen_x[0];
	screen_h = screen_y[1] - screen_y[0];
	
	masked_stretch_blit(sprite, bp, 0, 0, sprite->w, sprite->h, screen_x[0], screen_y[0], screen_w, screen_h);
}
