#ifndef TEXT_H
#define TEXT_H

#include <alfont.h>

#define TEXT_OBJECT_DISPLAY 0
#define TEXT_OBJECT_FLYER   1

typedef struct
{
	
	/* text data */
	char text[256];
	ALFONT_FONT * font;
	int val;
	
	/* positioning */
	int x, y, ex, ey, active;
	
	/* colors */
	int color, outline, shadow;
	
	/* timing */
	int time;
	
	/* options */
	int type;
	
} TEXT_OBJECT;

typedef struct
{
	
	BITMAP * bp;
	fixed x, y, z;
	fixed vx, vy, vz;
	int active;
	
} TEXT_EFFECT_OBJECT;

void text_object_logic(TEXT_OBJECT * op);
void text_object_draw(BITMAP * bp, TEXT_OBJECT * op);
void text_effect_object_logic(TEXT_EFFECT_OBJECT * op);
void text_effect_object_draw(BITMAP * bp, TEXT_EFFECT_OBJECT * op);

#endif
