#include "includes.h"

void snake_delete(SNAKE * sp, int seg)
{
	int i;
	
	for(i = seg; i < sp->length - 1; i++)
	{
		sp->segment[i].letter = sp->segment[i + 1].letter;
	}
	sp->length--;
}

void snake_insert(SNAKE * sp, char val)
{
	int i;
	
	for(i = sp->length; i > 0; i--)
	{
		sp->segment[i].letter = sp->segment[i - 1].letter;
	}
	sp->segment[0].letter = val;
	if(sp->length < SNAKE_MAX_SEGMENTS - 1)
	{
		sp->length++;
	}
}

void snake_add(SNAKE * sp, char val)
{
	int i;
	
	sp->segment[sp->length].letter = val;
	if(sp->length < SNAKE_MAX_SEGMENTS - 1)
	{
		sp->length++;
	}
}

void snake_control(SNAKE * sp)
{
	int i, j;
	
	read_controller(&sp->controller);
	if(sp->segment[0].nx != sp->segment[0].x)
	{
		if(sp->controller.up == 1)
		{
			sp->segment[0].ny--;
			sp->segment[0].nx = sp->segment[0].x;
			sp->left = 1;
			key[sp->controller.up_key] = 0;
		}
		else if(sp->controller.down == 1)
		{
			sp->segment[0].ny++;
			sp->segment[0].nx = sp->segment[0].x;
			sp->left = 1;
			key[sp->controller.down_key] = 0;
		}
	}
	else if(sp->segment[0].ny != sp->segment[0].y)
	{
		if(sp->controller.left == 1)
		{
			sp->segment[0].nx--;
			sp->segment[0].ny = sp->segment[0].y;
			sp->left = 1;
			key[sp->controller.left_key] = 0;
		}
		else if(sp->controller.right == 1)
		{
			sp->segment[0].nx++;
			sp->segment[0].ny = sp->segment[0].y;
			sp->left = 1;
			key[sp->controller.right_key] = 0;
		}
	}
//	if(sp->controller.fire)
//	{
//		map_re_letter(&game.map, sp->word);
//	}
/*	if(sp->controller.rotate)
	{
		j = sp->segment[sp->length - 1].letter;
		for(i = sp->length - 1; i > 0; i--)
		{
			sp->segment[i].letter = sp->segment[i - 1].letter;
		}
		sp->segment[0].letter = j;
	} */
}

/* see if we run into ourself */
int snake_crunch(SNAKE * sp)
{
	int j;
	
	for(j = 0; j < sp->length - 1; j++)
	{
		if(j != 0 && sp->segment[0].x == sp->segment[j].x && sp->segment[0].y == sp->segment[j].y)
		{
			return 1;
		}
	}
	return 0;
}

void snake_move(SNAKE * sp, MAP * mp)
{
	int i, j, r;
	char tester[17] = {0};
	char snake_string[256] = {0};
	int points = 5;
	int count = 0;
	char c[2] = {0};
	int cx;
	
	snake_control(sp);
	
	/* see if it's time for snake to move */
	sp->left--;
	if(sp->left <= 0)
	{
		
		/* move the head */
		sp->segment[0].px = sp->segment[0].x;
		sp->segment[0].py = sp->segment[0].y;
		sp->segment[0].x = sp->segment[0].nx;
		sp->segment[0].y = sp->segment[0].ny;
		sp->segment[0].nx += sp->segment[0].x - sp->segment[0].px;
		sp->segment[0].ny += sp->segment[0].y - sp->segment[0].py;
		sp->segment[1].nx = sp->segment[0].px;
		sp->segment[1].ny = sp->segment[0].py;

		/* player dies */
		if(sp->segment[0].x < 0 || sp->segment[0].x >= MAP_W || sp->segment[0].y < 0 || sp->segment[0].y >= MAP_H || snake_crunch(sp))
		{
			sp->segment[0].x = sp->segment[0].px;
			sp->segment[0].y = sp->segment[0].py;
			game_state = GAME_STATE_DIE;
			return;
		}
		
		/* move the body */
		for(i = 1; i < sp->length; i++)
		{
			sp->segment[i].px = sp->segment[i].x;
			sp->segment[i].py = sp->segment[i].y;
			sp->segment[i].x = sp->segment[i].nx;
			sp->segment[i].y = sp->segment[i].ny;
			sp->segment[i].nx += sp->segment[i].x - sp->segment[i].px;
			sp->segment[i].ny += sp->segment[i].y - sp->segment[i].py;
			sp->segment[i + 1].nx = sp->segment[i].px;
			sp->segment[i + 1].ny = sp->segment[i].py;
		}
		
		/* player collects letter from playing field */
		for(i = 0; i < MAX_LETTERS; i++)
		{
			if(mp->letter[i].active)
			{
				if(mp->letter[i].x == sp->segment[0].x && mp->letter[i].y == sp->segment[0].y)
				{
					sp->segment[sp->length].x = sp->segment[sp->length - 1].px;
					sp->segment[sp->length].y = sp->segment[sp->length - 1].py;
					sp->segment[sp->length].nx = sp->segment[sp->length - 1].x;
					sp->segment[sp->length].ny = sp->segment[sp->length - 1].y;
			
					/* player collects correct letter */
					if(mp->letter[i].val == sp->word[sp->word_pos])
					{
						snake_add(sp, mp->letter[i].val);
						sp->word_pos++;
							
						/* player finishes word */
						if(sp->word_pos >= strlen(sp->word))
						{
							
							/* calculate starting point of text effect objects */
							cx = SCREEN_W / 2 - alfont_text_length(gfont[FONT_GAME], sp->word) / 2;
							
							/* create exploding text objects */
							for(j = 0; j < strlen(sp->word); j++)
							{
								c[0] = sp->word[j];
								clear_bitmap(text_effect[j].bp);
								alfont_textprintf(text_effect[j].bp, gfont[FONT_GAME], 1, 2, makecol(0, 0, 0), "%s", c);
								alfont_textprintf(text_effect[j].bp, gfont[FONT_GAME], 1, 0, makecol(0, 0, 0), "%s", c);
								alfont_textprintf(text_effect[j].bp, gfont[FONT_GAME], 2, 1, makecol(0, 0, 0), "%s", c);
								alfont_textprintf(text_effect[j].bp, gfont[FONT_GAME], 0, 1, makecol(0, 0, 0), "%s", c);
								alfont_textprintf(text_effect[j].bp, gfont[FONT_GAME], 1, 1, makecol(192, 192, 256), "%s", c);
								text_effect[j].x = itofix(cx - 1);
								text_effect[j].y = itofix(SCREEN_H - 32 - 1);
//								text_effect[j].y = 0;
								text_effect[j].z = itofix(0);
								text_effect[j].vx = itofix(0);
//								text_effect[j].vx = fdiv(itofix(rand() % 7 - 4), itofix(3));
								text_effect[j].vy = itofix(-1) - fdiv(itofix(rand() % 8), itofix(4));
								text_effect[j].vz = itofix(-30);
								text_effect[j].active = 1;
								cx += alfont_text_length(gfont[FONT_GAME], c);
							}
							
							if(game.mode != GAME_MODE_FAT)
							{
								sp->length -= strlen(sp->word);
							}
							for(j = 0; j < strlen(sp->word); j++)
							{
								points *= 2;
							}
//							sp->score += points;
							for(j = 0; j < MAX_TEXT; j++)
							{
								if(!text[j].active)
								{
									sprintf(text[j].text, "+%d", points);
									text[j].val = points;
									text[j].font = gfont[FONT_GAME];
									text[j].x = SCREEN_W / 2;
									text[j].y = 32;
									text[j].ex = SCREEN_W / 2;
									text[j].ey = 0;
									text[j].time = 60;
									text[j].color = makecol(255, 255, 255);
									text[j].shadow = 1;
									text[j].outline = makecol(0, 0, 0);
									text[j].type = TEXT_OBJECT_FLYER;
									text[j].active = 1;
									break;
								}
							}
							sp->words++;
							if(dictionary[DICTIONARY_MAIN].words > 0)
							{
								if(game_advance(&game))
								{
									ncds_play_sample(sound[SOUND_LEVEL], 128, -1, -1);
								}
								else
								{
									ncds_play_sample(sound[SOUND_WORD], 128, -1, -1);
								}
								game_pick_word(&game);
								map_re_letter(&game.map, sp->word);
								if(game.mode != GAME_MODE_FAT && game.mode != GAME_MODE_SKINNY)
								{
									snake_insert(sp, ' ');
								}
								game.word_pos = SCREEN_H;
							}
							else
							{
								game_state = GAME_STATE_WIN;
								gtime = 300;
								wy = 400;
								ncds_stop_music();
								ncds_play_sample(sound[SOUND_CLAP], 128, -1, -1);
							}
						}
					}
					else
					{
						if(game.mode == GAME_MODE_POISON)
						{
							game_state = GAME_STATE_DIE;
						}
						snake_insert(sp, ' ');
					}
					mp->letter[i].active = 0;

					/* delete the letter and add new letter to playing field */
					ncds_play_sample(sound[SOUND_BITE], 128, -1, -1);
					game_add_letter(&game);
					break;
				}
			}
			
		}
		sp->left = sp->delay;
	}
}

void snake_draw(BITMAP * bp, SNAKE * sp, int ox, int oy)
{
	int i;
	BITMAP * sbp;
	
	if(sp->segment[1].x > sp->segment[0].x)
	{
		sbp = image[IMAGE_HEAD_LEFT];
	}
	if(sp->segment[1].x < sp->segment[0].x)
	{
		sbp = image[IMAGE_HEAD_RIGHT];
	}
	if(sp->segment[1].y > sp->segment[0].y)
	{
		sbp = image[IMAGE_HEAD_UP];
	}
	if(sp->segment[1].y < sp->segment[0].y)
	{
		sbp = image[IMAGE_HEAD_DOWN];
	}
	draw_sprite(bp, sbp, ox + sp->segment[0].x * 32, oy + sp->segment[0].y * 32);
	for(i = 1; i < sp->length; i++)
	{
		if(i + 1 < sp->length)
		{
			if(sp->segment[i].x < sp->segment[i - 1].x && sp->segment[i].y < sp->segment[i + 1].y)
			{
				sbp = image[IMAGE_BODY_DUR];
			}
			else if(sp->segment[i].x < sp->segment[i - 1].x && sp->segment[i].y > sp->segment[i + 1].y)
			{
				sbp = image[IMAGE_BODY_DDR];
			}
			else if(sp->segment[i].x > sp->segment[i - 1].x && sp->segment[i].y < sp->segment[i + 1].y)
			{
				sbp = image[IMAGE_BODY_DUL];
			}
			else if(sp->segment[i].x > sp->segment[i - 1].x && sp->segment[i].y > sp->segment[i + 1].y)
			{
				sbp = image[IMAGE_BODY_DDL];
			}
			else if(sp->segment[i].x < sp->segment[i + 1].x && sp->segment[i].y < sp->segment[i - 1].y)
			{
				sbp = image[IMAGE_BODY_DUR];
			}
			else if(sp->segment[i].x < sp->segment[i + 1].x && sp->segment[i].y > sp->segment[i - 1].y)
			{
				sbp = image[IMAGE_BODY_DDR];
			}
			else if(sp->segment[i].x > sp->segment[i + 1].x && sp->segment[i].y < sp->segment[i - 1].y)
			{
				sbp = image[IMAGE_BODY_DUL];
			}
			else if(sp->segment[i].x > sp->segment[i + 1].x && sp->segment[i].y > sp->segment[i - 1].y)
			{
				sbp = image[IMAGE_BODY_DDL];
			}
			else
			{
				if(sp->segment[i].nx == sp->segment[i].x)
				{
					sbp = image[IMAGE_BODY_V];
				}
				else
				{
					sbp = image[IMAGE_BODY_H];
				}
			}
		}
		else
		{
			if(sp->segment[i].x > sp->segment[i - 1].x)
			{
				sbp = image[IMAGE_TAIL_LEFT];
			}
			else if(sp->segment[i].x < sp->segment[i - 1].x)
			{
				sbp = image[IMAGE_TAIL_RIGHT];
			}
			else if(sp->segment[i].y > sp->segment[i - 1].y)
			{
				sbp = image[IMAGE_TAIL_UP];
			}
			else
			{
				sbp = image[IMAGE_TAIL_DOWN];
			}
		}
		draw_sprite(bp, sbp, ox + sp->segment[i].x * 32, oy + sp->segment[i].y * 32);
	}
}
