#ifndef _MAP_H
#define _MAP_H

#include "dictionary.h"

#define MAP_W (12)
#define MAP_H (12)

#define MAX_LETTERS 26

typedef struct
{
	
	int x, y, f, active, time;
	int val;
	
} LETTER;

typedef struct
{
	
	/* tell which map positions are blocked */
	int blocked[MAP_H][MAP_W];
	
	/* letter tiles */
	LETTER letter[26];
	
	/* use these when placing a new letter tile */
	int list[MAP_H * MAP_W];
	int list_size;
	
} MAP;

//void map_auto_shuffle(MAP * mp, SNAKE * sp);
void map_new_letter(MAP * mp, int val, int x, int y);
void map_add_letter(MAP * mp, char letter);
void map_logic(MAP * mp);
void map_draw(BITMAP * bp, MAP * mp, int ox, int oy);

#endif
