#include "includes.h"

void logic_timer(void)
{
	logic_ticks++;
}

void main_init(void)
{
	allegro_init();
	ncds_install();
	ncds_set_music_volume(30);
	ncds_set_sound_volume(100);
	install_keyboard();
	install_mouse();
	install_timer();
	install_joystick(JOY_TYPE_AUTODETECT);
//	set_color_depth(16);
	set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);
	alfont_init();
	srand(time(0));
	data_load();
	logic_ticks = 0;
	install_int_ex(logic_timer, BPS_TO_TIMER(60));
}

void main_exit(void)
{
	data_free();
	alfont_exit();
	ncds_remove();
}

void main_logic(void)
{
	switch(state)
	{
		case STATE_GAME:
		{
			game_control();
			game_logic(&game);
			break;
		}
		case STATE_MENU:
		{
			menu_logic();
			break;
		}
		case STATE_SCORES:
		{
			scores_logic();
			break;
		}
	}
	if(key[KEY_F12])
	{
		save_pcx("screen.pcx", buffer, palette);
		key[KEY_F12] = 0;
	}
}

void main_render(void)
{
	switch(state)
	{
		case STATE_GAME:
		{
			game_render(&game);
			break;
		}
		case STATE_MENU:
		{
			menu_render();
			break;
		}
		case STATE_SCORES:
		{
			scores_render();
			break;
		}
	}
}

void main_draw(void)
{
	switch(state)
	{
		case STATE_GAME:
		{
			game_draw(&game);
			break;
		}
		case STATE_MENU:
		{
			menu_draw();
			break;
		}
		case STATE_SCORES:
		{
			scores_draw();
			break;
		}
	}
}

void load_scores(char * fn)
{
	int i;
	PACKFILE * fp;
	
	fp = pack_fopen(fn, "r");
	if(fp)
	{
		for(i = 0; i < MAX_GAME_MODES; i++)
		{
			hs_load_fp(&high_scores[i], fp);
		}
		pack_fclose(fp);
	}
	else
	{
		for(i = 0; i < MAX_GAME_MODES; i++)
		{
			hs_default(&high_scores[i]);
		}
	}
}

void save_scores(char * fn)
{
	int i;
	PACKFILE * fp;
	
	fp = pack_fopen(fn, "w");
	if(fp)
	{
		for(i = 0; i < MAX_GAME_MODES; i++)
		{
			hs_save_fp(&high_scores[i], fp);
		}
		pack_fclose(fp);
	}
}

void main_loop(void)
{
	int i;

	config_load("soup.cfg");
	load_scores("soup.hs");
	can_x = SCREEN_W / 2 - CAN_R;
	can_y = -CAN_H;
	can_ofs = CAN_START_OFS;
	menu_state = MENU_STATE_TO_MENU;
	menu_init();
	blit(image[IMAGE_MENU_BG], screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	fade_in(palette, 4);
	ncds_play_music("soup.dat#music/title.xm", 1);
	logic_ticks = 0;
	while(state != STATE_FIN)
	{
		for(i = 0; i < ((logic_ticks < 30) ? logic_ticks : 30); i++)
		{
			main_logic();
		}
		ncds_update_music();
		logic_ticks = 0;
		main_render();
		main_draw();
	}
	ncds_stop_music();
	config_save("soup.cfg");
	save_scores("soup.hs");
	fade_out(4);
}

int main(int argc, char * argv[])
{
	int i;
	
	if(argc > 1)
	{
		for(i = 1; i < argc; i++)
		{
			if(!stricmp(argv[i], "-config"))
			{
				configure = 1;
			}
		}
	}
	main_init();
	main_loop();
	main_exit();
	
	return 0;
}
END_OF_MAIN()
