#include <allegro.h>
#include "effects.h"

 
void draw_shadow(BITMAP * bp, int x, int y, int w, int h, int ox, int oy)
{
	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	rectfill(bp, x + ox, y + h, x + ox + w, y + h + oy, makecol(128, 128, 128));
	rectfill(bp, x + w, y + oy, x + w + ox, y + h, makecol(128, 128, 128));
	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
}

void myblend(PALETTE pal, int x, int y, RGB *rgb)
{
	int light;
	
	light = (pal[x].r + pal[x].g + pal[x].b) / 3;
	rgb->r = fixtoi(fmul(itofix(pal[y].r), fdiv(itofix(light), itofix(63))));
	rgb->g = fixtoi(fmul(itofix(pal[y].g), fdiv(itofix(light), itofix(63))));
	rgb->b = fixtoi(fmul(itofix(pal[y].b), fdiv(itofix(light), itofix(63))));
//	rgb->g = pal[x].g - (63 - light);
//	rgb->b = pal[x].b - (63 - light);
}

/*
     mapped_cylinder() maps a bitmap onto a cylinder.
     
     BITMAP *target = bitmap to display
     int cx = horizontal position of the center of the cylinder
     int top = position of the top of the cylinder
     int r = radius of the cylinder
     int h = height of the cylinder
     BITMAP *map = the thing that is going to be mapped onto the cylinder
 */
void mapped_cylinder(BITMAP * target, int cx, int top, int r, int h, BITMAP * map, int ofs)
{     
	int x, y; // coordinates on the target bitmap 
//	int p, q; // coordinates on the source bitmap
	fixed p, q; // coordinates on the source bitmap
	fixed cy, oy;
	int iy;
     
     // for each line:
	// for each pixel in the line:
	oy = fdiv(itofix(map->h), itofix(h));
	for (x = - r; x < r; x++)
	{
		fixed temp; // a temporary variable we use for calculating p
         
		// right now, x is between -r and r.
		// x must be between 1 and -1 before we can use asin
		// so therefor we divide by r
		temp = itofix(x) / r; 
         
		// now we can use the asin() function
		temp = fixasin (temp);
		// the result is an angle between -64 and 64.         
         
		// the next expression changes that to angle between 0..64 and 192..255,
		// which is equivalent, because 192 == -64,
		// but postive integers are a bit easier to deal with
		temp &= 0xFFFFFF;
         
		// the actual p has to cover the whole bitmap 
		// so we go from 0..256 to 0..bmp->w
//			p = fixtoi (temp) * (map->w-1) / 256;
//		p = fmul(temp, fdiv(itofix(map->w-1), itofix(256)));
		p = fmul(temp, itofix(map->w-1) >> 8);
         
//		cy = itofix(0);
		iy = top >= 0 ? 0 : -top;
		cy = iy * oy;
		// now we know p and q. copy a pixel.
		for(y = iy; y < h && top + y < target->h; y++)
		{
//			q = y * fdiv(itofix(map->h), itofix(h));
			//q is the same throughout this line. we can calculate it already
			//y has a range from 0..h, and we have to change that into a
			//range from 0..map->h
			//so we use this expression:
//			q = fmul(itofix(y), fdiv(itofix(map->h), itofix(h)));
//			cy += oy;
         
//			putpixel(target, x + cx, top + y, get_pixel_wrap(map, fixtoi(p) + ofs, fixtoi(cy)));
//			putpixel(target, x + cx, top + y, get_pixel_wrap(map, fixtoi(p) + ofs, fixtoi(cy)));
			target->line[top + y][x + cx] = get_pixel_wrap(map, fixtoi(p) + ofs, fixtoi(cy));
			cy += oy;
		}
	}
}
 
/* like getpixel() but allows wrapping */
int get_pixel_wrap(BITMAP * bp, int x, int y)
{
//	return getpixel(bp, x % bp->w, y % bp->h);
//	return getpixel(bp, x % bp->w, y % bp->h);
	return bp->line[y % bp->h][x % bp->w];
}
