/* Author: Tobi Vollebregt */

/*  TankZone: My second Allegro game.
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

#include "tankzone.h"

char *jgmod_song_name=NULL;

#ifdef USE_JGMOD

static int number,ind=0,ind0=-1,mod_is_nice=0;
static JGMOD *mod=NULL;

void init_mod_player(void)
{
    number=get_config_int("jgmods","number",0);
    if(number) ind=random()%number;
    else use_jgmod=FALSE;
}

void update_mod_player(void)
{
    //static JGMOD_INFO ji;
    char buf[8];
    const char *filename;

    if(!is_mod_playing())
    {   ind0=ind;
    do
    {   if(mod) destroy_mod(mod);
        mod=NULL;
        if(++ind>=number) ind=0;
        sprintf(buf,"song%03d",ind);
        filename=get_config_string("jgmods",buf,"");
    }while(ind0!=ind && (!filename[0] || !(mod=load_mod((char *)filename))));
    if(mod)
    {   //get_mod_info(filename,&ji);
        jgmod_song_name=get_filename(filename);//ji.name;
        mod_is_nice=0;
        play_mod(mod,FALSE);
    }
    }
    /*if(key[KEY_MOD_BETTER_THAN_PREVIOUS] && ind>0)
    {   char buf1[512],buf2[512];
    sprintf(buf,"song%03d",ind);
    strcpy(buf1,get_config_string("jgmods",buf,""));
    sprintf(buf,"song%03d",ind0);
    strcpy(buf2,get_config_string("jgmods",buf,""));
    sprintf(buf,"song%03d",ind);
    set_config_string("jgmods",buf,buf2);
    sprintf(buf,"song%03d",ind0);
    set_config_string("jgmods",buf,buf1);
    }
    if(key[KEY_MOD_NICE] && !mod_is_nice)
    {   set_config_int("jgmods",jgmod_song_name,get_config_int("jgmods",jgmod_song_name,0)+1);
    mod_is_nice=-1;
    }*/
}

void exit_mod_player(void)
{
    stop_mod();
    if(mod) destroy_mod(mod);
    mod=NULL;
}

#else

void init_mod_player(void) {}
void exit_mod_player(void) {}
void update_mod_player(void) {}

#endif
