/* Author: Tobi Vollebregt */

/*  TankZone: My second Allegro game.
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

#ifndef __tjv_TANKZONE_H__
#define __tjv_TANKZONE_H__

#include <allegro.h>
#include <allegro/internal/aintern.h>
#ifdef USE_JGMOD
 #include <jgmod.h>
#endif
#include <math.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "samples.h"

#ifndef ALLEGRO_DJGPP
 #define random() rand()
 #define srandom(x) srand(x)
#else
 #define rand() random()
 #define srand(x) srandom(x)
#endif

#ifndef PI
 #define PI 3.14159265358979323846
#endif

#define MEMERR  exitmsg("Damn, not enough memory.\n");
#define _putpixel8(bmp,x,y,c)   _putpixel(bmp,x,y,c)
#define _getpixel8(bmp,x,y)     _getpixel(bmp,x,y)
#define FIXED_ONE               0x10000
#define distance(x1,y1,x2,y2)   sqrt(((x2)-(x1))*((x2)-(x1))+((y2)-(y1))*((y2)-(y1)))
#define RND(x) (random() % ((x)+1))
#define SWAP(a,b)   {temp=a; a=b; b=temp;}

//#define GETSQUARE(x,y) ({int square=getpixel(map,x,y); square<2?tnk[square].vakje:square;})
//#define GETPLAYER(x,y) ({int index=getpixel(map,x,y); index<2?index:-1;})
//#define GETCANNON(x,y) ({int index=getpixel(turretmap,x,y); index-1;})
//#define GETLIGHT(x,y) (getpixel(lightmap,x,y);}

/* tiles */
#define TILE_SIZE 32
#define TILE_NUM        106
#define TILE_NUM_CLASSIC   25
#define TILE_TANK0      0   /* red tank */
#define TILE_TANK1      1   /* blue tank */
#define TILE_TANK(x)    (x) /* a tank */
#define TILE_GRASS      2   /* grass */
#define TILE_DGRASS1    3   /* dirty grass 1 */
#define TILE_DGRASS2    4   /* dirty grass 2 */
#define TILE_DESERTEDGE 5   /* edge of the desert */
#define TILE_DESERT     6   /* desert */
#define TILE_DDESERT1   7   /* dirty desert 1 */
#define TILE_DDESERT2   8   /* dirty desert 2 */
#define TILE_SHORE      9   /* shore */
#define TILE_WATER      10  /* water */
#define TILE_WALL       11  /* a wall */
#define TILE_TURRET     12  /* a turret */
#define TILE_DTURRET    13  /* a destroyed turret */
#define TILE_ROCK       14  /* a rock */
#define TILE_SEAPORTL   15  /* left tile of a seaport */
#define TILE_SEAPORTR   16  /* right tile of a seaport */
#define TILE_SEAPORTB   17  /* building on a seaport */
#define TILE_ROADH      18  /* horizontal road */
#define TILE_ROADV      19  /* vertical road */
#define TILE_CROSSROADS 20  /* crossroads */
#define TILE_WOODV      21  /* vertical wood */
#define TILE_DWOODV     22  /* dirty vertical wood */
#define TILE_WOODH      23  /* horizontal wood */
#define TILE_DWOODH     24  /* dirty horizontal wood */

typedef signed char bool;
typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned long u_long;
typedef void (*FUNCPTR)(void);

typedef struct LIGHT_TREE
{   int color;
        bool used;
        BITMAP *tile;
        struct LIGHT_TREE *left, *right;
} LIGHT_TREE;

#define MESSAGECOUNT    16

typedef struct
{   char *msg[MESSAGECOUNT];
        int count;
        int l, t, r, b;         /* Left, Top, Right, Bottom */
} VIEWPORT;

typedef struct {
        int index;
        int x,y,dist;
} CPU_BLACK_NODE;

typedef struct
{ float
          x, y, xs, ys,     //Xposition, Yposition, XSpeed, YSpeed
          startx,starty,    // Start position
          loopang, tankang, //ANGle van de LOOP, ANGle van de TANK
        target_x, target_y; // x van targetje, y idem
  int
          strength,         //STRENGTH van de tank
          len,              //LENgte van loop
          pos[8],           //x en y POSities van de hoekpunten van de tanks
          loopx, loopy,     //X van het einde van LOOP, Y van LOOP
          polycolor,        //COLOR van het tank-POLYgon
          circcolor,        //COLOR van de tank-CIRCle
          speed,            //SPEED van de tank
          com_time;         // 0 als is cpu tank
  bool used,            //bestaat de tank nog?
          light_key,        //was light toets frame hiervoor nog ingedrukt?
          light,            //is licht aan?
          mouse_scrolling,  // kan deze tank muis-gegevens opvragen om te scrollen
          auto_shoot,       // moet er nu automatisch geschoten worden?
          klem;             // zit ie klem tussen twee vakjes
  unsigned char 
          target_prev,      // vorig frame bij target
          vakje;            //onderliggend VAKJE bij tank
  unsigned char input_flags; // flags voor input tank
  // volgende eigenschappen allemaal voor de score
  int kills,            // kills
          captures,         // aantal ingepikte turrets
          killed,           // aantal gedode turrets van deze tank
          damage,           // schade toegebracht
          mydamage,         // schade gekregen
          deads;            // aantal ker dood gegaan
        // voor cpu tanks:
        int cpu_state;
        BITMAP *cpu_map,*cpu_covering_map;
        CPU_BLACK_NODE cpu_black_list[20];
        int cpu_black_list_size;
        int cpu_repairing;
        int cpu_squarex,cpu_squarey;
        int cpu_killmode;
} PLAYERTANK;

typedef struct
{ int
          x, y, color,
          loopx, loopy,
          start, stop,
          len, strength,
          kid,      // index child turret
          build; // voor hoeveel procent is turret gebouwd?
  bool disp, used,everattacked;
  unsigned char attacked, vakje; // vakje=vakje onder turret als hij gebouwd wordt
  float angle,sangle;
  int age;  // leeftijd
} TURRET;

typedef struct CANNONBALL
{ float
          x, y, xs, ys;     //Xposition, Yposition, XSpeed, YSpeed
  bool used;            //is hij USED
  int time;             //hoe lang hij nog vliegt
  short team;           //door welke partij afgevuurd
  int num;              //welk lid van die partij
} CANNONBALL;

typedef struct
{ float
          x, y, xs, ys;     //Xposition, Yposition, XSpeed, YSpeed
  int state,            // which explode bitmap is currently visible
          a;                // alpha level of bitmap
  bool sizzle, used;
  short team;           //welke partij heeft deze explosion veroorzaakt
  int num;              //welke unit uit die partij
} EXPLOSION;

typedef struct
{ int
          x, y,sx,sy;             //Xposition, Yposition,start positie
  short
          rad,              //huidige RADius, 
          maxrad, a,        //MAXimum RADius, Alpha-value
          growspeed;        //GROWSPEED
  int color;            //COLOR van de smoke
  bool used;             //is hij USED
} SMOKE;

typedef struct
{ int
          x, y,
          color;
  bool used;
  int growspeed, rad, a;
} PLONS;

typedef struct
{ int x, y;
  int state;
  bool used;
} FIRE;

/* from blend.c: */
void set_max_blender(int r,int g,int b,int a);
void set_min_blender(int r,int g,int b,int a);
void set_mul_blender(int r,int g,int b,int a);
unsigned long mul_blender(unsigned long x,unsigned long y);
void set_mul2_blender(int r,int g,int b,int a);
void set_dis_blender(int r, int g,int b,int a);
void set_dis_seed(int seed);

/* from flame.c: */
int generate_flame(BITMAP *anim[],int frames,int w,int h,int s,int hotspots,int hot,void (*callback)(int));

/* from intro.c: */
int intro(BITMAP *dbuffer, BITMAP *dbuffer2);

/* from jgmod.c: */
//#define KEY_MOD_BETTER_THAN_PREVIOUS    KEY_F11
#define KEY_MOD_NICE                    KEY_F9
extern char *jgmod_song_name;
void init_mod_player(void);
void update_mod_player(void);
void exit_mod_player(void);

/* from lighting.c: */
extern int lighting_color,lighting_node_count,lighting_color_mask,lighting_cleanup_time;
extern LIGHT_TREE *light_tree[TILE_NUM];
extern BITMAP *light_map;
BITMAP *create_light_bitmap(int radius, int r, int g, int b);
void blur_area(BITMAP *bmp, int x1, int y1, int x2, int y2);
LIGHT_TREE *create_light_node(int tile, int color);
BITMAP *get_tile_from_tree(int tile, int color);
void link_light_tree(LIGHT_TREE *n, LIGHT_TREE *tree);
void cleanup_light_tree(LIGHT_TREE **from);
void check_lighting_cleanup(void);
void free_lighting_data(void);

/* from random.c: */
void create_random_map(void);
void fixup_map_ex(BITMAP *map);

/* from ai.c: */
void do_tank_ai(PLAYERTANK *t);

/* from tankzone.c: */
extern int scrw,scrh,colordepth;
extern bool use_jgmod;
extern unsigned int game_time;
extern DATAFILE *lnd;
extern int MAPW,MAPH,GLOW,GLOH; // needed to add for random.c
void exitmsg(const char *fmt, ...);
void initialize(int argc, char *argv[]);

#define assert(x) ASSERT(x)

////////////////////// More Defines:

/* tank inputs */
/*#define SCAN_UP         0x01
#define SCAN_DOWN       0x02
#define SCAN_LEFT       0x04
#define SCAN_RIGHT      0x08
#define SCAN_NOROTATE   0x10
#define SCAN_FIRE       0x20
#define SCAN_LIGHT      0x40*/
#define SCAN_SPEEDUP    0x01
#define SCAN_SLOWDOWN   0x02
#define SCAN_GUNLEFT    0x04
#define SCAN_GUNRIGHT   0x08
#define SCAN_BASELEFT   0x10
#define SCAN_BASERIGHT  0x20
#define SCAN_SHOOT      0x40
#define SCAN_LIGHT      0x80

//PLAYERTANK
#define INGAME_SCROLL_SPEED 4
#define TARGET_CIRCLE_SIZE 10
#define TARGET_LINE_SIZE   15
#define C_LIGHT_RADIUS 5
#define WHITE_LIGHT_RADIUS 8
#define LIGHT_RADIUS 24
#define MAX_LEN 20 //18
#define MIN_LEN 6 //8
#define RELOAD_SPEED    2
#define START_STRENGTH 512
#define SMOKE_STRENGTH 255
#define EXPL_AANTAL 2
#define EXPL_POWER 1
#define FOR_SPEED 5
#define WAY_FORSP 6 
#define BACK_SPEED -3
#define LOOPANG_SPEED 0.088
#define TANKANG_SPEED 0.053
#define SLIPDANGER .8
#define TERUGSLAG -2.0 //-.5
#define TNK_RADIUS 13
#define TNK_CRADIUS 4
#define FIREDIS 512
#define LIGHT_RAD 20
#define LIGHT_DIS 128
#define LIGHT_A 255
#define REPAIR_SPEED 6
#define SCROLL_SPEED 10
#define TANK_COM_TIME 1800
#define AUTOTARGET_SPEED 0.022

//TURRET
#define MAX_TURRETS 256
extern int AANTAL_TURRETS;
#define TURRET_START_STRENGTH 256
#define TURRET_SMOKE_STRENGTH 255
#define TURRET_CAPTURE_STRENGTH 128
#define TURRET_CAPTURE_DISTANCE 75
#define TURRET_REPAIR_DISTANCE 75
#define TURRET_REPAIR_SPEED 5
#define TURRET_RADIUS 8
#define TURRET_MIN_LEN 10
#define TURRET_MAX_LEN 23
#define TURRET_TIME 213 //fire distance
#define TURRET_SELFREPAIR_SPEED 50
#define TURRET_ROTATE_SPEED 0.044 //0.017453

//CANNONBALL
#define MAX_CANNONBALLS 32

//EXPLOSION
#define MAX_EXPLOSIONS 32
#define EXPL_START_ALPHA 223
#define EXPL_ALPHA_SPEED 7
#define EXPLOSION_LIGHT_RADIUS 24

//SMOKE
#define MAX_SMOKES 256
#define SMOKE_YSPEED -1
#define SMOKE_ASPEED 1
#define SMOKE_COLOR 80

//PLONS
#define MAX_PLONZEN 32
#define PLONS_A 255

//FIRE
#define MAX_FIRES 32
#define FIRE_LIGHT 0
#define FIRE_LIGHT_RADIUS 12
#define FIRE_COL_R 255 // 100%
#define FIRE_COL_G 192 // 75%
#define FIRE_COL_B 128 // 35%

///////////////////// More variables

extern int scrw,scrh,colordepth;
extern int MAPW, MAPH;
extern int GLOW, GLOH;
extern int VIEW, VIEH;
extern int AANTAL_TURRETS;
extern bool use_sound,use_jgmod;
extern int sound_voices,jgmod_voices,jgmod_volume,jgmod_start_time,jgmod_count;
extern DATAFILE *sample,*jgmods;
extern int side_color[6][64];
extern BITMAP *explosion_light[30], *fire_light, *blue_light, *green_light, *red_light, *white_light;
extern BITMAP *fire_animation[256]; //*bigfire_animation[128];
extern int fire_color[256];
extern int explosion_light_radius[30];
extern bool use_lighting,use_intro,use_turrets_vs_turrets,use_randommap;
extern FILE *input_file;
extern PALETTE lpal;
extern BITMAP *buffer, *page[2], *map;
/* because MSVC math.h #defines expl(x) */
#undef expl
#define expl    expl_tj
extern DATAFILE *data, *lnd, *expl;
// don't delete this stupid variable "ghfjkf"
extern u_char ghfjkf, accessible[];
extern VIEWPORT view[2];
extern PLAYERTANK tnk[2];
extern TURRET tur[MAX_TURRETS];
extern CANNONBALL can[MAX_CANNONBALLS + 1];
extern EXPLOSION ex[MAX_EXPLOSIONS + 1];
extern SMOKE smk[MAX_SMOKES + 1];
extern PLONS pls[MAX_PLONZEN + 1];
extern FIRE fir[MAX_FIRES + 1];
extern volatile int frame,fps,speed_counter; 
extern unsigned int game_time;
extern int white, grey, yellow, orange, l_red, d_red, l_green, vl_blue, l_blue, d_blue;
extern int winner,disp_alarm,sound_freq,game_speed; 
extern int screenshot_count;
extern int turret_count;
extern BITMAP *turretmap;

///////////////////////// Function prototypes

void load_lighting_data(char *filename);
void clear_light_map();
LIGHT_TREE *create_light_node(int tile, int color);
BITMAP *get_tile_from_tree(int tile, int color);
void load_map(char *name);
int volume_distance(int x1, int y1, int x2, int y2, int volume_zero);
void get_pan_vol(int *pan, int *vol, int x, int y, int v);
void start();
void reset();
float angle_to_angle(float angle1, float angle2, float s, int *ready);
int cc_or_c(float angle1, float angle2, float epsilon);
void alternative_shore_drawer(int x, int y, int r, int g, int b);
void alternative_water_drawer(int x, int y, int r, int g, int b);
void draw_map();
void draw_trans_fire(int v, BITMAP *bmp, FIRE *f);
void clear_helper(int x1, int y1, int x2, int y2);
void check_ray_and_light(BITMAP *bmp, int xc, int yc, int d);
void calc_hit_pos(float *px, float *py, float xs, float ys, int v);
void draw_all();
int free_plons();
void create_plons(int x, int y, int growspeed, int color, int se);
void do_plonzen();
int free_smoke();
void create_smoke(int x, int y, int maxrad, int growspeed, int color, int a);
void do_smokes();
int free_explosion();
void create_explosion(float x, float y, float xs, float ys, int team, int num, int se);
void do_explosions();
int free_cannonball();
int create_cannonball(int x, int y, float angle, int time, int team, int num);
void do_cannonballs();
int free_fire();
void create_fire(int x, int y);
void do_fires();
float smart_angle(float tx, float ty, float txs, float tys, float sx, float sy, int time);
int check_shot(float x, float y, float a, int time, int t);
void do_playertanks();
int free_turret();
int build_turret(int x, int y, int side);
void do_turrets();
void create_fire(int x, int y);

#endif /* !defined(__tjv_TANKZONE_H__) */
