; Author: Tobi Vollebregt

;   TankZone: My second Allegro game.
;   Copyright (C) 2003  Tobi Vollebregt
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;   See `License.txt', which contains a verbatim copy of the
;   GNU General Public License, for details.
;
;   Please send your reaction to: tobivollebregt@hotmail.com

[BITS 32]

[GLOBAL _draw_multiply_sprite4]
[EXTERN __multiply_sprite_gamma]



[SECTION .text]

; typedef struct SPRITE4 {
;     int w,h,masked;
;     unsigned char *data;
;     unsigned short palette_color_16[16];
; } SPRITE4;

%define SPRITE_W    0
%define SPRITE_H    4
%define SPRITE_DAT  12
%define SPRITE_PAL  16

; got these defines from allegro/obj/djgpp/asmdef.inc
%define BMP_W 0
%define BMP_H 4
%define BMP_CLIP 8
%define BMP_CL 12
%define BMP_CR 16
%define BMP_CT 20
%define BMP_CB 24
%define BMP_VTABLE 28
%define BMP_WBANK 32
%define BMP_RBANK 36
%define BMP_DAT 40
%define BMP_ID 44
%define BMP_EXTRA 48
%define BMP_XOFFSET 52
%define BMP_YOFFSET 56
%define BMP_SEG 60
%define BMP_LINE 64

%define VTABLE_COLOR_DEPTH 0
%define VTABLE_MASK_COLOR 4
%define VTABLE_UNBANK 8

; ---------------------------------------------------------------------------
; Prototype: void draw_multiply_sprite4(BITMAP *dst, SPRITE4 *sprite,
;   int dx, int dy, int r, int g, int b)
; Note that this draw_multiply_sprite4() has no support for masked sprites.
; ---------------------------------------------------------------------------

arg_dst             equ 8
arg_sprite          equ 12
arg_dx              equ 16
arg_dy              equ 20
arg_r               equ 24
arg_g               equ 28
arg_b               equ 32

var_sxbeg           equ -4
var_sybeg           equ -8
var_dxbeg           equ -12
var_dybeg           equ -16
var_w               equ -24
var_h               equ -28
_var_count          equ 28

_draw_multiply_sprite4:
    push ebp
    mov ebp, esp
    sub esp, _var_count

    push ebx
    push edi
    push esi


    mov edi, [ebp + arg_dst]
    mov esi, [ebp + arg_sprite]

    cmp [edi + BMP_CLIP], dword 0   ; if(dst->clip) {
    je near .no_clip

    mov edx, [ebp + arg_dx]
    mov eax, [edi + BMP_CL]     ; tmp = dst->cl - dx;
    sub eax, edx
    mov ecx, 0
    cmp eax, ecx                ; sxbeg = ((tmp < 0) ? 0 : tmp);
    jle .let_sxbeg_be_zero
    mov ecx, eax
.let_sxbeg_be_zero
    mov [ebp + var_sxbeg], ecx
    add ecx, edx                ; dxbeg = sxbeg + dx
    mov [ebp + var_dxbeg], ecx

    mov eax, [edi + BMP_CR]     ; tmp = dst->cr - dx;
    sub eax, edx
    mov ecx, [esi + SPRITE_W]
    cmp eax, ecx                ; w = ((tmp > sprite->w) ? sprite->w : tmp) - sxbeg;
    jg .let_w_be_sprite_w
    mov ecx, eax
.let_w_be_sprite_w
    sub ecx, [ebp + var_sxbeg]
    mov [ebp + var_w], ecx
    cmp ecx, 0                  ; if(w <= 0) return;
    jle near .return

    mov edx, [ebp + arg_dy]
    mov eax, [edi + BMP_CT]     ; tmp = dst->ct - dy;
    sub eax, edx
    mov ecx, 0
    cmp eax, ecx                ; sybeg = ((tmp < 0) ? 0 : tmp);
    jle .let_sybeg_be_zero
    mov ecx, eax
.let_sybeg_be_zero
    mov [ebp + var_sybeg], ecx
    add ecx, edx                ; dybeg = sybeg + dy
    mov [ebp + var_dybeg], ecx

    mov eax, [edi + BMP_CB]     ; tmp = dst->cb - dy;
    sub eax, edx
    mov ecx, [esi + SPRITE_H]
    cmp eax, ecx                ; h = ((tmp > sprite->h) ? sprite->h : tmp) - sybeg;
    jg .let_h_be_sprite_h
    mov ecx, eax
.let_h_be_sprite_h
    sub ecx, [ebp + var_sybeg]
    mov [ebp + var_h], ecx
    cmp ecx, 0                  ; if(h <= 0) return;
    jle near .return

    jmp .end_no_clip

.no_clip                        ; } else {

    mov eax, [esi + SPRITE_W]   ; w = sprite->w;
    mov [ebp + var_w], eax
    mov eax, [esi + SPRITE_H]   ; h = sprite->h;
    mov [ebp + var_h], eax
    mov [ebp + var_sxbeg], dword 0  ; sxbeg = 0;
    mov [ebp + var_sybeg], dword 0  ; sybeg = 0;
    mov eax, [ebp + arg_dx]     ; dxbeg = dx;
    mov [ebp + var_dxbeg], eax
    mov eax, [ebp + arg_dy]     ; dybeg = dy;
    mov [ebp + var_dybeg], eax

.end_no_clip                    ; }


    mov eax, [edi + BMP_VTABLE] ; if(bitmap_color_depth(dst)==16) {
    cmp [eax + VTABLE_COLOR_DEPTH], dword 16
    jne near .colordepth_15

    mov ecx, 0                  ; for(i=0; i<16; i++) {

.palette_loop_16
    mov eax, [esi + SPRITE_PAL + 2 * ecx]   ; c=sprite->palette_color_16[i];
    mov ebx, eax
    and eax, 0x001f             ; cb=getb16(c)*b/_multiply_sprite_gamma;
    mul dword [ebp + arg_b]
    div dword [__multiply_sprite_gamma]
    cmp eax, 31
    jge .let_blue_be_max_16
    mov edi, eax
    jmp .end_let_blue_be_16
.let_blue_be_max_16
    mov edi, 0x001f
.end_let_blue_be_16

    mov eax, ebx
    and eax, 0x07e0             ; cg=getg16(c)*g/_multiply_sprite_gamma;
    shr eax, 5
    mul dword [ebp + arg_g]
    div dword [__multiply_sprite_gamma]
    cmp eax, 63
    jge .let_green_be_max_16
    shl eax, 5
    or edi, eax
    jmp .end_let_green_be_16
.let_green_be_max_16
    or edi, 0x07e0
.end_let_green_be_16

    mov eax, ebx
    and eax, 0xf800             ; cr=getr16(c)*r/_multiply_sprite_gamma;
    shr eax, 11
    mul dword [ebp + arg_r]
    div dword [__multiply_sprite_gamma]
    cmp eax, 31
    jge .let_red_be_max_16
    shl eax, 11
    or edi, eax
    jmp .end_let_red_be_16
.let_red_be_max_16
    or edi, 0xf800
.end_let_red_be_16

    mov [pal + 4 * ecx], edi    ; pal[i]=makecol16(MIN(cr,255),MIN(cg,255),MIN(cb,255));

    inc ecx
    test ecx, 16
    jz near .palette_loop_16

    jmp .end_colordepth

.colordepth_15                  ; } else {

    mov ecx, 0                  ; for(i=0; i<16; i++) {

.palette_loop_15
    mov eax, [esi + SPRITE_PAL + 2 * ecx]   ; c=sprite->palette_color_16[i];
    mov ebx, eax
    and eax, 0x001f             ; cb=getb15(c)*b/_multiply_sprite_gamma;
    mul dword [ebp + arg_b]
    div dword [__multiply_sprite_gamma]
    cmp eax, 31
    jge .let_blue_be_max_15
    mov edi, eax
    jmp .end_let_blue_be_15
.let_blue_be_max_15
    mov edi, 0x001f
.end_let_blue_be_15

    mov eax, ebx
    and eax, 0x03e0             ; cg=getg15(c)*g/_multiply_sprite_gamma;
    shr eax, 5
    mul dword [ebp + arg_g]
    div dword [__multiply_sprite_gamma]
    cmp eax, 31
    jge .let_green_be_max_15
    shl eax, 5
    or edi, eax
    jmp .end_let_green_be_15
.let_green_be_max_15
    or edi, 0x03e0
.end_let_green_be_15

    mov eax, ebx
    and eax, 0x7c00             ; cr=getr15(c)*r/_multiply_sprite_gamma;
    shr eax, 10
    mul dword [ebp + arg_r]
    div dword [__multiply_sprite_gamma]
    cmp eax, 31
    jge .let_red_be_max_15
    shl eax, 10
    or edi, eax
    jmp .end_let_red_be_15
.let_red_be_max_15
    or edi, 0x7c00
.end_let_red_be_15

    mov [pal + 4 * ecx], edi    ; pal[i]=makecol16(MIN(cr,255),MIN(cg,255),MIN(cb,255));

    inc ecx
    test ecx, 16
    jz near .palette_loop_15

.end_colordepth                 ; }

    mov ecx, 0                  ; for(i=0; i<256; i++)
.expand_loop
    mov ebx, ecx
    and ebx, 15
    mov eax, [pal + 4 * ebx]    ; xpal[i]=(pal[i>>4]<<16)|pal[i&15];
    mov ebx, ecx
    shr ebx, 4
    mov edx, [pal + 4 * ebx]
    shl edx, 16
    or eax, edx
    mov [palx + 4 * ecx], eax
    inc ecx
    test ecx, 256
    jz .expand_loop


    ; ebx = y (scanline)
    ; ecx = x-counter
    ; esi = source
    ; edi = destination

    shr dword [ebp + var_sxbeg], 1  ; sxbeg /= 2;
    shr dword [ebp + var_w], 1      ; w /= 2;
    shl dword [ebp + var_dxbeg], 1  ; dxbeg *= 2;

    mov ebx, 0

.y_loop

    mov esi, [ebp + arg_sprite]
    mov edi, [ebp + arg_dst]

    mov eax, ebx
    add eax, [ebp + var_sybeg]  ; s=&sprite->data[mult*(y+sybeg)+sxbeg];
    mul dword [esi + SPRITE_H]
    shr eax, 1
    add eax, [ebp + var_sxbeg]
    add eax, [esi + SPRITE_DAT]
    mov esi, eax

    mov eax, ebx                ; d=(unsigned long *)(((unsigned short *)dst->line[y+dybeg])+dxbeg);
    add eax, [ebp + var_dybeg]
    mov edi, [edi + BMP_LINE + 4 * eax]
    add edi, [ebp + var_dxbeg]

    mov ecx, [ebp + var_w]

    cmp ecx, 4
    jl .prepare_to_finish_line

.long_line_loop

    mov eax, [esi]
    mov edx, eax
    and edx, 0xff
    mov edx, [palx + 4 * edx]
    mov [edi], edx

    shr eax, 8
    mov edx, eax
    and edx, 0xff
    mov edx, [palx + 4 * edx]
    mov [edi + 4], edx

    shr eax, 8
    mov edx, eax
    and edx, 0xff
    mov edx, [palx + 4 * edx]
    mov [edi + 8], edx

    shr eax, 8
    mov edx, eax
    and edx, 0xff
    mov edx, [palx + 4 * edx]
    mov [edi + 12], edx

    add esi, 4
    add edi, 16
    sub ecx, 4
    cmp ecx, 4
    jge .long_line_loop

.prepare_to_finish_line

    test ecx, ecx
    jz .end_line

.finish_line

    mov eax, 0
    mov al, [esi]
    mov eax, [palx + 4 * eax]
    mov [edi], eax

    inc esi
    add edi, 4
    loop .finish_line

.end_line

    inc ebx
    cmp ebx, [ebp + var_h]
    jl near .y_loop

.return

    pop esi
    pop edi
    pop ebx

    mov esp, ebp
    pop ebp
    ret



[SECTION .bss]

pal     resd    16
palx    resd    256
