/* Author: Tobi Vollebregt */

/*  TankZone: My second Allegro game.
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

#ifndef __tjv_SPRITE4_H__
#define __tjv_SPRITE4_H__

#include <allegro.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct SPRITE4 {
    int w,h, masked;
    unsigned char *data;
    unsigned short palette_color_16[16];
} SPRITE4;

/* Adjust this value to get darker or brighter sprites from
draw_multiply_sprite4(). Must be higher than zero, 1 is very bright
(almost white), higher values represent darker images.
Default is 255. */
extern int _multiply_sprite_gamma;

/* Allocates and computes a 4 bit sprite. Automatically generates
a 16 color palette optimized to the bitmap. Return NULL on failure.
The width of the bitmap must be an even number. */
SPRITE4 *get_sprite4(BITMAP *bmp);

/* Destroys a previously allocated 4 bit sprite. */
void destroy_sprite4(SPRITE4 *sprite);

/* Draws a 4 bit sprite onto the destination bitmap. There are a few
restrictions: 1) dst must be 15 or 16 bits per pixel, and it must be in
the same colordepth, as which was selected when the sprite was computed.
2) The cl and cr values of dst must be an even number (ie. If you call
set_clip(), you should pass an even number as the first x-coordinate,
and an odd number for the second x-coordinate. 3) dx must be an even
number. (You can simply get this around by passing x&~1 for dx. */
void draw_sprite4(BITMAP *dst, SPRITE4 *sprite, int dx, int dy);

/* Does the same as draw_sprite4(), but multiplies the colors of the
sprite with the r,g,b value passed to this function before displaying. */
void draw_multiply_sprite4(BITMAP *dst, SPRITE4 *sprite, int dx, int dy, int r, int g, int b);

#ifdef __cplusplus
}   // End of extern "C"
#endif

#endif // !defined (__tjv_SPRITE4_H__)
