/* Author: Tobi Vollebregt */

/*  TankZone: My second Allegro game.
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

/* part of Tankzone, generating a random maze/map */

#include "tankzone.h"

typedef struct SQUARE
{   struct SQUARE *next;
    int x,y,tile;
} SQUARE;

static void insert_square(SQUARE **list, int x, int y, int tile)
{
    SQUARE *p;

    p=malloc(sizeof(SQUARE));
    if(!p) MEMERR;

    p->x=x;
    p->y=y;
    p->tile=tile;

    p->next=*list;
    *list=p;
}

static void create_random_ground()
{
    int x,y,tile,done,newt,l,t,r,b;
    int vv=(1<<get_config_int(NULL,"random_variety",6))-1;
    SQUARE *list=NULL,*temp;

    insert_square(&list,rand()%MAPW,rand()%MAPH,TILE_GRASS);

    while(list)
    {
        x=list->x;
        y=list->y;
        tile=list->tile;

        temp=list;
        list=list->next;
        free(temp);

        l=getpixel(map,x-1,y);
        r=getpixel(map,x+1,y);
        t=getpixel(map,x,y-1);
        b=getpixel(map,x,y+1);
        /*if((tile==TILE_DESERT && (l==TILE_WATER || r==TILE_WATER || t==TILE_WATER || b==TILE_WATER)) || (tile==TILE_WATER && (l==TILE_DESERT || r==TILE_DESERT || t==TILE_DESERT || b==TILE_DESERT)))
            tile=TILE_GRASS;*/

        putpixel(map,x,y,tile);

        done=(l?1:0)|(r?2:0)|(t?4:0)|(b?8:0);

        while(done!=15)
        {   r=rand()&vv;
            if(r<2) newt=TILE_GRASS;
            else if(r<4) newt=TILE_DESERT;
            else if(r<5) newt=TILE_WATER;
            else newt=tile;
            r=rand()&3;
            while(done&(1<<r)) r=(r+1)&3;
            done|=(1<<r);
            if(r==0) insert_square(&list,x-1,y,newt);
            else if(r==1) insert_square(&list,x+1,y,newt);
            else if(r==2) insert_square(&list,x,y-1,newt);
            else if(r==3) insert_square(&list,x,y+1,newt);
        }
    }
}

/*static void fixup_map()
{
    int x,y,get,l,r,t,b;

    for(y=0; y<MAPH; y++)
    {   for(x=0; x<MAPW; x++)
        {
            get=getpixel(map, x, y);
            if(get==TILE_GRASS)
            {   l=getpixel(map,x-1,y); r=getpixel(map,x+1,y);
            t=getpixel(map,x,y-1); b=getpixel(map,x,y+1);
            if(l == TILE_DESERT || r == TILE_DESERT || t == TILE_DESERT || b == TILE_DESERT)
                if(l != TILE_WATER && r != TILE_WATER && t != TILE_WATER && b != TILE_WATER)
                putpixel(map, x, y, TILE_DESERTEDGE);
            if(l == TILE_WATER || r == TILE_WATER || t == TILE_WATER || b == TILE_WATER)
                putpixel(map, x, y, TILE_SHORE);
            }
        }
    }
}*/

#if 0

void fixup_map_ex(BITMAP *map)
{
  int l, t, r, b, lt, rt, rb, lb, get, put;
  int x, y;

    BITMAP *temp;

    temp=create_bitmap_ex(8,map->w,map->h);
    if(!temp) exitmsg("Damn!  Not enough memory (in fixup_map_ex)\n");

    for(y=0; y<map->h; y++)
        for(x=0; x<map->w; x++)
        {   get=getpixel(map,x,y);
            if(get==TILE_SHORE ||
                get==TILE_DESERTEDGE)
            {   l = getpixel(map, x - 1, y);
                t = getpixel(map, x, y - 1);
                r = getpixel(map, x + 1, y);
                b = getpixel(map, x, y + 1);
                lt=(l==TILE_DESERT)+(r==TILE_DESERT)+
                    (t==TILE_DESERT)+(b==TILE_DESERT);
                rt=(l==TILE_GRASS)+(r==TILE_GRASS)+
                    (t==TILE_GRASS)+(b==TILE_GRASS);
                if(rt>=lt) putpixel(map,x,y,TILE_GRASS);
                else putpixel(map,x,y,TILE_DESERT);
            }
        }

    blit(map,temp,0,0,0,0,map->w,map->h);

  for(y = 0; y < map->h; y++)
  { for(x = 0; x < map->w; x++)
    { get = getpixel(map, x, y);
      if(get!=TILE_GRASS && get!=TILE_DESERT && get!=TILE_WATER) continue;

      l = getpixel(map, x - 1, y);
      t = getpixel(map, x, y - 1);
      r = getpixel(map, x + 1, y);
      b = getpixel(map, x, y + 1);
      lt = getpixel(map, x - 1, y - 1);
      rt = getpixel(map, x + 1, y - 1);
      rb = getpixel(map, x + 1, y + 1);
      lb = getpixel(map, x - 1, y + 1);
      if(get == TILE_GRASS)
      { 
    if(l == TILE_WATER && lt == TILE_WATER && t == TILE_WATER)
      put = TILE_G_W_LT;
    else if(t == TILE_WATER && rt == TILE_WATER && r == TILE_WATER)
      put = TILE_G_W_RT;
    else if(r == TILE_WATER && rb == TILE_WATER && b == TILE_WATER)
      put = TILE_G_W_RB;
    else if(b == TILE_WATER && lb == TILE_WATER && l == TILE_WATER)
      put = TILE_G_W_LB;
    else if(l == TILE_WATER) put = TILE_G_W_L;
    else if(t == TILE_WATER) put = TILE_G_W_T;
    else if(r == TILE_WATER) put = TILE_G_W_R;
    else if(b == TILE_WATER) put = TILE_G_W_B;
    else if(lt == TILE_WATER) put = TILE_W_G_RB;
    else if(rt == TILE_WATER) put = TILE_W_G_LB;
    else if(rb == TILE_WATER) put = TILE_W_G_LT;
    else if(lb == TILE_WATER) put = TILE_W_G_RT;

    else if(l == TILE_DESERT && lt == TILE_DESERT && t == TILE_DESERT)
      put = TILE_G_D_LT;
    else if(t == TILE_DESERT && rt == TILE_DESERT && r == TILE_DESERT)
      put = TILE_G_D_RT;
    else if(r == TILE_DESERT && rb == TILE_DESERT && b == TILE_DESERT)
      put = TILE_G_D_RB;
    else if(b == TILE_DESERT && lb == TILE_DESERT && l == TILE_DESERT)
      put = TILE_G_D_LB;
    else if(l == TILE_DESERT) put = TILE_G_D_L;
    else if(t == TILE_DESERT) put = TILE_G_D_T;
    else if(r == TILE_DESERT) put = TILE_G_D_R;
    else if(b == TILE_DESERT) put = TILE_G_D_B;
    else if(lt == TILE_DESERT) put = TILE_D_G_RB;
    else if(rt == TILE_DESERT) put = TILE_D_G_LB;
    else if(rb == TILE_DESERT) put = TILE_D_G_LT;
    else if(lb == TILE_DESERT) put = TILE_D_G_RT;

    else put = TILE_GRASS;
      }
      if(get == TILE_WATER)
      { if(l == TILE_DESERT && lt == TILE_DESERT && t == TILE_DESERT)
      put = TILE_W_D_LT;
    else if(t == TILE_DESERT && rt == TILE_DESERT && r == TILE_DESERT)
      put = TILE_W_D_RT;
    else if(r == TILE_DESERT && rb == TILE_DESERT && b == TILE_DESERT)
      put = TILE_W_D_RB;
    else if(b == TILE_DESERT && lb == TILE_DESERT && l == TILE_DESERT)
      put = TILE_W_D_LB;
    else if(l == TILE_DESERT) put = TILE_W_D_L;
    else if(t == TILE_DESERT) put = TILE_W_D_T;
    else if(r == TILE_DESERT) put = TILE_W_D_R;
    else if(b == TILE_DESERT) put = TILE_W_D_B;
    else if(lt == TILE_DESERT) put = TILE_D_W_RB;
    else if(rt == TILE_DESERT) put = TILE_D_W_LB;
    else if(rb == TILE_DESERT) put = TILE_D_W_LT;
    else if(lb == TILE_DESERT) put = TILE_D_W_RT;

    else put = TILE_WATER;
      }
      if(get == TILE_DESERT)
    put = TILE_DESERT;
    putpixel(map,x,y,put);
    }
  }

    for(y=0; y<map->h; y++)
        for(x=0; x<map->w; x++)
        {   get=getpixel(temp,x,y);
            if(get!=TILE_GRASS && get!=TILE_WATER && get!=TILE_DESERT)
                putpixel(map,x,y,get);
        }

    destroy_bitmap(temp);
}

#else

void fixup_map_ex(BITMAP *map)
{
    int x,y,a,b,c,d,i,get,l,t,r,lt,rt,lb,rb;
    BITMAP *temp,*temp2;

    temp=create_bitmap_ex(8,map->w,map->h);
    if(!temp) exitmsg("Damn!  Not enough memory (in fixup_map_ex,temp)\n");
    clear_bitmap(temp);

    temp2=create_bitmap_ex(8,map->w,map->h);
    if(!temp2) exitmsg("Damn!  Not enough memory (in fixup_map_ex,temp2)\n");
    clear_bitmap(temp2);

    // First we need to delete shore and desert-edge
    for(y=0; y<map->h; y++)
        for(x=0; x<map->w; x++)
        {   get=getpixel(map,x,y);
            if(get==TILE_SHORE ||
                get==TILE_DESERTEDGE)
            {   l = getpixel(map, x - 1, y);
                t = getpixel(map, x, y - 1);
                r = getpixel(map, x + 1, y);
                b = getpixel(map, x, y + 1);
                lt=getpixel(map,x-1,y-1);
                rt=getpixel(map,x+1,y-1);
                lb=getpixel(map,x-1,y+1);
                rb=getpixel(map,x+1,y-1);
                a=(l==TILE_GRASS)+(r==TILE_GRASS)+
                    (t==TILE_GRASS)+(b==TILE_GRASS)+
                    (lt==TILE_GRASS)+(rt==TILE_GRASS)+
                    (lb==TILE_GRASS)+(rb==TILE_GRASS);
                c=(l==TILE_DESERT)+(r==TILE_DESERT)+
                    (t==TILE_DESERT)+(b==TILE_DESERT)+
                    (lt==TILE_DESERT)+(rt==TILE_DESERT)+
                    (lb==TILE_DESERT)+(rb==TILE_DESERT);
                d=(l==TILE_WATER)+(r==TILE_WATER)+
                    (t==TILE_WATER)+(b==TILE_WATER)+
                    (lt==TILE_WATER)+(rt==TILE_WATER)+
                    (lb==TILE_WATER)+(rb==TILE_WATER);
                if(a>c && a>d) putpixel(map,x,y,TILE_GRASS);
                else if(c>a && c>d) putpixel(map,x,y,TILE_DESERT);
                else if(d>a && d>c) putpixel(map,x,y,TILE_WATER);
                else putpixel(map,x,y,TILE_GRASS);
            }
        }

    // We store this situation to restore walls later on
    blit(map,temp2,0,0,0,0,map->w,map->h);

    // All tiles must contain GRASS,DESERT or WATER
    for(y=0; y<map->h; y++)
        for(x=0; x<map->w; x++)
        {   get=getpixel(map,x,y);
            if(get!=TILE_GRASS && get!=TILE_DESERT && get!=TILE_WATER)
            {   l = getpixel(temp2, x - 1, y);
                t = getpixel(temp2, x, y - 1);
                r = getpixel(temp2, x + 1, y);
                b = getpixel(temp2, x, y + 1);
                lt=getpixel(temp2,x-1,y-1);
                rt=getpixel(temp2,x+1,y-1);
                lb=getpixel(temp2,x-1,y+1);
                rb=getpixel(temp2,x+1,y-1);
                a=(l==TILE_GRASS)+(r==TILE_GRASS)+
                    (t==TILE_GRASS)+(b==TILE_GRASS)+
                    (lt==TILE_GRASS)+(rt==TILE_GRASS)+
                    (lb==TILE_GRASS)+(rb==TILE_GRASS);
                c=(l==TILE_DESERT)+(r==TILE_DESERT)+
                    (t==TILE_DESERT)+(b==TILE_DESERT)+
                    (lt==TILE_DESERT)+(rt==TILE_DESERT)+
                    (lb==TILE_DESERT)+(rb==TILE_DESERT);
                d=(l==TILE_WATER)+(r==TILE_WATER)+
                    (t==TILE_WATER)+(b==TILE_WATER)+
                    (lt==TILE_WATER)+(rt==TILE_WATER)+
                    (lb==TILE_WATER)+(rb==TILE_WATER);
                if(a>c && a>d) putpixel(map,x,y,TILE_GRASS);
                else if(c>a && c>d) putpixel(map,x,y,TILE_DESERT);
                else if(d>a && d>c) putpixel(map,x,y,TILE_WATER);
                else putpixel(map,x,y,TILE_GRASS);
            }
        }

    // Now we calculate the right interp. tile and use it.
    for(y=0; y<map->h; y++)
    {   for(x=0; x<map->w; x++)
        {   a=getpixel(map,x,y);
            b=getpixel(map,x+1,y);
            c=getpixel(map,x,y+1);
            d=getpixel(map,x+1,y+1);
            if(a==TILE_GRASS) a=0;
            else if(a==TILE_DESERT) a=1;
            else if(a==TILE_WATER) a=2;
            else {ASSERT(FALSE);}
            if(b==TILE_GRASS) b=0;
            else if(b==TILE_DESERT) b=1;
            else if(b==TILE_WATER) b=2;
            else if(b==-1) b=a;
            else {ASSERT(FALSE);}
            if(c==TILE_GRASS) c=0;
            else if(c==TILE_DESERT) c=1;
            else if(c==TILE_WATER) c=2;
            else if(c==-1) c=a;
            else {ASSERT(FALSE);}
            if(d==TILE_GRASS) d=0;
            else if(d==TILE_DESERT) d=1;
            else if(d==TILE_WATER) d=2;
            else if(d==-1) d=a;
            else {ASSERT(FALSE);}

            i=d+3*c+9*b+27*a;
            if(i==0) i=TILE_GRASS;
            else if(i==40) i=TILE_DESERT;
            else if(i==80) i=TILE_WATER;
            else i+=TILE_NUM_CLASSIC;
            putpixel(temp,x,y,i);
        }
    }

    // Result is in temp, so we blit temp to map
    blit(temp,map,0,0,0,0,map->w,map->h);

    // Now we restore walls and things like that
    for(y=0; y<map->h; y++)
        for(x=0; x<map->w; x++)
        {   get=getpixel(temp2,x,y);
            if(get!=TILE_GRASS && get!=TILE_WATER && get!=TILE_DESERT)
                putpixel(map,x,y,get);
        }

    destroy_bitmap(temp);
    destroy_bitmap(temp2);
}

#endif

static void create_random_rocks()
{   int i, x, y;
    for(i = (int)sqrt(MAPW*MAPH); i >= 0; i--)
    {   x = random() % MAPW; y = random() % MAPH;
        if(getpixel(map, x, y) == TILE_GRASS &&
            getpixel(map, x-1,y-1) != TILE_ROCK &&
            getpixel(map, x,y-1) != TILE_ROCK &&
            getpixel(map, x+1,y-1) != TILE_ROCK &&
            getpixel(map, x-1,y) != TILE_ROCK &&
            getpixel(map, x+1,y) != TILE_ROCK &&
            getpixel(map, x-1,y+1) != TILE_ROCK &&
            getpixel(map, x,y+1) != TILE_ROCK &&
            getpixel(map, x+1,y+1) != TILE_ROCK)
            putpixel(map, x, y, TILE_ROCK);
    }
}

static void create_random_turrets()
{   int i, xm, ym, turn = AANTAL_TURRETS, get, dis0, dis1;
    for(i = (int)sqrt(MAPW*MAPH); i >= 0; i--)
    {
    xm = random() % MAPW; ym = random() % MAPH;
    if(!accessible[get=_getpixel(map, xm, ym)] || (get == TILE_WATER)
        || (xm==(int)tnk[0].x/TILE_SIZE && ym==(int)tnk[0].y/TILE_SIZE)
        || (xm==(int)tnk[1].x/TILE_SIZE && ym==(int)tnk[1].y/TILE_SIZE)) 
        continue;
    tur[turn].x = xm * TILE_SIZE + TILE_SIZE / 2;
    tur[turn].y = ym * TILE_SIZE + TILE_SIZE / 2;
    dis0 = distance(tnk[0].x, tnk[0].y, tur[turn].x, tur[turn].y);
    dis1 = distance(tnk[1].x, tnk[1].y, tur[turn].x, tur[turn].y);
    if(dis0 > FIREDIS && dis0 <= (FIREDIS+TURRET_TIME)) continue;
    if(dis1 > FIREDIS && dis1 <= (FIREDIS+TURRET_TIME)) continue; 
    if(dis0 <= FIREDIS && dis1 <= FIREDIS)
    {   if(random()%(2*FIREDIS-dis0-dis1)<FIREDIS-dis0)
        {tur[turn].start=1; tur[turn].stop=2;}
        else {tur[turn].start=0; tur[turn].stop=1;}
    }
    else if(dis0 <= FIREDIS) { tur[turn].start = 1; tur[turn].stop = 2;}
    else if(dis1 <= FIREDIS) { tur[turn].start = 0; tur[turn].stop = 1;}
    else { tur[turn].start = 0; tur[turn].stop = 2;}
    tur[turn].used = TRUE;
    putpixel(map, xm, ym, TILE_TURRET);
    putpixel(turretmap,xm,ym,turn+1);
    if(turn < MAX_TURRETS-1) turn++;
    else break;
    }
    AANTAL_TURRETS = turn;
}

#define N 4

static void create_random_walls()
{   int number, xc, yc, x, y, dir, rotated, splitx[256], splity[256], splitdir[256], splitnum, len;
    BITMAP *bak = create_bitmap_ex(8,MAPW, MAPH);
    if(!bak) MEMERR;
    for(number = (int)sqrt(MAPW*MAPH); number >= 0; number--)
    {   splitnum = 0;
    xc = (random() % (MAPW-(2*N)-1)) + N;
    yc = (random() % (MAPH-(2*N)-1)) + N;
    for(y = yc-N; y <= yc+N; y++)
        for(x = xc-N; x <= xc+N; x++)
        if(!accessible[getpixel(map, x, y)]) goto continue2_;
    dir = random() & 3; /* 0=l,1=t,2=r,3=b */
    splitx[0] = xc; splity[0] = yc; splitdir[0] = dir; 
    while(splitnum >= 0)
    {   rotated = FALSE; len = 0;
        blit(map, bak, 0, 0, 0, 0, MAPW, MAPH);
        xc = splitx[splitnum];
        yc = splity[splitnum];
        dir = splitdir[splitnum];
        splitnum--;
        nextblock:
        if(!rotated && (random()&15) == 0) goto rotate;
        if((random()&15) == 0)
        {   if(++splitnum < 256)
        {   splitx[splitnum] = xc;
            splity[splitnum] = yc;
            if(dir == 0 || dir == 2)
            {   if(random() & 1) splitdir[splitnum] = 1;
            else splitdir[splitnum] = 3;
            }
            else
            {   if(random() & 1) splitdir[splitnum] = 0;
            else splitdir[splitnum] = 2;
            }
        }else splitnum--;
        }
        switch(dir)
        {   case 0:
            if(xc <= N) goto rotate;
            x = xc-N-1;
            for(y = yc-N; y <= yc+N; y++)
            if(!accessible[getpixel(map, x, y)]) goto rotate;
            xc--;
            break;
        case 1:
            if(yc <= N) goto rotate;
            y = yc-N-1;
            for(x = xc-N; x <= xc+N; x++)
            if(!accessible[getpixel(map, x, y)]) goto rotate;
            yc--;
            break;
        case 2:
            if(xc >= MAPW-N-1) goto rotate;
            x = xc+N+1;
            for(y = yc-N; y <= yc+N; y++)
            if(!accessible[getpixel(map, x, y)]) goto rotate;
            xc++;
            break;
        case 3:
            if(yc >= MAPH-N-1) goto rotate;
            y = yc+N+1;
            for(x = xc-N; x <= xc+N; x++)
            if(!accessible[getpixel(map, x, y)]) goto rotate;
            yc++;
            break;
        default:
            break;
        }
        rotated = FALSE;
        putpixel(map, xc, yc, TILE_WALL);
        len++;
        goto nextblock;
        rotate:
        if(rotated) goto continue_;
        rotated = TRUE;
        switch(dir)
        {   case 0: case 2:
            if(random() & 1) dir = 1;
            else dir = 3;
            break;
        case 1: case 3:
            if(random() & 1) dir = 0;
            else dir = 2;
            break;
        default:
            break;
        }
        goto nextblock;
        continue_:
        if(len < 16) blit(bak, map, 0, 0, 0, 0, MAPW, MAPH);
    }
    continue2_: ;
    }
    destroy_bitmap(bak);
}
#undef N

void create_random_map(void)
{   int i, x, y, get, turn=0, xc, yc,c;
    for(i = 0; i < MAX_TURRETS; i++) tur[i].used = FALSE;
    MAPW = MAPH = get_config_int(NULL,"randommapsize",50);
    GLOW = MAPW*TILE_SIZE;
    GLOH = MAPH*TILE_SIZE;
    map = create_bitmap_ex(8, MAPW, MAPH);
    if(!map) MEMERR;
    turretmap=create_bitmap_ex(16,MAPW,MAPH);
    if(!turretmap) MEMERR;
    clear(map);
    clear(turretmap);
    create_random_ground();
    fixup_map_ex(map);

    c=4*FIREDIS;
    do
    {   for(i = 0; i < 2; i++)
    {   tryagain:
        xc = (random() % (MAPW-4)) + 2;
        yc = (random() % (MAPH-4)) + 2;
        for(y = yc-2; y <= yc+2; y++)
        for(x = xc-2; x <= xc+2; x++)
        {   get = getpixel(map, x, y);
            if(!accessible[get] || get == TILE_WATER) goto tryagain;
        }
        tnk[i].x = xc * TILE_SIZE + TILE_SIZE / 2;
        tnk[i].y = yc * TILE_SIZE + TILE_SIZE / 2;
    }
    }
    while(distance(tnk[0].x, tnk[0].y, tnk[1].x, tnk[1].y) < --c);
    for(i = 0; i < 2; i++)
    {   xc = (int)tnk[i].x / TILE_SIZE;
    yc = (int)tnk[i].y / TILE_SIZE;
    tur[turn].used = TRUE;
    tur[turn].x = (xc-2) * TILE_SIZE + TILE_SIZE / 2;
    tur[turn].y = (yc-2) * TILE_SIZE + TILE_SIZE / 2;
    tur[turn].start = 1-i; tur[turn].stop = 2-i;
    putpixel(map, (xc-2), (yc-2), TILE_TURRET);
    putpixel(turretmap, (xc-2),(yc-2),turn+1);
    turn++;
    tur[turn].used = TRUE;
    tur[turn].x = (xc-2) * TILE_SIZE + TILE_SIZE / 2;
    tur[turn].y = (yc+2) * TILE_SIZE + TILE_SIZE / 2;
    tur[turn].start = 1-i; tur[turn].stop = 2-i;
    putpixel(map, (xc-2), (yc+2), TILE_TURRET);
    putpixel(turretmap, (xc-2),(yc+2),turn+1);
    turn++;
    tur[turn].used = TRUE;
    tur[turn].x = (xc+2) * TILE_SIZE + TILE_SIZE / 2;
    tur[turn].y = (yc-2) * TILE_SIZE + TILE_SIZE / 2;
    tur[turn].start = 1-i; tur[turn].stop = 2-i;
    putpixel(map, (xc+2), (yc-2), TILE_TURRET);
    putpixel(turretmap, (xc+2),(yc-2),turn+1);
    turn++;
    tur[turn].used = TRUE;
    tur[turn].x = (xc+2) * TILE_SIZE + TILE_SIZE / 2;
    tur[turn].y = (yc+2) * TILE_SIZE + TILE_SIZE / 2;
    tur[turn].start = 1-i; tur[turn].stop = 2-i;
    putpixel(map, (xc+2), (yc+2), TILE_TURRET);
    putpixel(turretmap, (xc+2),(yc+2),turn+1);
    turn++;
    }
    AANTAL_TURRETS = turn;
    create_random_walls();
    create_random_rocks();
    create_random_turrets();
    /*{BITMAP *temp = create_bitmap(MAPW,MAPH);
    if(!temp) MEMERR;
    clear(temp);
    for(y = MAPH-1; y >= 0; y--)
    for(x = MAPW-1; x >= 0; x--)
    {   if((get=_getpixel(map, x, y)) == TILE_WALL || get == TILE_ROCK) putpixel(temp, x, y, makecol(255,255,255));
    }
    floodfill(temp, (int)tnk[0].x/TILE_SIZE, (int)tnk[0].y/TILE_SIZE, makecol(255,0,0));
    blit(temp, screen, 0,0, 0,0, MAPW, MAPH);
    clear(temp);
    for(y = MAPH-1; y >= 0; y--)
    for(x = MAPW-1; x >= 0; x--)
    {   if((get=_getpixel(map, x, y)) == TILE_WALL || get == TILE_ROCK) putpixel(temp, x, y, makecol(255,255,255));
    }
    floodfill(temp, (int)tnk[1].x/TILE_SIZE, (int)tnk[1].y/TILE_SIZE, makecol(0,0,255));
    blit(temp, screen, 0,0, MAPW,0, MAPW, MAPH);
    destroy_bitmap(temp);
    }*/
}

