/* Author: Tobi Vollebregt */

/*  TankZone: My second Allegro game.
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

#include "tankzone.h"

int lighting_color,lighting_node_count=0,lighting_color_mask,lighting_cleanup_time;
LIGHT_TREE *light_tree[TILE_NUM];
BITMAP *light_map;

BITMAP *create_light_bitmap(int radius, int r, int g, int b)
{   BITMAP *bmp;
    int x,y,d,col;
    float a,q;
    bmp=create_bitmap_ex(24,2*radius,2*radius);
    if(bmp)
    {   a=1.0/radius;
    for(y=2*radius-1; y>=0; y--)
        for(x=2*radius-1; x >= 0; x--)
        {   d=(int)distance(radius,radius,x,y);
        q=(float)(radius-d)*a;
        q=MID(0.0, q, 1.0);
        col=makecol24((int)((float)r*q),(int)((float)g*q),(int)((float)b*q));
        if(col==0) col=makecol24(255,0,255);
        _putpixel24(bmp,x,y,col);
        }
    }
    return bmp;
}

void blur_area(BITMAP *bmp, int x1, int y1, int x2, int y2)
{   int x,y,c,r,g,b;
    assert(bmp);
    if(x1>x2) {c=x1; x1=x2; x2=c;}
    if(y1>y2) {c=y1; y1=y2; y2=c;}
    if(x1<bmp->cl) x1=bmp->cl;
    if(y1<bmp->ct) y1=bmp->ct;
    if(x2>=bmp->cr) x2=bmp->cr-1;
    if(y2>=bmp->cb) y2=bmp->cb-1;

    #define GET(x,y,bpp)    \
    c=_getpixel##bpp(bmp,(x),(y));  \
    r+=getr##bpp(c); g+=getg##bpp(c); b+=getb##bpp(c);

    #define PUT(x,y,bpp)    _putpixel##bpp(bmp,x,y,makecol##bpp(r,g,b));

    #define BLUR(bpp)   \
    for(y=y1+1; y<y2; y++)  \
    {   for(x=x1+1; x<x2; x++)  \
    {   r=g=b=0;    \
        GET(x,y,bpp); GET(x-1,y,bpp); GET(x+1,y,bpp); GET(x,y-1,bpp); GET(x,y+1,bpp);   \
        r/=5; g/=5; b/=5; PUT(x,y,bpp); \
    }   \
    }   \
    for(y=y1,x=x1+1; x<x2; x++) \
    {   r=g=b=0;    \
    GET(x,y,bpp); GET(x-1,y,bpp); GET(x+1,y,bpp); GET(x,y+1,bpp);   \
    r/=4; g/=4; b/=4; PUT(x,y,bpp); \
    }   \
    for(y=y2,x=x1+1; x<x2; x++) \
    {   r=g=b=0;    \
    GET(x,y,bpp); GET(x-1,y,bpp); GET(x+1,y,bpp); GET(x,y-1,bpp);   \
    r/=4; g/=4; b/=4; PUT(x,y,bpp); \
    }   \
    for(x=x1,y=y1+1; y<y2; y++) \
    {   r=g=b=0;    \
    GET(x,y,bpp); GET(x+1,y,bpp); GET(x,y-1,bpp); GET(x,y+1,bpp);   \
    r/=4; g/=4; b/=4; PUT(x,y,bpp); \
    }   \
    for(x=x2,y=y1+1; y<y2; y++) \
    {   r=g=b=0;    \
    GET(x,y,bpp); GET(x-1,y,bpp); GET(x,y-1,bpp); GET(x,y+1,bpp);   \
    r/=4; g/=4; b/=4; PUT(x,y,bpp); \
    }   \
    x=x1; y=y1; r=g=b=0;    \
    GET(x,y,bpp); GET(x+1,y,bpp); GET(x,y+1,bpp);   \
    r/=3; g/=3; b/=3; PUT(x,y,bpp); \
    x=x2; r=g=b=0;  \
    GET(x,y,bpp); GET(x-1,y,bpp); GET(x,y+1,bpp);   \
    r/=3; g/=3; b/=3; PUT(x,y,bpp); \
    x=x1; y=y2; r=g=b=0;    \
    GET(x,y,bpp); GET(x+1,y,bpp); GET(x,y-1,bpp);   \
    r/=3; g/=3; b/=3; PUT(x,y,bpp); \
    x=x2; r=g=b=0;  \
    GET(x,y,bpp); GET(x-1,y,bpp); GET(x,y-1,bpp);   \
    r/=3; g/=3; b/=3; PUT(x,y,bpp);

    switch(bitmap_color_depth(bmp))
    {   case 8: BLUR(8); break;
    case 15: BLUR(15); break;
    case 16: BLUR(16); break;
    case 24: BLUR(24); break;
    case 32: BLUR(32); break;
    }

    #undef BLUR
    #undef PUT
    #undef GET
}

LIGHT_TREE *create_light_node(int tile, int color)
{   LIGHT_TREE *n;
    if(!(n=(LIGHT_TREE *)malloc(sizeof(LIGHT_TREE)))) MEMERR;
    n->color=color;
    if(!(n->tile=create_bitmap(TILE_SIZE,TILE_SIZE))) MEMERR;
    set_mul_blender(getr24(color),getg24(color),getb24(color),0);
    draw_lit_sprite(n->tile,lnd[tile].dat,0,0,255);
    n->left=n->right=NULL;
    n->used=TRUE;
    lighting_node_count++;
    return n;
}

BITMAP *get_tile_from_tree(int tile, int color)
{   /* new version: shorter, not recursive (faster) and further optimalised */
    LIGHT_TREE *tree;
    int d;
    color&=lighting_color_mask;
    tree=light_tree[tile];
    if(!tree) tree=light_tree[tile]=create_light_node(tile,color);
    while((d=color-tree->color))
    {   if(d&0x80000000) /* color<tree->color */
    {   if(tree->left) tree=tree->left;
        else
        {   tree->left=create_light_node(tile,color);
        return tree->left->tile;
        }
    }else /* color>tree->color */
    {   if(tree->right) tree=tree->right;
        else
        {   tree->right=create_light_node(tile,color);
        return tree->right->tile;
        }
    }
    }
    tree->used=TRUE;
    return tree->tile;
}

void link_light_tree(LIGHT_TREE *n, LIGHT_TREE *tree)
{   // links part of lighting tree (n) at the right place in another tree (tree)
    if(n->color < tree->color)
    {   if(tree->left) link_light_tree(n,tree->left);
    else tree->left=n;
    }else
    {   if(tree->right) link_light_tree(n,tree->right);
    else tree->right=n;
    }
}

void cleanup_light_tree(LIGHT_TREE **from)
{
    LIGHT_TREE *tree=*from;

    if(tree)
    {   cleanup_light_tree(&tree->left);
    cleanup_light_tree(&tree->right);
    if(tree->tile && !tree->used)
    {   destroy_bitmap(tree->tile);
        tree->tile=NULL;
        if(tree->left)
        {   *from=tree->left;
        if(tree->right) link_light_tree(tree->right, tree->left);
        }else *from=tree->right;
        free(tree);
        lighting_node_count--;
        return;
    }
    tree->used=FALSE;
    }
}

void check_lighting_cleanup(void)
{
    int i;

    if(lighting_cleanup_time && game_time%lighting_cleanup_time==0)
    for(i=0; i<TILE_NUM; i++) cleanup_light_tree(&light_tree[i]);
}

void free_lighting_data(void)
{
    int i;

    for(i=0; i<TILE_NUM; i++)
    {   cleanup_light_tree(&light_tree[i]);
    cleanup_light_tree(&light_tree[i]);
    }
}
