/* Author: Tobi Vollebregt */

/*  TankZone: My second Allegro game.
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

#include "tankzone.h"

/* generate_flame(): Generates flames like the flames in the example of Allegro.
Anim should be an array of bitmap pointers, the bitmaps will be created within
this function. Frames is the number of frames, w is the width of the fire effect
and h is the height. B means boundary, ls is how fast the hotspots are moving
to the left and rs to the right. Hotspots is the number of hotspots and 
callback is called frames+h times during the calculation. It is passed the frame
currently animating. The first frame has number -h, and the last has number frame-1.
You can use this to display a progress indicator or something */

int generate_flame(BITMAP *anim[],int frames,int w,int h,int s,int hotspots,int hot,void (*callback)(int))
{   int frame,fs=192/h,c,c2,x,y;
    unsigned long address;
    unsigned char *temp=(unsigned char *)malloc(w);
    int *hotspot=(int *)malloc(hotspots*sizeof(int));
    BITMAP *bmp=create_bitmap_ex(8,w,h);
    if(!bmp) return 1;

    /* allocate memory for animation */
    for(c=0; c<frames; c++)
    {   anim[c]=create_bitmap_ex(8,w,h);
    if(!anim[c])
    {   for(c2=0; c2<c; c2++) destroy_bitmap(anim[c2]);
        destroy_bitmap(bmp);
        return 1;
    }
    }

    /* let hotspots start random */
    for(c=hotspots-1; c>=0; c--) hotspot[c]=hot+random()%(w-hot);

    for(frame=-h; frame<frames; frame++)
    {   /* zero the buffer */
    for(c=w-1; c>=0; c--) temp[c] = 0;
    for(c=hotspots-1; c>=0; c--)
    {   /* display the hotspots */
        for(c2=hotspot[c]-hot; c2<hotspot[c]+hot; c2++)
        if((c2>=0) && (c2<bmp->w))
            temp[c2]=MIN(temp[c2]+hot-ABS(hotspot[c]-c2),192);
        /* move the hotspots */
        hotspot[c]+=(random()%(s*2+1))-s; 
        if(hotspot[c]<hot) hotspot[c]=hot;
        else if(hotspot[c]>=w-hot) hotspot[c]=w-hot-1;
    }
    /* display the buffer */
    for(c=w-1; c>=0; c--)
    {   _putpixel(bmp,c,h-2,temp[c]);
        _putpixel(bmp,c,h-1,temp[c]/2);
    }

    bmp_select(bmp);
    for(y=0; y<h-1; y++)
    {   /* get an address for reading line y+1 */
        address=bmp_read_line(bmp,y+1);
        /* read line in 32 bit chunks */
        for(x=0; x<w; x+=sizeof(unsigned long))
        *((unsigned long *)&temp[x])=bmp_read32(address+x);
        /* adjust it */
        for(x=0; x<w; x++)
        {   if(temp[x]>=fs) temp[x]-=fs;
        else temp[x]=0;
        }
        /* get an address for writing line y */
        address=bmp_write_line(bmp,y);
        /* write line in 32 bit chunks */
        for(x=0; x<w; x += sizeof(unsigned long))
        bmp_write32(address+x,*((unsigned long *)&temp[x]));
    }
    bmp_unwrite_line(bmp);

    /* copy flame bitmap to animation frame */
    if(frame>=0) blit(bmp,anim[frame],0,0,0,0,w,h);
    if(callback) callback(frame);
    }

    destroy_bitmap(bmp);
    free(hotspot);
    free(temp);
    return 0;
}
