/* Author: Tobi Vollebregt */

/*  TankZone: My second Allegro game.
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

#ifndef __tjv_ENGINE_H__
#define __tjv_ENGINE_H__

#include <allegro.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct ENGINE_DRAWER_INFO
{   int mapx,mapy;
    int scrx,scry;
    int tile;
    int r,g,b;
} ENGINE_DRAWER_INFO;

typedef void (*ENGINE_DRAWER)(const ENGINE_DRAWER_INFO *);

int     engine_init(int size);
void    engine_exit(void);
int     engine_set_tile(int index, BITMAP *bmp);
int     engine_set_tile_ex(int index, BITMAP *bmp, ENGINE_DRAWER drawer);
void    engine_set_tile_drawer(int index, ENGINE_DRAWER drawer);
BITMAP *engine_get_tile(int index);
BITMAP *engine_get_tile_ex(int index, int r, int g, int b);
void    engine_draw_tile_ex(BITMAP *dst, int index, int x, int y, int r, int g, int b);
void    engine_set_tilemap(BITMAP *map, int xoffset, int yoffset);
void    engine_set_lightmap(BITMAP *map, int xoffset, int yoffset);
void    engine_set_destination(BITMAP *scrn);
BITMAP *engine_get_destination(void);
void    engine_set_gamma(int gamma);
int     engine_get_gamma(void);
void    engine_draw_scene(int x, int y);

int     engine_enable_cache(int size);
int     engine_enable_cache_ex(int size, int acc);
double  engine_get_cache_hit_percent(void);

int     engine_save_tileset(const char *filename, int pack);
int     engine_load_tileset(const char *filename);

void    engine_set_overlay (BITMAP* map, int index);

#ifdef __cplusplus
}   // End of extern "C"
#endif

#endif /* #ifndef __tjv_ENGINE_H__ */
