/* Author: Tobi Vollebregt */

/*  TankZone: My second Allegro game.
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

#include "tankzone.h"

#define BLEND(bpp, r, g, b)   _blender_trans##bpp(makecol##bpp(r, g, b), y, n)

//unsigned long _blender_trans15(unsigned long, unsigned long, unsigned long);
//unsigned long _blender_trans16(unsigned long, unsigned long, unsigned long);
//unsigned long _blender_trans24(unsigned long, unsigned long, unsigned long);

#ifdef ALLEGRO_COLOR16
/* 15 bit maximum color blender */
unsigned long max_blender15(unsigned long x, unsigned long y, unsigned long n)
{ return BLEND(15, MAX(getr15(x),getr15(y)), MAX(getg15(x),getg15(y)), MAX(getb15(x),getb15(y)));
}

/* 16 bit maximum color blender */
unsigned long max_blender16(unsigned long x, unsigned long y, unsigned long n)
{ return BLEND(16, MAX(getr16(x),getr16(y)), MAX(getg16(x),getg16(y)), MAX(getb16(x),getb16(y)));
}
#define MAXB15 max_blender15
#define MAXB16 max_blender16
#else
#define MAXB15 NULL
#define MAXB16 NULL
#endif /* #ifdef ALLEGRO_COLOR_16 */

#if (defined ALLEGRO_COLOR24) || (defined ALLEGRO_COLOR32)
/* 24 bit maximum color blender */
unsigned long max_blender24(unsigned long x, unsigned long y, unsigned long n)
{ return BLEND(24, MAX(getr24(x),getr24(y)), MAX(getg24(x),getg24(y)), MAX(getb24(x),getb24(y)));
}
#define MAXB24 max_blender24
#else
#define MAXB24 NULL
#endif /* #if (defined ALLEGRO_COLOR24) || (defined ALLEGRO_COLOR32) */

void set_max_blender(int r,int g,int b,int a) {set_blender_mode(MAXB15,MAXB16,MAXB24,r,g,b,a);}

#ifdef ALLEGRO_COLOR16
/* 15 bit minimum color blender */
unsigned long min_blender15(unsigned long x, unsigned long y, unsigned long n)
{ return BLEND(15, MIN(getr15(x),getr15(y)), MIN(getg15(x),getg15(y)), MIN(getb15(x),getb15(y)));
}

/* 16 bit minimum color blender */
unsigned long min_blender16(unsigned long x, unsigned long y, unsigned long n)
{ return BLEND(16, MIN(getr16(x),getr16(y)), MIN(getg16(x),getg16(y)), MIN(getb16(x),getb16(y)));
}
#define MINB15 min_blender15
#define MINB16 min_blender16
#else
#define MINB15 NULL
#define MINB16 NULL
#endif /* #ifdef ALLEGRO_COLOR_16 */

#if (defined ALLEGRO_COLOR24) || (defined ALLEGRO_COLOR32)
/* 24 bit minimum color blender */
unsigned long min_blender24(unsigned long x, unsigned long y, unsigned long n)
{ return BLEND(24, MIN(getr24(x),getr24(y)), MIN(getg24(x),getg24(y)), MIN(getb24(x),getb24(y)));
}
#define MINB24 min_blender24
#else
#define MINB24 NULL
#endif /* #if (defined ALLEGRO_COLOR24) || (defined ALLEGRO_COLOR32) */

void set_min_blender(int r,int g,int b,int a) {set_blender_mode(MINB15,MINB16,MINB24,r,g,b,a);}

/* 24 * a bit multiplier color blender (x=24 bit) */
unsigned long mul_blender(unsigned long x, unsigned long y)
{ unsigned long r, g, b;
  r = (getr24(x) * getr(y)) >> 7;
  g = (getg24(x) * getg(y)) >> 7;
  b = (getb24(x) * getb(y)) >> 7;
  return makecol(MIN(r,255), MIN(g,255), MIN(b,255));
}

#ifdef ALLEGRO_COLOR16
/* 15 bit multiplier color blender */
unsigned long mul_blender15(unsigned long x, unsigned long y, unsigned long n)
{ unsigned long r, g, b;
  r = (getr15(x) * getr15(y)) >> 7;
  g = (getg15(x) * getg15(y)) >> 7;
  b = (getb15(x) * getb15(y)) >> 7;
  return makecol15(MIN(r,255), MIN(g,255), MIN(b,255));
}

/* 16 bit multiplier color blender */
unsigned long mul_blender16(unsigned long x, unsigned long y, unsigned long n)
{ unsigned long r, g, b;
  r = (getr16(x) * getr16(y)) >> 7;
  g = (getg16(x) * getg16(y)) >> 7;
  b = (getb16(x) * getb16(y)) >> 7;
  return makecol16(MIN(r,255), MIN(g,255), MIN(b,255));
}
#define MULB15 mul_blender15
#define MULB16 mul_blender16
#else
#define MULB15 NULL
#define MULB16 NULL
#endif /* #ifdef ALLEGRO_COLOR_16 */

#if (defined ALLEGRO_COLOR24) || (defined ALLEGRO_COLOR32)
/* 24 bit multiplier color blender */
unsigned long mul_blender24(unsigned long x, unsigned long y, unsigned long n)
{ unsigned long r, g, b;
  r = (getr24(x) * getr24(y)) >> 7;
  g = (getg24(x) * getg24(y)) >> 7;
  b = (getb24(x) * getb24(y)) >> 7;
  return makecol24(MIN(r,255), MIN(g,255), MIN(b,255));
}
#define MULB24 mul_blender24
#else
#define MULB24 NULL
#endif /* #if (defined ALLEGRO_COLOR24) || (defined ALLEGRO_COLOR32) */

void set_mul_blender(int r,int g,int b,int a) {set_blender_mode(MULB15,MULB16,MULB24,r,g,b,a);}

#ifdef ALLEGRO_COLOR16
/* 15 bit lightlevel multiplier blender */
unsigned long mul2_blender15(unsigned long x, unsigned long y, unsigned long n)
{ unsigned long r, g, b;
  r = (getr15(x) * getr15(y) * n) >> 14;
  g = (getg15(x) * getg15(y) * n) >> 14;
  b = (getb15(x) * getr15(y) * n) >> 14;
  return makecol15(MIN(r,255), MIN(g,255), MIN(b,255));
}

/* 16 bit lightlevel multiplier blender */
unsigned long mul2_blender16(unsigned long x, unsigned long y, unsigned long n)
{ unsigned long r, g, b;
  r = (getr16(x) * getr16(y) * n) >> 14;
  g = (getg16(x) * getg16(y) * n) >> 14;
  b = (getb16(x) * getb16(y) * n) >> 14;
  return makecol16(MIN(r,255), MIN(g,255), MIN(b,255));
}
#define MUL2B15 mul2_blender15
#define MUL2B16 mul2_blender16
#else
#define MUL2B15 NULL
#define MUL2B16 NULL
#endif /* #ifdef ALLEGRO_COLOR_16 */

#if (defined ALLEGRO_COLOR24) || (defined ALLEGRO_COLOR32)
/* 24 bit lightlevel multiplier blender */
unsigned long mul2_blender24(unsigned long x, unsigned long y, unsigned long n)
{ unsigned long r, g, b;
  r = (getr24(x) * getr24(y) * n) >> 14;
  g = (getg24(x) * getg24(y) * n) >> 14;
  b = (getb24(x) * getb24(y) * n) >> 14;
  return makecol24(MIN(r,255), MIN(g,255), MIN(b,255));
}
#define MUL2B24 mul2_blender24
#else
#define MUL2B24 NULL
#endif /* #if (defined ALLEGRO_COLOR24) || (defined ALLEGRO_COLOR32) */

void set_mul2_blender(int r,int g,int b,int a) {set_blender_mode(MUL2B15,MUL2B16,MUL2B24,r,g,b,a);}

static int dissolve_pos;
static unsigned char dissolve_value[1024];

/* all colordepths pregenerated dissolve blender */
unsigned long dis_blender(unsigned long x, unsigned long y, unsigned long n)
{
    dissolve_pos = (dissolve_pos + 1) & 1023;

    return (dissolve_value[dissolve_pos]<n) ? x : y;
}

void set_dis_seed(int seed)
{
    dissolve_pos = seed;
}

void set_dis_blender(int r,int g,int b,int a)
{
    static int virgin=1;
    int i;

    if(virgin)
    {   for(i=0; i<1024; i++)
        dissolve_value[i]=random()&255;
    dissolve_pos=0;
    virgin=0;
    }

    set_blender_mode(dis_blender,dis_blender,dis_blender,r,g,b,a);
}
